/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.net.URISyntaxException;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import me.lucko.luckperms.lib.configurate.objectmapping.ObjectMappingException;
import me.lucko.luckperms.lib.configurate.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class URISerializer
implements TypeSerializer<URI> {
    URISerializer() {
    }

    @Override
    public URI deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        URI uri;
        String plainUri = value.getString();
        if (plainUri == null) {
            throw new ObjectMappingException("No value present in node " + value);
        }
        try {
            uri = new URI(plainUri);
        }
        catch (URISyntaxException e) {
            throw new ObjectMappingException("Invalid URI string provided for " + value.getKey() + ": got " + plainUri);
        }
        return uri;
    }

    @Override
    public void serialize(@NonNull TypeToken<?> type, @Nullable URI obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        value.setValue(obj.toString());
    }
}

