/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.util;

import galaxyspace.GalaxySpace;
import galaxyspace.core.GSFluids;
import galaxyspace.core.GSItems;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.fluid.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GSUtils {
    public static List<String> changelog = new ArrayList<String>();
    private static HashSet<BlockPos> checked;
    public static TextureAtlasSprite missingIcon;
    private static TextureMap texMap;
    public static String path;

    public static void initFluidTextures(TextureMap map) {
        missingIcon = map.func_174944_f();
        texMap = map;
    }

    public static TextureAtlasSprite getBlockTexture(Block block) {
        return GSUtils.getBlockTexture(block, "");
    }

    public static TextureAtlasSprite getBlockTexture(Block block, String addpath) {
        if (block == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = block.getRegistryName();
        TextureAtlasSprite sprite = texMap.func_110572_b(spriteLocation.func_110624_b() + ":blocks/" + spriteLocation.func_110623_a() + addpath);
        return sprite != null ? sprite : missingIcon;
    }

    public static TextureAtlasSprite getItemTexture(Item item, String addpath) {
        if (item == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = item.getRegistryName();
        TextureAtlasSprite sprite = texMap.func_110572_b(spriteLocation.func_110624_b() + ":items/" + spriteLocation.func_110623_a() + addpath);
        return sprite != null ? sprite : missingIcon;
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid, FluidType type) {
        if (fluid == null || type == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getStill() : fluid.getFlowing();
        TextureAtlasSprite sprite = texMap.getTextureExtry(spriteLocation.toString());
        return sprite != null ? sprite : missingIcon;
    }

    public static void displayGauge(int xPos, int yPos, int scale, FluidStack fluid, int side) {
        int renderRemaining;
        if (fluid == null) {
            return;
        }
        int guiWidth = 0;
        int guiHeight = 0;
        int start = 0;
        do {
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GSUtils.drawTexturedModalRect(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, GSUtils.getFluidTexture(fluid.getFluid(), FluidType.STILL), 16, 16 - (16 - renderRemaining));
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        double zLevel = 0.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static boolean testFuel(String name) {
        if (name.contains("helium")) {
            return true;
        }
        return name.contains("fuel");
    }

    public static int fillWithGCFuel(FluidTank tank, FluidStack liquid, boolean doFill, EntityTieredRocket rocket) {
        if (liquid != null && GSUtils.testFuel(FluidRegistry.getFluidName((FluidStack)liquid))) {
            FluidStack liquidInTank = tank.getFluid();
            if (liquid.isFluidEqual(new FluidStack(rocket.getRocketTier() > 10 ? GSFluids.HeliumHydrogen : GCFluids.fluidFuel, 1))) {
                if (liquidInTank == null) {
                    return tank.fill(new FluidStack(liquid.getFluid(), liquid.amount), doFill);
                }
                if (liquidInTank.amount < tank.getCapacity()) {
                    return tank.fill(new FluidStack(liquidInTank, liquid.amount), doFill);
                }
            }
        }
        return 0;
    }

    public static int getColor(int r, int g, int b, int a) {
        int color = a << 24 | r << 16 | g << 8 | b;
        return color - 0x1000000;
    }

    public static Vector3 getDimColor(Vector3 daycolor, Vector3 nightcolor, float starbrightness) {
        float night = starbrightness;
        float day = 1.0f - starbrightness;
        float dayColR = daycolor.floatX() / 255.0f;
        float dayColG = daycolor.floatY() / 255.0f;
        float dayColB = daycolor.floatZ() / 255.0f;
        float nightColR = nightcolor.floatX() / 255.0f;
        float nightColG = nightcolor.floatY() / 255.0f;
        float nightColB = nightcolor.floatZ() / 255.0f;
        return new Vector3((double)(dayColR * day + nightColR * night), (double)(dayColG * day + nightColG * night), (double)(dayColB * day + nightColB * night));
    }

    public static float calculateCelestialAngle(long worldtime, float ticks, float daylenght) {
        int j = (int)((float)worldtime % daylenght);
        float f1 = ((float)j + ticks) / daylenght - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    public static void checkFluidTankTransfer(NonNullList<ItemStack> stacks, int slot, FluidTank tank) {
        FluidStack liquid;
        if (FluidUtil.isValidContainer((ItemStack)((ItemStack)stacks.get(slot))) && (liquid = tank.getFluid()) != null) {
            if (liquid.getFluid() == GSFluids.LiquidEthaneMethane) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GSItems.EM_CANISTER);
            } else if (liquid.getFluid().getName().contains("methane")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)AsteroidsItems.methaneCanister);
            } else if (liquid.getFluid() == GSFluids.Helium3) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GSItems.HELIUM_CANISTER);
            } else if (liquid.getFluid() == GSFluids.HeliumHydrogen) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GSItems.HELIUM_HYDROGEN_CANISTER);
            } else if (liquid.getFluid().getName().contains("hydrogen")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GSItems.HYDROGEN_CANISTER);
            } else if (liquid.getFluid().getName().contains("ethane")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GSItems.ETHANE_CANISTER);
            } else if (liquid.getFluid().getName().contains("oxygen")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)AsteroidsItems.canisterLOX);
            } else if (liquid.getFluid().getName().contains("oil")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GCItems.oilCanister);
            } else if (liquid.getFluid().getName().contains("fuel")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GCItems.fuelCanister);
            } else if (liquid.getFluid().getName().contains("nirtogen")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)AsteroidsItems.canisterLN2);
            } else if (liquid.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1)) && ((ItemStack)stacks.get(slot)).func_77973_b() instanceof ItemBucket) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)Items.field_151133_ar);
            } else if (!liquid.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1)) || ((ItemStack)stacks.get(slot)).func_77973_b() instanceof ItemBucket) {
                if (liquid.getFluid() == GSFluids.NatureGas) {
                    FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GSItems.NATURE_GAS_CANISTER);
                } else {
                    FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)Items.field_151133_ar);
                }
            }
        }
    }

    public static boolean getThermalControl(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        checked = new HashSet();
        return GSUtils.testContactWithBreathableAir(world, block, pos, 0) == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized int testContactWithBreathableAir(World world, Block block, BlockPos pos, int limitCount) {
        checked.add(pos);
        if (block == GCBlocks.breatheableAir || block == GCBlocks.brightBreatheableAir) {
            return block.func_176201_c(world.func_180495_p(pos));
        }
        IBlockState state = world.func_180495_p(pos);
        if (block == null || block.func_149688_o(state) == Material.field_151579_a) {
            return -1;
        }
        boolean permeableFlag = false;
        if (!(block instanceof BlockLeaves)) {
            if (block.func_149662_c(state)) {
                if (!(block instanceof BlockGravel) && block.func_149688_o(state) != Material.field_151580_n && !(block instanceof BlockSponge)) return -1;
                permeableFlag = true;
            } else {
                ArrayList metaList;
                if (block instanceof BlockGlass || block instanceof BlockStainedGlass) {
                    return -1;
                }
                if (block instanceof BlockLiquid) {
                    return -1;
                }
                if (OxygenPressureProtocol.nonPermeableBlocks.containsKey(block) && ((metaList = (ArrayList)OxygenPressureProtocol.nonPermeableBlocks.get(block)).contains(-1) || metaList.contains(state.func_177230_c().func_176201_c(state)))) {
                    return -1;
                }
            }
        } else {
            permeableFlag = true;
        }
        if (limitCount >= 5) return -1;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Block newblock;
            int adjResult;
            BlockPos sidevec;
            if (!permeableFlag && !GSUtils.canBlockPassAirOnSide(world, block, pos, side) || checked.contains(sidevec = pos.func_177982_a(side.func_82601_c(), side.func_96559_d(), side.func_82599_e())) || (adjResult = GSUtils.testContactWithBreathableAir(world, newblock = world.func_180495_p(sidevec).func_177230_c(), sidevec, limitCount + 1)) < 0) continue;
            return adjResult;
        }
        return -1;
    }

    private static boolean canBlockPassAirOnSide(World world, Block block, BlockPos vec, EnumFacing side) {
        if (block instanceof IPartialSealableBlock) {
            return !((IPartialSealableBlock)block).isSealed(world, vec, side);
        }
        if (block instanceof BlockSlab) {
            IBlockState state = world.func_180495_p(vec);
            int meta = state.func_177230_c().func_176201_c(state);
            return !(side == EnumFacing.DOWN && (meta & 8) == 8 || side == EnumFacing.UP && (meta & 8) == 0);
        }
        if (block instanceof BlockFarmland || block instanceof BlockEnchantmentTable || block instanceof BlockLiquid) {
            return side != EnumFacing.UP;
        }
        if (block instanceof BlockPistonBase) {
            IBlockState state = world.func_180495_p(vec);
            if (((Boolean)state.func_177229_b((IProperty)BlockPistonBase.field_176320_b)).booleanValue()) {
                int meta0 = state.func_177230_c().func_176201_c(state);
                EnumFacing facing = BlockPistonBase.func_176317_b((int)meta0);
                return side != facing;
            }
            return false;
        }
        return !block.isSideSolid(world.func_180495_p(vec), (IBlockAccess)world, vec, EnumFacing.func_82600_a((int)(side.func_176745_a() ^ 1)));
    }

    public static void start() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = ClientUtil.getScaledRes((Minecraft)mc, (int)mc.field_71443_c, (int)mc.field_71440_d);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        try {
            String str;
            URL url = new URL("https://raw.githubusercontent.com/BlesseNtumble/GalaxySpace/1.12.2/1.12.2/changelog.txt");
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http.addRequestProperty("User-Agent", "Mozilla/4.76");
            BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
            int i = 0;
            while ((str = in.readLine()) != null) {
                String str2;
                if (mc.func_135016_M().func_135041_c().func_135034_a().startsWith("ru_")) {
                    ++i;
                    str2 = new String(str.getBytes(), "UTF-8");
                    if (!str2.startsWith("r.")) continue;
                    str2 = str2.replace("r.", "");
                    changelog.add(str2);
                    if (str2.length() <= 70) continue;
                    changelog.add("");
                    continue;
                }
                ++i;
                str2 = new String(str.getBytes(), "UTF-8");
                if (!str2.startsWith("e.")) continue;
                str2 = str.replace("e.", "");
                changelog.add(str2);
                if (str2.length() <= 70) continue;
                changelog.add("");
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addBlockJsonFiles(Block block, String addPath) {
        try {
            File blockStates = new File(path + "/blockstates/", block.func_149739_a().toLowerCase().substring(5) + ".json");
            File modelBlock = new File(path + "/models/block/", block.func_149739_a().toLowerCase().substring(5) + ".json");
            File modelItemBlock = new File(path + "/models/item/", block.func_149739_a().toLowerCase().substring(5) + ".json");
            if (!blockStates.exists()) {
                if (blockStates.createNewFile()) {
                    GSUtils.blockstateJson(block, blockStates);
                } else if (blockStates.exists()) {
                    GSUtils.blockstateJson(block, blockStates);
                }
            }
            if (!modelBlock.exists()) {
                if (modelBlock.createNewFile()) {
                    GSUtils.modelBlockJson(block, modelBlock, addPath);
                } else if (modelBlock.exists()) {
                    GSUtils.modelBlockJson(block, modelBlock, addPath);
                }
            }
            if (!modelItemBlock.exists()) {
                if (modelItemBlock.createNewFile()) {
                    GSUtils.modelItemBlockJson(block, modelItemBlock, addPath);
                } else if (modelItemBlock.exists()) {
                    GSUtils.modelItemBlockJson(block, modelItemBlock, addPath);
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void blockstateJson(Block block, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{\n \"variants\": {\n \"normal\": { \"model\" : \"galaxyspace:" + block.func_149739_a().toLowerCase().substring(5) + "\"}}}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelBlockJson(Block block, File file, String addPath) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{ \"parent\": \"block/cube_all\",  \"textures\": { \"all\" : \"galaxyspace:blocks/" + addPath + block.func_149739_a().toLowerCase().substring(5) + "\"}}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelItemBlockJson(Block block, File file, String addPath) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{\n\t\"parent\": \"galaxyspace:block/" + block.func_149739_a().toLowerCase().substring(5) + "\" \n}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public static void addItemJsonFiles(Item item) {
        GSUtils.addItemJsonFiles(item, "", item.func_77658_a().toLowerCase().substring(5));
    }

    public static void addItemJsonFiles(Item item, String folder) {
        GSUtils.addItemJsonFiles(item, folder, item.func_77658_a().toLowerCase().substring(5));
    }

    public static void addItemJsonFiles(Item item, String folder, String name) {
        try {
            File modelItemFile;
            File pathFolder = new File(path + "/models/item/" + folder);
            if (!pathFolder.exists()) {
                pathFolder.mkdirs();
            }
            if (!(modelItemFile = new File(pathFolder, name + ".json")).exists()) {
                if (modelItemFile.createNewFile()) {
                    GSUtils.modelItemJson(item, modelItemFile, folder);
                } else if (modelItemFile.exists()) {
                    GSUtils.modelItemJson(item, modelItemFile, folder);
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelItemJson(Item item, File file, String folder) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{ \"parent\": \"item/generated\",  \"textures\": { \"layer0\" : \"galaxyspace:items/" + folder + item.func_77658_a().toLowerCase().substring(5) + "\"}}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public static void addBlockMetadataJsonFiles(Block block, String[] variants, String property, String addPath) {
        try {
            File blockstateItemBlockMeta = new File(path + "/blockstates/", block.func_149739_a().toLowerCase().substring(5) + ".json");
            for (int i = 0; i < variants.length; ++i) {
                File modelBlockMeta = new File(path + "/models/block/" + addPath, variants[i] + ".json");
                File modelItemBlockMeta = new File(path + "/models/item/" + addPath, variants[i] + ".json");
                if (!modelBlockMeta.exists()) {
                    if (modelBlockMeta.createNewFile()) {
                        GSUtils.modelBlockMetaJson(block, variants, modelBlockMeta, i, addPath);
                    } else if (modelBlockMeta.exists()) {
                        GSUtils.modelBlockMetaJson(block, variants, modelBlockMeta, i, addPath);
                    }
                }
                if (modelItemBlockMeta.exists()) continue;
                if (modelItemBlockMeta.createNewFile()) {
                    GSUtils.modelItemBlockMetaJson(block, variants, modelItemBlockMeta, i, addPath);
                    continue;
                }
                if (!modelItemBlockMeta.exists()) continue;
                GSUtils.modelItemBlockMetaJson(block, variants, modelItemBlockMeta, i, addPath);
            }
            if (!blockstateItemBlockMeta.exists()) {
                if (blockstateItemBlockMeta.createNewFile()) {
                    GSUtils.blockstateItemBlockMetaJson(block, blockstateItemBlockMeta, variants, property);
                } else if (blockstateItemBlockMeta.exists()) {
                    GSUtils.blockstateItemBlockMetaJson(block, blockstateItemBlockMeta, variants, property);
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void blockstateItemBlockMetaJson(Block block, File file, String[] variants, String property) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{ \n\t\"variants\": { \n");
            for (int i = 0; i < variants.length; ++i) {
                String string = "\"" + property + "=" + variants[i] + "\": { \"model\": \"" + "galaxyspace" + ":" + variants[i] + "\"}";
                if (variants[i] != variants[0]) {
                    writer.write(", \n\t\t" + string);
                    continue;
                }
                writer.write("\t\t" + string);
            }
            writer.write("\n\t} \n}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelBlockMetaJson(Block block, String[] variants, File file, int i, String addPath) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{ \n\t\"parent\": \"block/cube_all\", \n \t\"textures\": { \"all\" : \"galaxyspace:blocks/" + addPath + variants[i] + "\"}\n}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelItemBlockMetaJson(Block block, String[] variants, File file, int i, String addPath) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{\n\t\"parent\": \"galaxyspace:block/" + variants[i] + "\" \n}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public static void addItemMetadataJsonFiles(Item item, String[] variants, String folder) {
        try {
            for (int i = 0; i < variants.length; ++i) {
                File modelVariantsItemMeta;
                File folders = new File(path + "/models/item/" + folder);
                if (!folders.exists()) {
                    folders.mkdirs();
                }
                if ((modelVariantsItemMeta = new File(path + "/models/item/" + folder, variants[i] + ".json")).exists()) continue;
                if (modelVariantsItemMeta.createNewFile()) {
                    GSUtils.modelVariantsItemMetaJson(item, variants, modelVariantsItemMeta, i, folder);
                    continue;
                }
                if (!modelVariantsItemMeta.exists()) continue;
                GSUtils.modelVariantsItemMetaJson(item, variants, modelVariantsItemMeta, i, folder);
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelVariantsItemMetaJson(Item item, String[] variants, File file, int i, String folder) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{ \"parent\": \"item/generated\",  \"textures\": { \"layer0\" : \"galaxyspace:items/" + folder + variants[i] + "\"}}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public static void renderDebugGui(GuiContainer gui, int width, int height) {
        boolean enable = GalaxySpace.debug;
        if (enable) {
            for (int i = 0; i < gui.field_147002_h.field_75151_b.size(); ++i) {
                int x = gui.field_147002_h.func_75139_a((int)i).field_75223_e;
                int y = gui.field_147002_h.func_75139_a((int)i).field_75221_f;
                gui.field_146297_k.field_71466_p.func_78276_b(EnumColor.WHITE + "" + gui.field_147002_h.func_75139_a(i).getSlotIndex(), width + x + 5, height + y + 5, 0x404040);
            }
        }
    }

    public static ItemStack findMatchingNASARecipe(List<INasaWorkbenchRecipe> recipes, IInventory craftMatrix) {
        for (INasaWorkbenchRecipe recipe : recipes) {
            if (!recipe.matches(craftMatrix)) continue;
            return recipe.getRecipeOutput();
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderItemIntoSlot(RenderItem re, ItemStack stack, int x, int y, Vec3d color) {
        GlStateManager.func_179094_E();
        GSUtils.renderItemModelIntoGUI(re, stack, x, y, re.func_184393_a(stack, (World)null, (EntityLivingBase)null), color);
        GSUtils.drawRect(x + 1, y + 1, x + 15, y + 15, -863270005, 100.5);
        GlStateManager.func_179121_F();
    }

    private static void renderItemModelIntoGUI(RenderItem re, ItemStack stack, int x, int y, IBakedModel bakedmodel, Vec3d color) {
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GSUtils.setupGuiTransform(x, y, bakedmodel.func_177556_c());
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        GSUtils.renderItem(re, stack, bakedmodel, color);
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d) {
        GlStateManager.func_179109_b((float)xPosition, (float)yPosition, (float)100.0f);
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
        if (isGui3d) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
    }

    private static void renderItem(RenderItem re, ItemStack stack, IBakedModel model, Vec3d color) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.func_188618_c()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179091_B();
                stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
            } else {
                GSUtils.renderModel(re, model, stack, color);
                if (stack.func_77962_s()) {
                    GSUtils.renderEffect(re, model);
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    private static void renderEffect(RenderItem re, IBakedModel model) {
        ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GSUtils.renderModel(re, model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GSUtils.renderModel(re, model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
    }

    private static void renderModel(RenderItem re, IBakedModel model, ItemStack stack, Vec3d color) {
        GSUtils.renderModel(re, model, GSUtils.getColor((int)(255.0 * color.field_72450_a), (int)(255.0 * color.field_72448_b), (int)(255.0 * color.field_72449_c), 255), stack);
    }

    private static void renderModel(RenderItem re, IBakedModel model, int color) {
        GSUtils.renderModel(re, model, color, ItemStack.field_190927_a);
    }

    private static void renderModel(RenderItem re, IBakedModel model, int color, ItemStack stack) {
        if (ForgeModContainer.allowEmissiveItems) {
            ForgeHooksClient.renderLitItem((RenderItem)re, (IBakedModel)model, (int)color, (ItemStack)stack);
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            re.func_191970_a(bufferbuilder, model.func_188616_a((IBlockState)null, enumfacing, 0L), color, stack);
        }
        re.func_191970_a(bufferbuilder, model.func_188616_a((IBlockState)null, (EnumFacing)null, 0L), color, stack);
        tessellator.func_78381_a();
    }

    public static void drawRect(int left, int top, int right, int bottom, int color, double zLevel) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)left, (double)bottom, zLevel).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, zLevel).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)top, zLevel).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, zLevel).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    static {
        texMap = null;
        path = "K://MCP/codding/1.12.2/src/main/resources/assets/galaxyspace/";
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }

    public static enum Module_Type {
        PLASMA_TOOLS,
        SPACESUIT,
        ROCKET,
        OXYGEN_TANK,
        ALL;

    }
}

