/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.shops.data;

import com.erigitic.shops.Shop;
import com.erigitic.shops.data.ImmutableShopData;
import com.erigitic.shops.data.ShopKeys;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.mutable.Value;

public class ShopData
extends AbstractSingleData<Shop, ShopData, ImmutableShopData> {
    public static final int CONTENT_VERSION = 1;

    public ShopData() {
        super(null, ShopKeys.SINGLE_SHOP);
    }

    public ShopData(Shop shop) {
        super((Object)shop, ShopKeys.SINGLE_SHOP);
    }

    public ShopData copy() {
        return new ShopData((Shop)this.getValue());
    }

    public ImmutableShopData asImmutable() {
        return new ImmutableShopData((Shop)this.getValue());
    }

    public int getContentVersion() {
        return 1;
    }

    public Optional<ShopData> from(DataContainer container) {
        Optional shopOpt;
        if (container.contains(ShopKeys.SINGLE_SHOP.getQuery()) && (shopOpt = container.getSerializable(ShopKeys.SINGLE_SHOP.getQuery(), Shop.class)).isPresent()) {
            Optional<ShopData> shopDataOpt = Optional.of(new ShopData((Shop)shopOpt.get()));
            return shopDataOpt;
        }
        return Optional.empty();
    }

    public Optional<ShopData> fill(DataHolder dataHolder, MergeFunction overlap) {
        ShopData shopData = (ShopData)((MergeFunction)Preconditions.checkNotNull((Object)overlap)).merge((ValueContainer)this.copy(), (ValueContainer)dataHolder.get(ShopData.class).orElse(this.copy()));
        return Optional.of(this.set(ShopKeys.SINGLE_SHOP, shopData.get(ShopKeys.SINGLE_SHOP).get()));
    }

    protected Value<Shop> getValueGetter() {
        return Sponge.getRegistry().getValueFactory().createValue(ShopKeys.SINGLE_SHOP, this.getValue(), this.getValue());
    }

    public DataContainer toContainer() {
        return super.toContainer().set(ShopKeys.SINGLE_SHOP, this.getValue());
    }

    public static class Builder
    extends AbstractDataBuilder<ShopData>
    implements DataManipulatorBuilder<ShopData, ImmutableShopData> {
        public Builder() {
            super(ShopData.class, 1);
        }

        public Optional<ShopData> buildContent(DataView container) throws InvalidDataException {
            Optional shopOpt;
            if (container.contains(ShopKeys.SINGLE_SHOP.getQuery()) && (shopOpt = container.getSerializable(ShopKeys.SINGLE_SHOP.getQuery(), Shop.class)).isPresent()) {
                Optional<ShopData> shopDataOpt = Optional.of(new ShopData((Shop)shopOpt.get()));
                return shopDataOpt;
            }
            return Optional.empty();
        }

        public ShopData create() {
            return new ShopData();
        }

        public Optional<ShopData> createFrom(DataHolder dataHolder) {
            return this.create().fill(dataHolder);
        }
    }
}

