/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.shops;

import com.erigitic.config.TECurrency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class ShopItem
implements DataSerializable {
    public static final DataQuery PRICE_QUERY = DataQuery.of((String[])new String[]{"Price"});
    private double price;

    public ShopItem(double price) {
        this.price = price;
    }

    public DataContainer toContainer() {
        return DataContainer.createNew().set(PRICE_QUERY, (Object)this.price).set(Queries.CONTENT_VERSION, (Object)1);
    }

    public int getContentVersion() {
        return 1;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public List<Text> getLore(TECurrency currency) {
        ArrayList<Text> lore = new ArrayList<Text>();
        lore.add(Text.of((Object[])new Object[]{TextColors.GRAY, "Price: ", TextColors.GOLD, currency.format(BigDecimal.valueOf(this.price), 2)}));
        return lore;
    }

    public static class Builder
    extends AbstractDataBuilder<ShopItem> {
        public Builder() {
            super(ShopItem.class, 1);
        }

        public Optional<ShopItem> buildContent(DataView container) throws InvalidDataException {
            if (container.contains(PRICE_QUERY)) {
                double price = (Double)container.getDouble(PRICE_QUERY).get();
                return Optional.of(new ShopItem(price));
            }
            return Optional.empty();
        }
    }
}

