/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.network;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.minecraft.network.INetHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.mod.network.SpongeRawChannel;

@ChannelHandler.Sharable
public class SpongeRawDataInboundHandler
extends SimpleChannelInboundHandler<FMLProxyPacket> {
    private final SpongeRawChannel channel;

    public SpongeRawDataInboundHandler(SpongeRawChannel channel) {
        this.channel = channel;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FMLProxyPacket msg) throws Exception {
        INetHandler iNetHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        if (iNetHandler instanceof RemoteConnection) {
            this.channel.handlePacket(msg, (RemoteConnection)iNetHandler);
        } else {
            ctx.fireChannelRead((Object)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        SpongeHooks.logSevere("SpongeRawDataInboundHandler exception", cause);
        super.exceptionCaught(ctx, cause);
    }
}

