/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.populator.RandomObject;
import org.spongepowered.common.world.gen.populators.RandomObjectPopulator;

public class RandomObjectBuilder
implements RandomObject.Builder {
    private VariableAmount count;
    private VariableAmount height;
    private double chance;
    private PopulatorObject object;

    public RandomObjectBuilder() {
        this.reset();
    }

    @Override
    public RandomObject.Builder perChunk(VariableAmount count) {
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)count);
        return this;
    }

    @Override
    public RandomObject.Builder height(VariableAmount height) {
        this.height = (VariableAmount)Preconditions.checkNotNull((Object)height);
        return this;
    }

    @Override
    public RandomObject.Builder object(PopulatorObject obj) {
        this.object = (PopulatorObject)Preconditions.checkNotNull((Object)obj);
        return this;
    }

    @Override
    public RandomObject.Builder spawnChance(double chance) {
        Preconditions.checkArgument((!Double.isNaN(chance) ? 1 : 0) != 0, (Object)"Chance must be a number.");
        Preconditions.checkArgument((!Double.isInfinite(chance) ? 1 : 0) != 0, (Object)"Chance cannot be infinite.");
        this.chance = chance;
        return this;
    }

    @Override
    public RandomObject.Builder from(RandomObject value) {
        return this.perChunk(value.getAttemptsPerChunk()).height(value.getHeightRange()).object(value.getObject()).spawnChance(value.getSpawnChance());
    }

    @Override
    public RandomObject.Builder reset() {
        this.count = null;
        this.height = VariableAmount.baseWithRandomAddition(0.0, 128.0);
        this.chance = 1.0;
        this.object = null;
        return this;
    }

    @Override
    public RandomObject build() throws IllegalStateException {
        RandomObjectPopulator pop = new RandomObjectPopulator(this.object, this.count, this.height, this.chance);
        return pop;
    }
}

