/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.data.persistence.ConfigurateTranslator;

public class DataTranslatorTypeSerializer<T>
implements TypeSerializer<T> {
    private final DataTranslator<T> dataTranslator;

    private DataTranslatorTypeSerializer(DataTranslator<T> dataTranslator) {
        this.dataTranslator = (DataTranslator)Preconditions.checkNotNull(dataTranslator, (Object)"dataTranslator");
    }

    @Override
    public T deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        try {
            return this.dataTranslator.translate(ConfigurateTranslator.instance().translate(value));
        }
        catch (InvalidDataException e) {
            throw new ObjectMappingException(e);
        }
    }

    @Override
    public void serialize(TypeToken<?> type, T obj, ConfigurationNode value) throws ObjectMappingException {
        try {
            ConfigurateTranslator.instance().translateDataToNode(value, this.dataTranslator.translate(obj));
        }
        catch (InvalidDataException e) {
            throw new ObjectMappingException("Could not serialize. Data was invalid.", e);
        }
    }

    public static <T> DataTranslatorTypeSerializer<T> from(DataTranslator<T> dataTranslator) {
        return new DataTranslatorTypeSerializer<T>(dataTranslator);
    }
}

