/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableIgniteableData;
import org.spongepowered.api.data.manipulator.mutable.entity.IgniteableData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeIgniteableData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class SpongeIgniteableData
extends AbstractData<IgniteableData, ImmutableIgniteableData>
implements IgniteableData {
    private int fireTicks;
    private int fireDelay;

    public SpongeIgniteableData(int fireTicks, int fireDelay) {
        super(IgniteableData.class);
        Preconditions.checkArgument((fireTicks > 0 ? 1 : 0) != 0, (Object)"");
        this.fireTicks = fireTicks;
        this.fireDelay = fireDelay;
        this.registerGettersAndSetters();
    }

    public SpongeIgniteableData() {
        this(10, 20);
    }

    @Override
    public MutableBoundedValue<Integer> fireTicks() {
        return SpongeValueFactory.boundedBuilder(Keys.FIRE_TICKS).defaultValue(10).minimum(1).maximum(Integer.MAX_VALUE).actualValue(this.fireTicks).build();
    }

    @Override
    public MutableBoundedValue<Integer> fireDelay() {
        return SpongeValueFactory.boundedBuilder(Keys.FIRE_DAMAGE_DELAY).defaultValue(20).minimum(0).maximum(Integer.MAX_VALUE).actualValue(this.fireDelay).build();
    }

    @Override
    public IgniteableData copy() {
        return new SpongeIgniteableData(this.fireTicks, this.fireDelay);
    }

    @Override
    public ImmutableIgniteableData asImmutable() {
        return new ImmutableSpongeIgniteableData(this.fireTicks, this.fireDelay);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.FIRE_TICKS, (Object)this.fireTicks).set(Keys.FIRE_DAMAGE_DELAY, (Object)this.fireDelay);
    }

    public int getFireTicks() {
        return this.fireTicks;
    }

    public SpongeIgniteableData setFireTicks(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0);
        this.fireTicks = value;
        return this;
    }

    public int getFireDelay() {
        return this.fireDelay;
    }

    public SpongeIgniteableData setFireDelay(int value) {
        this.fireDelay = value;
        return this;
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.FIRE_TICKS, this::getFireTicks);
        this.registerFieldSetter(Keys.FIRE_TICKS, this::setFireTicks);
        this.registerKeyValue(Keys.FIRE_TICKS, this::fireTicks);
        this.registerFieldGetter(Keys.FIRE_DAMAGE_DELAY, this::getFireDelay);
        this.registerFieldSetter(Keys.FIRE_DAMAGE_DELAY, this::setFireDelay);
        this.registerKeyValue(Keys.FIRE_DAMAGE_DELAY, this::fireDelay);
    }
}

