/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.gui;

import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.colors.ColorHelper;
import icbm.classic.lib.transform.region.Rectangle;
import icbm.classic.prefab.gui.GuiFormatHelpers;
import icbm.classic.prefab.gui.IGuiComponent;
import icbm.classic.prefab.gui.textbox.GuiTextFieldBase;
import icbm.classic.prefab.gui.tooltip.IToolTip;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TextInput<Output>
extends GuiTextFieldBase
implements IToolTip,
IGuiComponent {
    private static final int ERROR_COLOR = ColorHelper.toARGB(255, 1, 1, 255);
    private Consumer<Boolean> focusChangedCallback;
    private Function<Output, String> parseOutput;
    private ITextComponent errorFeedback = null;
    private Supplier<Output> sourceWatcher;
    private Consumer<Output> onSourceChange;
    private Output previousData;
    @Deprecated
    private final Rectangle boundBox;

    public TextInput(int componentId, FontRenderer fontrendererObj, int x, int y, int width, int height) {
        super(componentId, fontrendererObj, x, y, width, height);
        this.boundBox = new Rectangle(x, y, x + width + 1, y + height + 1);
    }

    public static TextInput<Vec3d> vec3dField(int id, FontRenderer fontRenderer, int x, int y, int width, int height, Supplier<Vec3d> getter, Consumer<Vec3d> setter, Consumer<Vec3d> network) {
        TextInput<Vec3d> fieldTarget = new TextInput<Vec3d>(id, fontRenderer, x, y, width, height);
        fieldTarget.simpleHandler(getter, setter, GuiFormatHelpers::parseVec3d);
        fieldTarget.setParseOutput(LanguageUtility::posFormatted);
        fieldTarget.setOnSourceChange(network);
        return fieldTarget;
    }

    public static TextInput<Integer> intField(int id, FontRenderer fontRenderer, int x, int y, int width, int height, Supplier<Integer> getter, Consumer<Integer> setter, Consumer<Integer> network) {
        TextInput<Integer> fieldTarget = new TextInput<Integer>(id, fontRenderer, x, y, width, height);
        fieldTarget.simpleHandler(getter, setter, GuiFormatHelpers::parseInt);
        fieldTarget.setOnSourceChange(network);
        return fieldTarget;
    }

    public static TextInput<String> textField(int id, FontRenderer fontRenderer, int x, int y, int width, int height, Supplier<String> getter, Consumer<String> setter, Consumer<String> network) {
        TextInput<String> fieldTarget = new TextInput<String>(id, fontRenderer, x, y, width, height);
        fieldTarget.stringHandler(getter, setter);
        fieldTarget.setOnSourceChange(network);
        return fieldTarget;
    }

    @Override
    public void onUpdate() {
        if (!this.func_146206_l() && this.sourceWatcher != null) {
            this.detectForChange();
        }
    }

    protected boolean detectForChange() {
        Output output = this.sourceWatcher.get();
        if (!Objects.equals(output, this.previousData)) {
            this.previousData = output;
            if (this.parseOutput != null) {
                this.func_146180_a(this.parseOutput.apply(output));
            } else {
                this.func_146180_a(output.toString());
            }
            return true;
        }
        return false;
    }

    public void func_146195_b(boolean isFocusedIn) {
        super.func_146195_b(isFocusedIn);
        if (!isFocusedIn) {
            this.errorFeedback = null;
        }
        if (this.focusChangedCallback != null) {
            this.focusChangedCallback.accept(isFocusedIn);
        }
        if (!isFocusedIn && this.detectForChange() && this.onSourceChange != null) {
            this.onSourceChange.accept(this.previousData);
        }
    }

    public TextInput<Output> simpleHandler(Supplier<Output> getter, Consumer<Output> setter, BiFunction<String, Consumer<Output>, String> validator) {
        this.sourceWatcher = getter;
        this.focusChangedCallback = state -> {
            String error;
            if (!state.booleanValue() && (error = (String)validator.apply(this.func_146179_b(), setter)) != null) {
                this.errorFeedback = new TextComponentTranslation(error, new Object[0]);
            }
        };
        return this;
    }

    public TextInput<String> stringHandler(Supplier<String> getter, Consumer<String> setter) {
        this.sourceWatcher = getter;
        this.focusChangedCallback = state -> {
            if (!state.booleanValue()) {
                setter.accept(this.func_146179_b());
            }
        };
        return this;
    }

    public void func_146194_f() {
        super.func_146194_f();
        if (this.func_146176_q() && this.func_146181_i() && this.isErrored()) {
            this.func_73730_a(this.field_146209_f, this.field_146209_f + this.field_146218_h, this.field_146210_g + this.field_146219_i, ERROR_COLOR);
        }
    }

    @Override
    public boolean isWithin(int cursorX, int cursorY) {
        return this.boundBox.isWithin(cursorX - this.container.getGuiLeft(), cursorY - this.container.getGuiTop());
    }

    @Override
    public ITextComponent getTooltip() {
        return this.getErrorFeedback();
    }

    public ITextComponent getErrorFeedback() {
        return this.errorFeedback;
    }

    public void setError(ITextComponent error) {
        this.errorFeedback = error;
    }

    public boolean isErrored() {
        return this.errorFeedback != null;
    }

    public void setFocusChangedCallback(Consumer<Boolean> focusChangedCallback) {
        this.focusChangedCallback = focusChangedCallback;
    }

    public void setParseOutput(Function<Output, String> parseOutput) {
        this.parseOutput = parseOutput;
    }

    public void setSourceWatcher(Supplier<Output> sourceWatcher) {
        this.sourceWatcher = sourceWatcher;
    }

    public void setOnSourceChange(Consumer<Output> onSourceChange) {
        this.onSourceChange = onSourceChange;
    }
}

