/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.transform.rotation;

import com.builtbroken.jlib.data.network.IByteBufReader;
import com.builtbroken.jlib.data.network.IByteBufWriter;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.data.vector.ITransform;
import icbm.classic.lib.transform.rotation.IRotation;
import icbm.classic.lib.transform.rotation.Quaternion;
import icbm.classic.lib.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class EulerAngle
implements Cloneable,
ITransform,
IByteBufWriter,
IByteBufReader,
IRotation {
    protected double yaw = 0.0;
    protected double pitch = 0.0;
    protected double roll = 0.0;

    public EulerAngle(double yaw, double pitch, double roll) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public EulerAngle(double yaw, double pitch) {
        this(yaw, pitch, 0.0);
    }

    public EulerAngle(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public EulerAngle(ByteBuf data) {
        this.readByteBuf(data);
    }

    public EulerAngle(EnumFacing direction) {
        switch (direction) {
            case DOWN: {
                this.pitch = -90.0;
                break;
            }
            case UP: {
                this.pitch = 90.0;
                break;
            }
            case NORTH: {
                this.yaw = 0.0;
                break;
            }
            case SOUTH: {
                this.yaw = 180.0;
                break;
            }
            case EAST: {
                this.yaw = -90.0;
                break;
            }
            case WEST: {
                this.yaw = 90.0;
            }
        }
    }

    public void set(double yaw, double pitch, double roll) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public void set(int index, double value) {
        if (index == 0) {
            this.yaw = value;
        }
        if (index == 1) {
            this.pitch = value;
        }
        if (index == 2) {
            this.roll = value;
        }
    }

    public EulerAngle set(EulerAngle other) {
        this.yaw = other.yaw;
        this.pitch = other.pitch;
        this.roll = other.roll;
        return this;
    }

    public EulerAngle add(double v) {
        this.yaw += v;
        this.pitch += v;
        this.roll += v;
        return this;
    }

    public EulerAngle add(EulerAngle other) {
        this.yaw += other.yaw;
        this.pitch += other.pitch;
        this.roll += other.roll;
        return this;
    }

    public EulerAngle multiply(double v) {
        this.yaw *= v;
        this.pitch *= v;
        this.roll *= v;
        return this;
    }

    public EulerAngle multiply(float v) {
        this.yaw *= (double)v;
        this.pitch *= (double)v;
        this.roll *= (double)v;
        return this;
    }

    public EulerAngle multiply(EulerAngle other) {
        this.yaw *= other.yaw;
        this.pitch *= other.pitch;
        this.roll *= other.roll;
        return this;
    }

    public EulerAngle reciprocal() {
        this.yaw = 1.0 / this.yaw;
        this.pitch = 1.0 / this.pitch;
        this.roll = 1.0 / this.roll;
        return this;
    }

    public EulerAngle ceil() {
        this.yaw = Math.ceil(this.yaw);
        this.pitch = Math.ceil(this.pitch);
        this.roll = Math.ceil(this.roll);
        return this;
    }

    public EulerAngle floor() {
        this.yaw = Math.floor(this.yaw);
        this.pitch = Math.floor(this.pitch);
        this.roll = Math.floor(this.roll);
        return this;
    }

    public EulerAngle round() {
        this.yaw = Math.round(this.yaw);
        this.pitch = Math.round(this.pitch);
        this.roll = Math.round(this.roll);
        return this;
    }

    public EulerAngle max(EulerAngle other) {
        return new EulerAngle(Math.max(this.yaw, other.yaw), Math.max(this.pitch, other.pitch), Math.max(this.roll, other.roll));
    }

    public EulerAngle min(EulerAngle other) {
        return new EulerAngle(Math.min(this.yaw, other.yaw), Math.min(this.pitch, other.pitch), Math.min(this.roll, other.roll));
    }

    public EulerAngle absoluteDifference(EulerAngle other) {
        return new EulerAngle(Math.abs(this.yaw - other.yaw), Math.abs(this.pitch - other.pitch), Math.abs(this.roll - other.roll));
    }

    public boolean isWithin(EulerAngle other, double error) {
        return other != null && this.isYawWithin(other.yaw, error) && this.isPitchWithin(other.pitch, error) && this.isRollWithin(other.roll, error);
    }

    public boolean isYawWithin(double yaw, double error) {
        double delta = this.distanceYaw(yaw);
        return delta <= error;
    }

    public boolean isPitchWithin(double pitch, double error) {
        double delta = this.distancePitch(pitch);
        return delta <= error;
    }

    public boolean isRollWithin(double roll, double error) {
        double delta = this.distanceRoll(roll);
        return delta <= error;
    }

    public final double distanceYaw(double yaw) {
        return EulerAngle.delta(this.yaw, yaw);
    }

    public final double distancePitch(double pitch) {
        return EulerAngle.delta(this.pitch, pitch);
    }

    public final double distanceRoll(double roll) {
        return EulerAngle.delta(this.roll, roll);
    }

    private static double delta(double a, double b) {
        return Math.abs((a + 360.0) % 360.0 - (b + 360.0) % 360.0);
    }

    @Override
    public IPos3D transform(IPos3D vector) {
        return new Pos(vector).transform(this.toQuaternion());
    }

    public Pos toPos() {
        return new Pos(this.x(), this.y(), this.z());
    }

    public double x() {
        return -Math.sin(this.yaw_radian()) * Math.cos(this.pitch_radian());
    }

    public double y() {
        return Math.sin(this.pitch_radian());
    }

    public double z() {
        return Math.sin(-Math.cos(this.yaw_radian()) * Math.cos(this.pitch_radian()));
    }

    public Quaternion toQuaternion() {
        double c1 = Math.cos(Math.toRadians(this.yaw) / 2.0);
        double s1 = Math.sin(Math.toRadians(this.yaw) / 2.0);
        double c2 = Math.cos(Math.toRadians(this.pitch) / 2.0);
        double s2 = Math.sin(Math.toRadians(this.pitch) / 2.0);
        double c3 = Math.cos(Math.toRadians(this.roll) / 2.0);
        double s3 = Math.sin(Math.toRadians(this.roll) / 2.0);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        double w = c1c2 * c3 - s1s2 * s3;
        double x = c1c2 * s3 + s1s2 * c3;
        double y = s1 * c2 * c3 + c1 * s2 * s3;
        double z = c1 * s2 * c3 - s1 * c2 * s3;
        return new Quaternion(w, x, y, z);
    }

    public double[] toArray() {
        return new double[]{this.yaw, this.pitch, this.roll};
    }

    public EulerAngle clone() {
        return new EulerAngle(this.yaw, this.pitch, this.roll);
    }

    public String toString() {
        return "EulerAngle[" + this.yaw + "," + this.pitch + "," + this.roll + "]";
    }

    @Deprecated
    public void writeByteBuf(ByteBuf data) {
        data.writeDouble(this.yaw);
        data.writeDouble(this.pitch);
        data.writeDouble(this.roll);
    }

    @Override
    public ByteBuf writeBytes(ByteBuf data) {
        data.writeDouble(this.yaw);
        data.writeDouble(this.pitch);
        data.writeDouble(this.roll);
        return data;
    }

    @Deprecated
    public void readByteBuf(ByteBuf data) {
        this.yaw = data.readDouble();
        this.pitch = data.readDouble();
        this.roll = data.readDouble();
    }

    @Override
    public EulerAngle readBytes(ByteBuf data) {
        this.yaw = data.readDouble();
        this.pitch = data.readDouble();
        this.roll = data.readDouble();
        return this;
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("yaw", this.yaw);
        nbt.func_74780_a("pitch", this.pitch);
        nbt.func_74780_a("roll", this.roll);
        return nbt;
    }

    public NBTTagCompound toNBT() {
        return this.writeNBT(new NBTTagCompound());
    }

    public EulerAngle readFromNBT(NBTTagCompound nbt) {
        this.yaw = nbt.func_74769_h("yaw");
        this.pitch = nbt.func_74769_h("pitch");
        this.roll = nbt.func_74769_h("roll");
        return this;
    }

    public EulerAngle clampTo360() {
        this.yaw = EulerAngle.clampAngleTo360(this.yaw);
        this.pitch = EulerAngle.clampAngleTo360(this.pitch);
        this.roll = EulerAngle.clampAngleTo360(this.roll);
        return this;
    }

    public EulerAngle lerp(EulerAngle aim, double deltaTime) {
        this.yaw = this.lerp(this.yaw, aim.yaw, deltaTime);
        this.pitch = this.lerp(this.pitch, aim.pitch, deltaTime);
        this.roll = this.lerp(this.roll, aim.roll, deltaTime);
        return this;
    }

    private final double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    public EulerAngle moveTowards(EulerAngle aim, double speed, double deltaTime) {
        this.moveYaw(aim.yaw, speed, deltaTime);
        this.movePitch(aim.pitch, speed, deltaTime);
        this.moveRoll(aim.roll, speed, deltaTime);
        return this;
    }

    public static double moveToAngle(double current, double target, double movement) {
        if (movement <= 0.0) {
            return current;
        }
        double targetAngle = (target % 360.0 + 360.0) % 360.0;
        double currentAngle = (current % 360.0 + 360.0) % 360.0;
        double diff = Math.abs(targetAngle - currentAngle);
        if (diff < movement) {
            return targetAngle;
        }
        if (diff < 180.0) {
            if (currentAngle < targetAngle) {
                return currentAngle + movement;
            }
            return currentAngle - movement;
        }
        if (currentAngle < targetAngle) {
            return currentAngle - movement;
        }
        return currentAngle + movement;
    }

    public EulerAngle moveYaw(double targetYaw, double speed, double deltaTime) {
        this.setYaw(EulerAngle.moveToAngle(this.yaw, targetYaw, speed * deltaTime));
        return this;
    }

    public EulerAngle movePitch(double targetPitch, double speed, double deltaTime) {
        this.setPitch(EulerAngle.moveToAngle(this.pitch, targetPitch, speed * deltaTime));
        return this;
    }

    public EulerAngle moveRoll(double targetRoll, double speed, double deltaTime) {
        this.setRoll(EulerAngle.moveToAngle(this.roll, targetRoll, speed * deltaTime));
        return this;
    }

    public static double clampAngleTo360(double value) {
        return EulerAngle.clampAngle(value, -360.0, 360.0);
    }

    public static double clampAngle(double value, double min, double max) {
        double result;
        for (result = value % 360.0; result < min; result += 360.0) {
        }
        while (result > max) {
            result -= 360.0;
        }
        return result;
    }

    public static double clampPos360(double value) {
        double result;
        for (result = value % 360.0; result < 0.0; result += 360.0) {
        }
        while (result > 360.0) {
            result -= 360.0;
        }
        return result;
    }

    @Override
    public double yaw() {
        return this.yaw;
    }

    @Override
    public double pitch() {
        return this.pitch;
    }

    @Override
    public double roll() {
        return this.roll;
    }

    public double yaw_radian() {
        return Math.toRadians(this.yaw);
    }

    public double pitch_radian() {
        return Math.toRadians(this.pitch);
    }

    public double roll_radian() {
        return Math.toRadians(this.roll);
    }

    public boolean isZero() {
        return this.isYawZero() && this.isPitchZero() && this.isRollZero();
    }

    public boolean isYawZero() {
        return this.yaw <= 1.0E-5 && this.yaw >= -1.0E-5;
    }

    public boolean isPitchZero() {
        return this.pitch <= 1.0E-5 && this.pitch >= -1.0E-5;
    }

    public boolean isRollZero() {
        return this.roll <= 1.0E-5 && this.roll >= -1.0E-5;
    }

    @Deprecated
    public void yaw_$eq(double v) {
        this.yaw = v;
    }

    @Deprecated
    public void pitch_$eq(double v) {
        this.pitch = v;
    }

    @Deprecated
    public void roll_$eq(double v) {
        this.roll = v;
    }

    public void setYaw(double v) {
        this.yaw = v;
    }

    public void setPitch(double v) {
        this.pitch = v;
    }

    public void setRoll(double v) {
        this.roll = v;
    }
}

