/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.capability.ex;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.refs.ICBMExplosives;
import icbm.classic.api.reg.IExplosiveData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CapabilityExplosiveEntity
implements IExplosive {
    public final Entity entity;
    private ItemStack stack = ItemStack.field_190927_a;

    public CapabilityExplosiveEntity(@Nonnull Entity entity) {
        this.entity = entity;
    }

    public NBTTagCompound serializeNBT() {
        return this.toStack().serializeNBT();
    }

    public void deserializeNBT(@Nonnull NBTTagCompound nbt) {
        this.stack = nbt.func_186856_d() == 0 ? ItemStack.field_190927_a : new ItemStack(nbt);
    }

    @Override
    @Nullable
    public IExplosiveData getExplosiveData() {
        IExplosive explosive;
        ItemStack stack = this.toStack();
        if (stack.hasCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null) && (explosive = (IExplosive)stack.getCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null)) != null) {
            return explosive.getExplosiveData();
        }
        return ICBMExplosives.CONDENSED;
    }

    @Override
    @Nonnull
    public NBTTagCompound getCustomBlastData() {
        NBTTagCompound tag;
        IExplosive explosive;
        ItemStack stack = this.toStack();
        if (stack.hasCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null) && (explosive = (IExplosive)stack.getCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null)) != null && (tag = explosive.getCustomBlastData()) != null && !tag.func_82582_d()) {
            return tag;
        }
        return new NBTTagCompound();
    }

    @Override
    @Nonnull
    public ItemStack toStack() {
        if (this.stack == null) {
            this.stack = ItemStack.field_190927_a;
        }
        return this.stack;
    }

    @Override
    public void onDefuse() {
        this.entity.field_70170_p.func_72838_d((Entity)new EntityItem(this.entity.field_70170_p, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, this.toStack().func_77946_l()));
        this.entity.func_70106_y();
    }

    public void setStack(@Nonnull ItemStack stack) {
        if (!stack.hasCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null)) {
            ICBMClassic.logger().error("CapabilityExplosive[" + this.entity + "] Was set with a stack that is not an explosive [" + stack + "]");
        }
        this.stack = stack.func_77946_l().func_77979_a(1);
    }

    public int hashCode() {
        return 31 * this.stack.func_77973_b().hashCode() + this.stack.func_77952_i();
    }

    public boolean equals(Object other) {
        return super.equals(other) || other instanceof IExplosive && ItemStack.func_179545_c((ItemStack)((IExplosive)other).toStack(), (ItemStack)this.toStack());
    }

    public String toString() {
        return String.format("CapabilityExplosiveEntity[%s]@%s", this.toStack(), super.hashCode());
    }
}

