/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.flight;

import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.missiles.parts.IMissileFlightLogic;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class DeadFlightLogic
implements IMissileFlightLogic {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "dead");
    public int fuelTicks = 0;

    public DeadFlightLogic() {
    }

    public DeadFlightLogic(int fuelTicks) {
        this.fuelTicks = fuelTicks;
    }

    @Override
    public boolean shouldRunEngineEffects(Entity entity) {
        return this.hasFuel(entity);
    }

    protected boolean hasFuel(Entity entity) {
        return this.fuelTicks > 0;
    }

    @Override
    public void onEntityTick(Entity entity, IMissile missile, int ticksInAir) {
        --this.fuelTicks;
        if (this.hasFuel(entity)) {
            float f3 = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y));
            entity.field_70126_B = entity.field_70177_z = (float)(Math.atan2(entity.field_70159_w, entity.field_70179_y) * 180.0 / Math.PI);
            entity.field_70127_C = entity.field_70125_A = (float)(Math.atan2(entity.field_70181_x, f3) * 180.0 / Math.PI);
        }
    }

    @Override
    public boolean shouldAlignWithMotion(Entity entity) {
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("fuel", this.fuelTicks);
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound save) {
        if (save.func_74764_b("fuel")) {
            this.fuelTicks = save.func_74762_e("fuel");
        }
    }

    @Override
    public <V> V predictPosition(Entity entity, IMissileFlightLogic.VecBuilderFunc<V> builder, int ticks) {
        return builder.apply(entity.field_70165_t + entity.field_70159_w * (double)ticks, entity.field_70163_u + entity.field_70181_x * (double)ticks, entity.field_70161_v + entity.field_70179_y * (double)ticks);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return REG_NAME;
    }

    @Override
    public boolean shouldDecreaseMotion(Entity entity) {
        return !this.hasFuel(entity);
    }

    public boolean equals(Object other) {
        if (other instanceof DeadFlightLogic) {
            return this.fuelTicks == ((DeadFlightLogic)other).fuelTicks && this.getRegistryName() == ((DeadFlightLogic)other).getRegistryName();
        }
        return false;
    }
}

