/*
 * Decompiled with CFR 0.152.
 */
package its_meow.openscreens.client.renderer.tileentity;

import its_meow.openscreens.common.tileentity.TileEntityHoloScreen;
import li.cil.oc.Settings;
import li.cil.oc.util.RenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import org.lwjgl.opengl.GLContext;

public class RenderHoloScreen
extends TileEntitySpecialRenderer<TileEntityHoloScreen> {
    public double maxRenderDistanceSq = Settings.get().maxScreenTextRenderDistance() * Settings.get().maxScreenTextRenderDistance();
    public double fadeDistanceSq = Settings.get().screenTextFadeStartDistance() * Settings.get().screenTextFadeStartDistance();
    public double fadeRatio = 1.0 / (this.maxRenderDistanceSq - this.fadeDistanceSq);
    public TileEntityHoloScreen screen = null;
    public boolean canUseBlendColor;

    public RenderHoloScreen() {
        this.canUseBlendColor = GLContext.getCapabilities().OpenGL14;
    }

    public void render(TileEntityHoloScreen te, double x, double y, double z, float partialTicks, int destroyStage, float a) {
        if (te.height() < 1 || te.width() < 1) {
            return;
        }
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".render: entering (aka: wasntme)"));
        this.screen = te;
        if (!this.screen.isOrigin()) {
            return;
        }
        double distance = this.playerDistanceSq() / (double)Math.min(this.screen.width(), this.screen.height());
        if (distance > this.maxRenderDistanceSq) {
            return;
        }
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".render: checks"));
        RenderState.pushAttrib();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)255.0f, (float)255.0f);
        RenderState.disableEntityLighting();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".render: setup"));
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".render: fade"));
        if (this.screen.buffer().isRenderingEnabled()) {
            this.draw();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        RenderState.enableEntityLighting();
        GlStateManager.func_179121_F();
        RenderState.popAttrib();
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".render: leaving"));
    }

    public void transform() {
        switch (this.screen.yaw()) {
            case WEST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.func_179109_b((float)0.0f, (float)this.screen.height(), (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
    }

    private void draw() {
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".draw: entering (aka: wasntme)"));
        float sx = this.screen.width();
        float sy = this.screen.height();
        float tw = sx * 16.0f;
        float th = sy * 16.0f;
        this.transform();
        float border = 0.5f;
        int hex = this.screen.getColor();
        if (hex == 0xABABAB || hex == 0x444444) {
            hex = 0;
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        float r = (hex & 0xFF0000) >> 16;
        float g = (hex & 0xFF00) >> 8;
        float b = (hex & 0xFF) >> 0;
        r *= 255.0f;
        g *= 255.0f;
        b *= 255.0f;
        float a = 0.25f;
        EntityPlayerSP ep = Minecraft.func_71410_x().field_71439_g;
        if (ep.field_70170_p != null) {
            boolean foundMeow = false;
            for (EntityPlayer player : ep.field_70170_p.func_72872_a(EntityPlayer.class, ep.func_174813_aQ().func_186662_g(10.0))) {
                if (!player.func_146103_bH().getId().toString().equals("81d9726a-56d4-4419-9a2a-be1d7f7f7ef1") || player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() != Items.field_151137_ax) continue;
                foundMeow = true;
            }
            if (foundMeow) {
                float partialTicks = Minecraft.func_71410_x().func_184121_ak();
                int i = ep.field_70173_aa / 25 + ep.func_145782_y();
                int j = EnumDyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f = ((float)(ep.field_70173_aa % 25) + partialTicks) / 25.0f;
                float[] afloat1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)k));
                float[] afloat2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)l));
                r = afloat1[0] * (1.0f - f) + afloat2[0] * f;
                g = afloat1[1] * (1.0f - f) + afloat2[1] * f;
                b = afloat1[2] * (1.0f - f) + afloat2[2] * f;
            }
        }
        GlStateManager.func_179129_p();
        if (this.screen.width() > 1) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)(this.screen.height() - 1), (double)-0.46);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179090_x();
            Tessellator t = Tessellator.func_178181_a();
            BufferBuilder buff = t.func_178180_c();
            buff.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buff.func_181662_b(0.0, 0.6, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buff.func_181662_b(1.0, 0.6, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buff.func_181662_b((double)((float)(this.screen.width() + 1) / 2.0f), 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buff.func_181662_b((double)(-((float)(this.screen.width() - 1) / 2.0f)), 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            t.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179109_b((float)(-(sx - 1.0f) / 2.0f), (float)-1.0f, (float)0.0f);
        a = 0.5f;
        this.drawBackground(r, g, b, a);
        GlStateManager.func_179109_b((float)(sx * border / tw), (float)(sy * border / th), (float)0.0f);
        float isx = sx - border / 8.0f;
        float isy = sy - border / 8.0f;
        float sizeX = this.screen.buffer().renderWidth();
        float sizeY = this.screen.buffer().renderHeight();
        float scaleX = isx / sizeX;
        float scaleY = isy / sizeY;
        if (scaleX > scaleY) {
            GlStateManager.func_179109_b((float)(sizeX * 0.5f * (scaleX - scaleY)), (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)scaleY, (float)scaleY, (float)1.0f);
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)(sizeY * 0.5f * (scaleY - scaleX)), (float)0.0f);
            GlStateManager.func_179152_a((float)scaleX, (float)scaleX, (float)1.0f);
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.45);
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".draw: setup"));
        this.screen.buffer().renderText();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.02);
        this.screen.buffer().renderText();
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".draw: text"));
        GlStateManager.func_179089_o();
    }

    private void drawBackground(float r, float g, float b, float a) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.46);
        RenderHoloScreen.drawColoredQuad(r, g, b, a, 0.0f, 0.0f, this.screen.width(), this.screen.height());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.001);
        float a1 = 0.75f;
        RenderHoloScreen.drawColoredQuad(r, g, b, a1, 0.0f, 0.0f, 0.01f, this.screen.height());
        RenderHoloScreen.drawColoredQuad(r, g, b, a1, (float)this.screen.width() - 0.01f, 0.0f, this.screen.width(), this.screen.height());
        if (this.screen.width() == 1) {
            RenderHoloScreen.drawColoredQuad(r, g, b, a1, 0.0f, (float)this.screen.height() - 0.01f, this.screen.width(), this.screen.height());
        }
        RenderHoloScreen.drawColoredQuad(r, g, b, a1, 0.0f, 0.0f, this.screen.width(), 0.01f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.002);
        RenderHoloScreen.drawColoredQuad(r, g, b, a1, 0.0f, 0.0f, 0.01f, this.screen.height());
        RenderHoloScreen.drawColoredQuad(r, g, b, a1, (float)this.screen.width() - 0.01f, 0.0f, this.screen.width(), this.screen.height());
        if (this.screen.width() == 1) {
            RenderHoloScreen.drawColoredQuad(r, g, b, a1, 0.0f, (float)this.screen.height() - 0.01f, this.screen.width(), this.screen.height());
        }
        RenderHoloScreen.drawColoredQuad(r, g, b, a1, 0.0f, 0.0f, this.screen.width(), 0.01f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private static void drawColoredQuad(float r, float g, float b, float a, float x1, float y1, float x2, float y2) {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buff = t.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        buff.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b((double)x1, (double)y2, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buff.func_181662_b((double)x2, (double)y2, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buff.func_181662_b((double)x2, (double)y1, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buff.func_181662_b((double)x1, (double)y1, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public double playerDistanceSq() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        AxisAlignedBB bounds = this.screen.getRenderBoundingBox();
        double px = player.field_70165_t;
        double py = player.field_70163_u;
        double pz = player.field_70161_v;
        double ex = bounds.field_72336_d - bounds.field_72340_a;
        double ey = bounds.field_72337_e - bounds.field_72338_b;
        double ez = bounds.field_72334_f - bounds.field_72339_c;
        double cx = bounds.field_72340_a + ex * 0.5;
        double cy = bounds.field_72338_b + ey * 0.5;
        double cz = bounds.field_72339_c + ez * 0.5;
        double dx = px - cx;
        double dy = py - cy;
        double dz = pz - cz;
        return RenderHoloScreen.fixDiff(dx, ex) + RenderHoloScreen.fixDiff(dy, ey) + RenderHoloScreen.fixDiff(dz, ez);
    }

    private static double fixDiff(double a, double b) {
        if (a < -b) {
            double d = a + b;
            return d * d;
        }
        if (a > b) {
            double d = a - b;
            return d * d;
        }
        return 0.0;
    }
}

