/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.textures;

import ic2.core.IC2;
import ic2.core.fluid.IC2Fluid;
import ic2.core.platform.textures.Sprites;
import ic2.core.platform.textures.SubIconManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Ic2Icons {
    public static Ic2Icons instance = new Ic2Icons();
    static Map<String, TextureAtlasSprite[]> textures = new HashMap<String, TextureAtlasSprite[]>();
    static Map<String, TextureAtlasSprite[][]> simpleTexCache = new HashMap<String, TextureAtlasSprite[][]>();
    static Map<String, String> iconToFile = new HashMap<String, String>();
    static Map<String, Sprites.SpriteData> iconIDToData = new HashMap<String, Sprites.SpriteData>();
    static List<Sprites.TextureEntry> texturesToLoad = new ArrayList<Sprites.TextureEntry>();
    static List<Sprites.SpecialEntry> specialTexturesToLoad = new ArrayList<Sprites.SpecialEntry>();
    static Map<Sprites.CustomIconIndex, ResourceLocation> customIcons = new LinkedHashMap<Sprites.CustomIconIndex, ResourceLocation>();
    static TextureAtlasSprite[] energyPacket = new TextureAtlasSprite[2];
    static TextureAtlasSprite plasmaTexture;

    public static TextureAtlasSprite getEnergyPacketTexture(boolean in) {
        return energyPacket[in ? 1 : 0];
    }

    public static TextureAtlasSprite getPlasmaTexture() {
        return plasmaTexture;
    }

    public static TextureAtlasSprite[] getTextures(String par1) {
        return textures.get(par1);
    }

    public static TextureAtlasSprite[][] getArrayTextures(String id) {
        TextureAtlasSprite[] sprites;
        Sprites.SpriteData data;
        TextureAtlasSprite[][] cache = simpleTexCache.get(id);
        if (cache == null && (data = iconIDToData.get(id)) != null && (sprites = textures.get(id)) != null) {
            cache = new TextureAtlasSprite[data.info.maxX][data.info.maxY];
            for (int x = 0; x < data.info.maxX; ++x) {
                for (int y = 0; y < data.info.maxY; ++y) {
                    cache[x][y] = sprites[x + y * data.info.maxX];
                }
            }
            simpleTexCache.put(id, cache);
        }
        return cache;
    }

    public static void reset() {
        simpleTexCache.clear();
        textures.clear();
        iconToFile.clear();
        iconIDToData.clear();
        texturesToLoad.clear();
        specialTexturesToLoad.clear();
        customIcons.clear();
        energyPacket = new TextureAtlasSprite[2];
        Ic2Icons.addSprite(new Sprites.SpriteData("b0", "ic2:textures/sprites/block_0.png", new Sprites.SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bc", "ic2:textures/sprites/crops_0.png", new Sprites.SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bgen", "ic2:textures/sprites/block_generator.png", new Sprites.SpriteInfo(17, 12)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bgenComp", "ic2:textures/sprites/block_generator_compact.png", new Sprites.SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bmach_lv", "ic2:textures/sprites/block_machine_LV.png", new Sprites.SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bmach_lv_2", "ic2:textures/sprites/block_machine_LV_2.png", new Sprites.SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bmach_mv", "ic2:textures/sprites/block_machine_MV.png", new Sprites.SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bmach_hv", "ic2:textures/sprites/block_machine_HV.png", new Sprites.SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bpersonal", "ic2:textures/sprites/block_personal.png", new Sprites.SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bpersonalE", "ic2:textures/sprites/block_personal_Energy.png", new Sprites.SpriteInfo(3, 6)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bcable", "ic2:textures/sprites/block_cable.png", new Sprites.SpriteInfo(17, 17)));
        Ic2Icons.addSprite(new Sprites.SpriteData("belec", "ic2:textures/sprites/block_electric.png", new Sprites.SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new Sprites.SpriteData("i0", "ic2:textures/sprites/item_0.png", new Sprites.SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new Sprites.SpriteData("i1", "ic2:textures/sprites/item_1.png", new Sprites.SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new Sprites.SpriteData("i2", "ic2:textures/sprites/item_2.png", new Sprites.SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new Sprites.SpriteData("i3", "ic2:textures/sprites/item_3.png", new Sprites.SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new Sprites.SpriteData("batBox", "ic2:textures/sprites/Batbox.png", new Sprites.SpriteInfo(4, 6)));
        Ic2Icons.addSprite(new Sprites.SpriteData("mfe", "ic2:textures/sprites/MFE.png", new Sprites.SpriteInfo(4, 6)));
        Ic2Icons.addSprite(new Sprites.SpriteData("mfsu", "ic2:textures/sprites/MFSU.png", new Sprites.SpriteInfo(4, 6)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bBox", "ic2:textures/sprites/BatteryStation.png", new Sprites.SpriteInfo(4, 6)));
        Ic2Icons.addSprite(new Sprites.SpriteData("CPad", "ic2:textures/sprites/block_pads.png", new Sprites.SpriteInfo(4, 12)));
        Ic2Icons.addSprite(new Sprites.SpriteData("Gui", "ic2:textures/sprites/GuiIcons.png", new Sprites.SpriteInfo(5, 5)));
        Ic2Icons.addSprite(new Sprites.SpriteData("pesu", "ic2:textures/sprites/PESU.png", new Sprites.SpriteInfo(4, 6)));
        Ic2Icons.addSprite(new Sprites.SpriteData("bcable2", "ic2:textures/sprites/block_cable_2.png", new Sprites.SpriteInfo(17, 16)));
        Ic2Icons.addSprite(new Sprites.SpriteData("slots", "ic2:textures/sprites/slot_icons.png", new Sprites.SpriteInfo(16, 4)));
        ArrayList<Sprites.TextureEntry> normal = new ArrayList<Sprites.TextureEntry>();
        ArrayList<Sprites.SpecialEntry> special = new ArrayList<Sprites.SpecialEntry>();
        normal.add(new Sprites.TextureEntry("b0", 1, 0, 2, 1));
        normal.add(new Sprites.TextureEntry("b0", 9, 0, 16, 1));
        normal.add(new Sprites.TextureEntry("b0", 0, 1, 4, 2));
        normal.add(new Sprites.TextureEntry("b0", 12, 1, 16, 2));
        normal.add(new Sprites.TextureEntry("b0", 0, 2, 7, 3));
        normal.add(new Sprites.TextureEntry("b0", 8, 2, 16, 3));
        normal.add(new Sprites.TextureEntry("b0", 0, 3, 3, 4));
        normal.add(new Sprites.TextureEntry("b0", 8, 3, 16, 4));
        normal.add(new Sprites.TextureEntry("b0", 3, 4, 5, 5));
        normal.add(new Sprites.TextureEntry("b0", 14, 4, 16, 5));
        normal.add(new Sprites.TextureEntry("b0", 13, 5, 16, 6));
        normal.add(new Sprites.TextureEntry("b0", 4, 7, 7, 9));
        normal.add(new Sprites.TextureEntry("b0", 0, 15, 16, 16));
        normal.add(new Sprites.TextureEntry("bc", 0, 0, 16, 5));
        normal.add(new Sprites.TextureEntry("bc", 0, 5, 13, 6));
        normal.add(new Sprites.TextureEntry("bgen", 0, 0, 15, 12));
        normal.add(new Sprites.TextureEntry("bgen", 16, 0, 17, 6));
        normal.add(new Sprites.TextureEntry("bgenComp", 0, 0, 9, 12));
        normal.add(new Sprites.TextureEntry("bmach_lv", 0, 0, 16, 12));
        normal.add(new Sprites.TextureEntry("bmach_lv_2", 0, 0, 8, 12));
        normal.add(new Sprites.TextureEntry("bmach_mv", 0, 0, 14, 12));
        normal.add(new Sprites.TextureEntry("bmach_hv", 0, 0, 7, 12));
        normal.add(new Sprites.TextureEntry("bpersonal", 0, 0, 5, 12));
        normal.add(new Sprites.TextureEntry("bpersonal", 6, 0, 9, 12));
        normal.add(new Sprites.TextureEntry("bpersonalE", 0, 0, 3, 6));
        normal.add(new Sprites.TextureEntry("bcable", 0, 0, 17, 11));
        normal.add(new Sprites.TextureEntry("bcable", 1, 11, 17, 13));
        normal.add(new Sprites.TextureEntry("bcable", 0, 13, 17, 16));
        normal.add(new Sprites.TextureEntry("bcable2", 0, 0, 17, 1));
        normal.add(new Sprites.TextureEntry("bcable", 0, 16, 6, 17));
        normal.add(new Sprites.TextureEntry("belec", 0, 0, 6, 12));
        normal.add(new Sprites.TextureEntry("belec", 9, 0, 10, 12));
        normal.add(new Sprites.TextureEntry("batBox", 0, 0, 4, 6));
        normal.add(new Sprites.TextureEntry("mfe", 0, 0, 4, 6));
        normal.add(new Sprites.TextureEntry("mfsu", 0, 0, 4, 6));
        normal.add(new Sprites.TextureEntry("bBox", 0, 0, 4, 6));
        normal.add(new Sprites.TextureEntry("CPad", 0, 0, 4, 12));
        normal.add(new Sprites.TextureEntry("pesu", 0, 0, 4, 6));
        normal.add(new Sprites.TextureEntry("i0", 0, 0, 16, 1));
        normal.add(new Sprites.TextureEntry("i0", 0, 1, 12, 2));
        normal.add(new Sprites.TextureEntry("i0", 0, 2, 14, 3));
        normal.add(new Sprites.TextureEntry("i0", 0, 3, 16, 5));
        normal.add(new Sprites.TextureEntry("i0", 0, 5, 13, 6));
        normal.add(new Sprites.TextureEntry("i0", 0, 6, 16, 7));
        normal.add(new Sprites.TextureEntry("i0", 0, 7, 1, 8));
        normal.add(new Sprites.TextureEntry("i0", 0, 8, 16, 10));
        normal.add(new Sprites.TextureEntry("i0", 0, 10, 6, 11));
        normal.add(new Sprites.TextureEntry("i0", 0, 11, 16, 12));
        normal.add(new Sprites.TextureEntry("i0", 0, 12, 6, 13));
        normal.add(new Sprites.TextureEntry("i0", 0, 13, 9, 14));
        normal.add(new Sprites.TextureEntry("i1", 0, 0, 16, 1));
        normal.add(new Sprites.TextureEntry("i1", 0, 1, 13, 2));
        normal.add(new Sprites.TextureEntry("i1", 0, 2, 16, 3));
        normal.add(new Sprites.TextureEntry("i1", 0, 3, 13, 4));
        normal.add(new Sprites.TextureEntry("i1", 0, 4, 16, 5));
        normal.add(new Sprites.TextureEntry("i1", 0, 5, 6, 6));
        normal.add(new Sprites.TextureEntry("i1", 0, 6, 7, 7));
        normal.add(new Sprites.TextureEntry("i1", 0, 7, 14, 8));
        normal.add(new Sprites.TextureEntry("i1", 0, 8, 8, 9));
        normal.add(new Sprites.TextureEntry("i1", 0, 9, 12, 10));
        normal.add(new Sprites.TextureEntry("i1", 0, 10, 11, 11));
        normal.add(new Sprites.TextureEntry("i1", 0, 11, 4, 12));
        normal.add(new Sprites.TextureEntry("i2", 0, 0, 16, 1));
        normal.add(new Sprites.TextureEntry("i2", 0, 1, 4, 2));
        normal.add(new Sprites.TextureEntry("i2", 0, 2, 16, 3));
        normal.add(new Sprites.TextureEntry("i2", 0, 3, 1, 4));
        normal.add(new Sprites.TextureEntry("i3", 0, 0, 11, 1));
        normal.add(new Sprites.TextureEntry("i3", 0, 1, 4, 3));
        normal.add(new Sprites.TextureEntry("i3", 0, 3, 3, 4));
        normal.add(new Sprites.TextureEntry("i3", 0, 4, 4, 5));
        normal.add(new Sprites.TextureEntry("i3", 0, 5, 3, 6));
        normal.add(new Sprites.TextureEntry("i3", 0, 6, 6, 12));
        normal.add(new Sprites.TextureEntry("Gui", 0, 0, 5, 1));
        normal.add(new Sprites.TextureEntry("Gui", 0, 1, 4, 2));
        normal.add(new Sprites.TextureEntry("slots", 0, 0, 16, 1));
        normal.add(new Sprites.TextureEntry("slots", 0, 1, 8, 3));
        normal.add(new Sprites.TextureEntry("slots", 0, 3, 7, 4));
        normal.add(new Sprites.TextureEntry("slots", 14, 3, 16, 4));
        Ic2Icons.addTextureEntry(normal);
        Ic2Icons.addSpecialEntry(special);
        IC2.loader.loadTextures();
        MinecraftForge.EVENT_BUS.post((Event)new SpriteReloadEvent());
    }

    public static void addSprite(Sprites.SpriteData data) {
        String id = data.spriteID;
        iconIDToData.put(id, data);
        int amount = data.info.spriteAmount;
        textures.put(id, new TextureAtlasSprite[amount]);
    }

    public static void addCustomTexture(String spriteID, int x, int z, ResourceLocation location) {
        customIcons.put(new Sprites.CustomIconIndex(spriteID, x, z), location);
    }

    public static void addTextureEntry(List<Sprites.TextureEntry> entries) {
        texturesToLoad.addAll(entries);
    }

    public static void addTextureEntry(Sprites.TextureEntry entry) {
        texturesToLoad.add(entry);
    }

    public static void addSpecialEntry(List<Sprites.SpecialEntry> entries) {
        specialTexturesToLoad.addAll(entries);
    }

    public static void addSpecialEntry(Sprites.SpecialEntry entry) {
        specialTexturesToLoad.add(entry);
    }

    static String findName(String defaultingName, String spriteID, int x, int z) {
        ResourceLocation location = customIcons.get(new Sprites.CustomIconIndex(spriteID, x, z));
        if (location != null) {
            return location.toString();
        }
        return defaultingName;
    }

    @SideOnly(value=Side.CLIENT)
    static void loadIcon(TextureMap map, Sprites.SpriteData data, int x, int y) {
        Ic2Icons.textures.get((Object)data.spriteID)[x + y * data.info.maxX] = SubIconManager.getSubIcon(map, x, y, data, -1);
    }

    @SideOnly(value=Side.CLIENT)
    static void loadSpecialIcon(TextureMap map, Sprites.SpriteData data, int x, int y, int modify) {
        TextureAtlasSprite texture = SubIconManager.getSubIcon(map, x, y, data, modify);
        TextureAtlasSprite[] array = textures.get(data.spriteID);
        for (int i = x; i < x + modify; ++i) {
            for (int j = y; j < y + modify; ++j) {
                array[i + j * data.info.maxX] = texture;
            }
        }
        textures.put(data.spriteID, array);
    }

    @SideOnly(value=Side.CLIENT)
    public static void load(TextureMap r) {
        IC2Fluid.loadFluids(r);
        Ic2Icons.energyPacket[0] = r.func_174942_a(new ResourceLocation("ic2", "blocks/single/energyPacket"));
        Ic2Icons.energyPacket[1] = r.func_174942_a(new ResourceLocation("ic2", "blocks/single/energyPacketIn"));
        plasmaTexture = r.func_174942_a(new ResourceLocation("ic2", "blocks/single/plasma"));
        if (texturesToLoad.size() > 0) {
            for (Sprites.TextureEntry textureEntry : texturesToLoad) {
                textureEntry.load(r);
            }
        }
        if (specialTexturesToLoad.size() > 0) {
            for (Sprites.SpecialEntry specialEntry : specialTexturesToLoad) {
                specialEntry.load(r);
            }
        }
    }

    public static class SpriteReloadEvent
    extends Event {
    }
}

