/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med.logic.encoder.impl;

import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.PlannerRegistry;
import ic2.core.block.machine.med.logic.ReactorLogicBase;
import ic2.core.block.machine.med.logic.encoder.ByteShifter;
import ic2.core.block.machine.med.logic.encoder.IEncoder;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class V1Encoder
implements IEncoder {
    public static Logger LOGGER = LogManager.getLogger((String)"V1Encoder");

    @Override
    public NBTTagCompound createDecodedData(String data) {
        ByteShifter shifter = new ByteShifter(data);
        if (shifter.readInt(6) != 63) {
            LOGGER.warn("Decoder Main Version is not matching");
            return null;
        }
        if (shifter.readInt(5) != 1) {
            LOGGER.warn("Decoder Sub Version is not matching");
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("Steam", shifter.readBoolean());
        nbt.func_74768_a("Size", shifter.readInt(3));
        nbt.func_74768_a("MaxHeat", shifter.readInt(20));
        NBTTagList list = new NBTTagList();
        int expectedNameLenght = shifter.readInt(6);
        StringBuilder name = new StringBuilder(63);
        for (int i = expectedNameLenght; i > 0; --i) {
            name.append((char)shifter.readChar());
        }
        nbt.func_74778_a("PlanName", name.reverse().toString());
        int expectedTypes = shifter.readInt(6);
        for (int i = 0; i < expectedTypes; ++i) {
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74777_a("ID", (short)shifter.readInt(this.getBitLimit()));
            NBTTagList slotList = new NBTTagList();
            int expectedSlots = shifter.readInt(6);
            for (int slot = 0; slot < expectedSlots; ++slot) {
                int currentSlot = shifter.readInt(6);
                int stackSize = shifter.readInt(6) + 1;
                slotList.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{currentSlot, stackSize}));
            }
            entry.func_74782_a("Slots", (NBTBase)slotList);
            list.func_74742_a((NBTBase)entry);
        }
        nbt.func_74782_a("Data", (NBTBase)list);
        return nbt;
    }

    @Override
    public void processData(NBTTagCompound decodedData, TileEntityReactorPlanner planner) {
        planner.isSteamReactor = decodedData.func_74767_n("Steam");
        planner.reactorSize = decodedData.func_74762_e("Size");
        planner.setupName = decodedData.func_74779_i("PlanName");
        planner.getUserSettings().startingHeat = decodedData.func_74762_e("MaxHeat");
        NBTTagList list = decodedData.func_150295_c("Data", 10);
        ReactorLogicBase base = planner.getReactorLogic();
        boolean valid = false;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            ItemStack stack = PlannerRegistry.getComponentFromID(nbt.func_74765_d("ID"));
            if (stack.func_190926_b()) {
                LOGGER.info("Item [" + nbt.func_74765_d("ID") + "] not found!");
                continue;
            }
            NBTTagList slotList = nbt.func_150295_c("Slots", 11);
            for (int x = 0; x < slotList.func_74745_c(); ++x) {
                int[] array = slotList.func_150306_c(x);
                base.setStackInSlot(array[0], StackUtil.copyWithSize(stack, array[1]));
                valid = true;
            }
        }
        if (valid) {
            base.validate();
        } else {
            LOGGER.info("No Items were found!");
        }
    }

    @Override
    public String createEncodedData(TileEntityReactorPlanner planner) {
        ReactorLogicBase base = planner.getReactorLogic();
        ByteShifter shifter = new ByteShifter();
        HashMap<Short, ArrayList<Integer>> storage = new HashMap<Short, ArrayList<Integer>>();
        for (int i = 0; i < 54; ++i) {
            ItemStack stack = base.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            short id = PlannerRegistry.getID(stack);
            if (id >> this.getBitLimit() > 0) {
                LOGGER.info("Stack [" + stack + "] Exceeds BitLimit[" + this.getBitLimit() + "] of Encoder!");
                continue;
            }
            ArrayList<Integer> list = (ArrayList<Integer>)storage.get(id);
            if (list == null) {
                list = new ArrayList<Integer>();
                storage.put(id, list);
            }
            list.add(i);
        }
        for (Map.Entry entry : storage.entrySet()) {
            for (Integer slot : (List)entry.getValue()) {
                ItemStack stack = base.getStackInSlot(slot);
                if (stack.func_190926_b()) continue;
                shifter.writeInteger(stack.func_190916_E() - 1, 6);
                shifter.writeInteger(slot, 6);
            }
            shifter.writeInteger(((List)entry.getValue()).size(), 6);
            shifter.writeInteger(((Short)entry.getKey()).shortValue(), this.getBitLimit());
        }
        shifter.writeInteger(storage.size(), 6);
        char[] chars = planner.setupName.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            shifter.writeCharacter(chars[i]);
        }
        shifter.writeInteger(chars.length, 6);
        shifter.writeInteger(Math.min(base.maxHeat - 100, planner.getUserSettings().startingHeat), 20);
        shifter.writeInteger(planner.reactorSize, 3);
        shifter.writeBoolean(planner.isSteamReactor);
        shifter.writeInteger(1, 5);
        shifter.writeInteger(63, 6);
        return shifter.getDataCode();
    }

    @Override
    public String getName() {
        return "V1 Encoder";
    }

    @Override
    public boolean hasBitLimit() {
        return true;
    }

    @Override
    public int getBitLimit() {
        return 10;
    }
}

