/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.IC2;
import ic2.core.block.crop.crops.CropCardBase;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropStickReed
extends CropCardBase {
    public CropStickReed() {
        super(new CropProperties(4, 2, 0, 1, 0, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        return this.getSprite("bc")[27 + state];
    }

    @Override
    public String getId() {
        return "Stickreed";
    }

    @Override
    public String getDiscoveredBy() {
        return "raa1337";
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 4;
    }

    @Override
    public int getWeightInfluences(ICropTile crop, int humidity, int nutrients, int air) {
        return (int)((float)humidity * 1.2f + (float)nutrients + (float)air * 0.8f);
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() > 1;
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Reed", "Resin"};
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        if (crop.getCurrentSize() <= 3) {
            return new ItemStack(Items.field_151120_aE, crop.getCurrentSize() - 1);
        }
        return Ic2Items.stickyResin.func_77946_l();
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        if (cropTile.getCurrentSize() == 4) {
            return 3 - IC2.random.nextInt(3);
        }
        return 1;
    }

    @Override
    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        return false;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() == 3) {
            return 400;
        }
        return 100;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 4;
    }
}

