/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.recipe;

import crafttweaker.annotations.ZenRegister;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.recipe.AbstractQMDRecipeHandler;
import lach_01298.qmd.recipe.QMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeHelper;
import lach_01298.qmd.recipe.ingredient.IParticleIngredient;
import lach_01298.qmd.util.Util;
import nc.config.NCConfig;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.util.NCMath;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.qmd.QMDRecipeHandler")
@ZenRegister
public abstract class QMDRecipeHandler
extends AbstractQMDRecipeHandler<QMDRecipe> {
    private final String recipeName;
    public final int itemInputSize;
    public final int fluidInputSize;
    public final int particleInputSize;
    public final int itemOutputSize;
    public final int fluidOutputSize;
    public final int particleOutputSize;
    public final boolean isShapeless;

    public QMDRecipeHandler(@Nonnull String recipeName, int itemInputSize, int fluidInputSize, int particleInputSize, int itemOutputSize, int fluidOutputSize, int ParticleOutputSize) {
        this(recipeName, itemInputSize, fluidInputSize, particleInputSize, itemOutputSize, fluidOutputSize, ParticleOutputSize, true);
    }

    public QMDRecipeHandler(@Nonnull String recipeName, int itemInputSize, int fluidInputSize, int particleInputSize, int itemOutputSize, int fluidOutputSize, int particleOutputSize, boolean isShapeless) {
        this.itemInputSize = itemInputSize;
        this.fluidInputSize = fluidInputSize;
        this.particleInputSize = particleInputSize;
        this.itemOutputSize = itemOutputSize;
        this.fluidOutputSize = fluidOutputSize;
        this.particleOutputSize = particleOutputSize;
        this.isShapeless = isShapeless;
        this.recipeName = recipeName;
        this.addRecipes();
    }

    @Override
    public void addRecipe(Object ... objects) {
        ArrayList<Object> itemInputs = new ArrayList<Object>();
        ArrayList<Object> fluidInputs = new ArrayList<Object>();
        ArrayList<Object> particleInputs = new ArrayList<Object>();
        ArrayList<Object> itemOutputs = new ArrayList<Object>();
        ArrayList<Object> fluidOutputs = new ArrayList<Object>();
        ArrayList<Object> particleOutputs = new ArrayList<Object>();
        ArrayList<Object> extras = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (i < this.itemInputSize) {
                itemInputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize) {
                fluidInputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize + this.particleInputSize) {
                particleInputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize + this.particleInputSize + this.itemOutputSize) {
                itemOutputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize + this.particleInputSize + this.itemOutputSize + this.fluidOutputSize) {
                fluidOutputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize + this.particleInputSize + this.itemOutputSize + this.fluidOutputSize + this.particleOutputSize) {
                particleOutputs.add(object);
                continue;
            }
            extras.add(object);
        }
        QMDRecipe recipe = this.buildRecipe(itemInputs, fluidInputs, particleInputs, itemOutputs, fluidOutputs, particleOutputs, this.fixExtras(extras), this.isShapeless);
        this.addRecipe(NCConfig.factor_recipes ? this.factorRecipe(recipe) : recipe);
    }

    public abstract List fixExtras(List var1);

    public QMDRecipe factorRecipe(QMDRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        if (recipe.getItemIngredients().size() != 0 || recipe.getItemProducts().size() != 0) {
            return recipe;
        }
        IntArrayList stackSizes = new IntArrayList();
        for (IFluidIngredient iFluidIngredient : recipe.getFluidIngredients()) {
            stackSizes.addAll(iFluidIngredient.getFactors());
        }
        for (IFluidIngredient iFluidIngredient : recipe.getFluidProducts()) {
            stackSizes.addAll(iFluidIngredient.getFactors());
        }
        for (IParticleIngredient iParticleIngredient : recipe.getParticleIngredients()) {
            stackSizes.addAll(iParticleIngredient.getFactors());
        }
        for (IParticleIngredient iParticleIngredient : recipe.getParticleProducts()) {
            stackSizes.addAll(iParticleIngredient.getFactors());
        }
        stackSizes.addAll(this.getExtraFactors(recipe.getExtras()));
        int hcf = NCMath.hcf((int[])stackSizes.toIntArray());
        if (hcf == 1) {
            return recipe;
        }
        ArrayList<IFluidIngredient> arrayList = new ArrayList<IFluidIngredient>();
        ArrayList<IFluidIngredient> fluidProducts = new ArrayList<IFluidIngredient>();
        ArrayList<IParticleIngredient> particleIngredients = new ArrayList<IParticleIngredient>();
        ArrayList<IParticleIngredient> particleProducts = new ArrayList<IParticleIngredient>();
        for (IFluidIngredient iFluidIngredient : recipe.getFluidIngredients()) {
            arrayList.add(iFluidIngredient.getFactoredIngredient(hcf));
        }
        for (IFluidIngredient iFluidIngredient : recipe.getFluidProducts()) {
            fluidProducts.add(iFluidIngredient.getFactoredIngredient(hcf));
        }
        for (IParticleIngredient iParticleIngredient : recipe.getParticleIngredients()) {
            particleIngredients.add(iParticleIngredient.getFactoredIngredient(hcf));
        }
        for (IParticleIngredient iParticleIngredient : recipe.getParticleProducts()) {
            particleProducts.add(iParticleIngredient.getFactoredIngredient(hcf));
        }
        return new QMDRecipe(recipe.getItemIngredients(), arrayList, particleIngredients, recipe.getItemProducts(), fluidProducts, particleProducts, this.getFactoredExtras(recipe.getExtras(), hcf), recipe.isShapeless());
    }

    public IntList getExtraFactors(List extras) {
        return new IntArrayList();
    }

    public List getFactoredExtras(List extras, int factor) {
        return extras;
    }

    @Nullable
    public QMDRecipe buildRecipe(List itemInputs, List fluidInputs, List particleInputs, List itemOutputs, List fluidOutputs, List particleOutputs, List extras, boolean shapeless) {
        Object output;
        Object input;
        ArrayList<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
        ArrayList<IItemIngredient> itemProducts = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
        ArrayList<IFluidIngredient> fluidProducts = new ArrayList<IFluidIngredient>();
        ArrayList<IParticleIngredient> particleIngredients = new ArrayList<IParticleIngredient>();
        ArrayList<IParticleIngredient> particleProducts = new ArrayList<IParticleIngredient>();
        for (Object obj : itemInputs) {
            if (obj != null && QMDRecipeHandler.isValidItemInputType(obj)) {
                input = QMDRecipeHelper.buildItemIngredient(obj);
                if (input == null) {
                    return null;
                }
                itemIngredients.add((IItemIngredient)input);
                continue;
            }
            return null;
        }
        for (Object obj : fluidInputs) {
            if (obj != null && QMDRecipeHandler.isValidFluidInputType(obj)) {
                input = QMDRecipeHelper.buildFluidIngredient(obj);
                if (input == null) {
                    return null;
                }
                fluidIngredients.add((IFluidIngredient)input);
                continue;
            }
            return null;
        }
        for (Object obj : particleInputs) {
            if (obj != null && QMDRecipeHandler.isValidParticleInputType(obj)) {
                input = QMDRecipeHelper.buildParticleIngredient(obj);
                if (input == null) {
                    return null;
                }
                particleIngredients.add((IParticleIngredient)input);
                continue;
            }
            return null;
        }
        for (Object obj : itemOutputs) {
            if (obj != null && QMDRecipeHandler.isValidItemOutputType(obj)) {
                output = QMDRecipeHelper.buildItemIngredient(obj);
                if (output == null) {
                    return null;
                }
                itemProducts.add((IItemIngredient)output);
                continue;
            }
            return null;
        }
        for (Object obj : fluidOutputs) {
            if (obj != null && QMDRecipeHandler.isValidFluidOutputType(obj)) {
                output = QMDRecipeHelper.buildFluidIngredient(obj);
                if (output == null) {
                    return null;
                }
                fluidProducts.add((IFluidIngredient)output);
                continue;
            }
            return null;
        }
        for (Object obj : particleOutputs) {
            if (obj != null && QMDRecipeHandler.isValidParticleOutputType(obj)) {
                output = QMDRecipeHelper.buildParticleIngredient(obj);
                if (output == null) {
                    return null;
                }
                particleProducts.add((IParticleIngredient)output);
                continue;
            }
            return null;
        }
        if (!this.isValidRecipe(itemIngredients, fluidIngredients, particleIngredients, itemProducts, fluidProducts, particleProducts)) {
            Util.getLogger().info(this.getRecipeName() + " - a recipe was removed: " + QMDRecipeHelper.getRecipeString(itemIngredients, fluidIngredients, particleIngredients, itemProducts, fluidProducts, particleProducts));
        }
        return new QMDRecipe(itemIngredients, fluidIngredients, particleIngredients, itemProducts, fluidProducts, particleProducts, extras, shapeless);
    }

    public boolean isValidRecipe(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List<IParticleIngredient> particleIngredients, List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts, List<IParticleIngredient> particleProducts) {
        return itemIngredients.size() == this.itemInputSize && fluidIngredients.size() == this.fluidInputSize && particleIngredients.size() == this.particleInputSize && itemProducts.size() == this.itemOutputSize && fluidProducts.size() == this.fluidOutputSize && particleProducts.size() == this.particleOutputSize;
    }

    @Override
    public String getRecipeName() {
        return "qmd_" + this.recipeName;
    }

    @Override
    @ZenMethod
    public List<QMDRecipe> getRecipeList() {
        return this.recipeList;
    }

    @ZenMethod
    public int getItemInputSize() {
        return this.itemInputSize;
    }

    @ZenMethod
    public int getFluidInputSize() {
        return this.fluidInputSize;
    }

    @ZenMethod
    public int getParticleInputSize() {
        return this.particleInputSize;
    }

    @ZenMethod
    public int getItemOutputSize() {
        return this.itemOutputSize;
    }

    @ZenMethod
    public int getFluidOutputSize() {
        return this.fluidOutputSize;
    }

    @ZenMethod
    public int getParticleOutputSize() {
        return this.particleOutputSize;
    }

    @ZenMethod
    public boolean isShapeless() {
        return this.isShapeless;
    }
}

