/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.machine.gui;

import java.io.IOException;
import lach_01298.qmd.machine.container.ContainerOreLeacher;
import lach_01298.qmd.machine.gui.GuiItemFluidMachine;
import lach_01298.qmd.machine.network.QMDOpenSideConfigGuiPacket;
import lach_01298.qmd.machine.network.QMDOpenTileGuiPacket;
import lach_01298.qmd.network.QMDPacketHandler;
import nc.container.ContainerTile;
import nc.container.processor.ContainerMachineConfig;
import nc.gui.NCGui;
import nc.gui.element.GuiFluidRenderer;
import nc.gui.element.NCButton;
import nc.gui.element.NCToggleButton;
import nc.gui.processor.GuiFluidSorptions;
import nc.gui.processor.GuiItemSorptions;
import nc.network.PacketHandler;
import nc.network.gui.EmptyTankPacket;
import nc.network.gui.ToggleRedstoneControlPacket;
import nc.tile.ITile;
import nc.tile.ITileGui;
import nc.tile.energy.ITileEnergy;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.Tank;
import nc.tile.inventory.ITileInventory;
import nc.tile.processor.ITileSideConfigGui;
import nc.tile.processor.TileItemFluidProcessor;
import nc.util.Lang;
import nc.util.NCUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiOreLeacher
extends GuiItemFluidMachine {
    public GuiOreLeacher(EntityPlayer player, TileItemFluidProcessor tile) {
        this(player, tile, (ContainerTile)new ContainerOreLeacher(player, tile));
    }

    private GuiOreLeacher(EntityPlayer player, TileItemFluidProcessor tile, ContainerTile container) {
        super("ore_leacher", player, tile, (Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public void renderTooltips(int mouseX, int mouseY) {
        this.drawEnergyTooltip((ITileEnergy)this.tile, mouseX, mouseY, 8, 6, 16, 74);
        this.renderButtonTooltips(mouseX, mouseY);
    }

    public void renderButtonTooltips(int mouseX, int mouseY) {
        this.drawFluidTooltip((Tank)this.tile.getTanks().get(0), mouseX, mouseY, 36, 42, 16, 16);
        this.drawFluidTooltip((Tank)this.tile.getTanks().get(1), mouseX, mouseY, 56, 42, 16, 16);
        this.drawFluidTooltip((Tank)this.tile.getTanks().get(2), mouseX, mouseY, 76, 42, 16, 16);
        this.drawTooltip(Lang.localise((String)"gui.nc.container.machine_side_config"), mouseX, mouseY, 27, 63, 18, 18);
        this.drawTooltip(Lang.localise((String)"gui.nc.container.redstone_control"), mouseX, mouseY, 47, 63, 18, 18);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.tile.defaultProcessPower != 0.0) {
            int e = (int)Math.round(74.0 * (double)this.tile.getEnergyStorage().getEnergyStored() / (double)this.tile.getEnergyStorage().getMaxEnergyStored());
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 6 + 74 - e, 176, 164 - e, 16, e);
        } else {
            this.func_73733_a(this.field_147003_i + 8, this.field_147009_r + 6, this.field_147003_i + 8 + 16, this.field_147009_r + 6 + 74, -3750202, -7631989);
        }
        this.func_73729_b(this.field_147003_i + 40, this.field_147009_r + 29, 176, 0, this.getCookProgressScaled(48.0), 11);
        this.func_73729_b(this.field_147003_i + 94, this.field_147009_r + 46, 176, 12, this.getCookProgressScaled(48.0) - 32 < 0 ? 0 : this.getCookProgressScaled(48.0) - 32, 8);
        this.drawUpgradeRenderers();
        this.drawBackgroundExtras();
    }

    protected void drawBackgroundExtras() {
        GuiFluidRenderer.renderGuiTank((FluidTank)((FluidTank)this.tile.getTanks().get(0)), (double)(this.field_147003_i + 36), (double)(this.field_147009_r + 42), (double)this.field_73735_i, (double)16.0, (double)16.0);
        GuiFluidRenderer.renderGuiTank((FluidTank)((FluidTank)this.tile.getTanks().get(1)), (double)(this.field_147003_i + 56), (double)(this.field_147009_r + 42), (double)this.field_73735_i, (double)16.0, (double)16.0);
        GuiFluidRenderer.renderGuiTank((FluidTank)((FluidTank)this.tile.getTanks().get(2)), (double)(this.field_147003_i + 76), (double)(this.field_147009_r + 42), (double)this.field_73735_i, (double)16.0, (double)16.0);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
    }

    public void initButtons() {
        this.field_146292_n.add(new NCButton.EmptyTank(0, this.field_147003_i + 36, this.field_147009_r + 42, 16, 16));
        this.field_146292_n.add(new NCButton.EmptyTank(1, this.field_147003_i + 56, this.field_147009_r + 42, 16, 16));
        this.field_146292_n.add(new NCButton.EmptyTank(2, this.field_147003_i + 76, this.field_147009_r + 42, 16, 16));
        this.field_146292_n.add(new NCButton.MachineConfig(3, this.field_147003_i + 27, this.field_147009_r + 63));
        this.field_146292_n.add(new NCToggleButton.RedstoneControl(4, this.field_147003_i + 47, this.field_147009_r + 63, (ITile)this.tile));
    }

    @Override
    protected void func_146284_a(GuiButton guiButton) {
        if (this.tile.func_145831_w().field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                if (guiButton.field_146127_k != i || !NCUtil.isModifierKeyDown()) continue;
                PacketHandler.instance.sendToServer((IMessage)new EmptyTankPacket((ITileFluid)this.tile, i));
                return;
            }
            if (guiButton.field_146127_k == 3) {
                QMDPacketHandler.instance.sendToServer((IMessage)new QMDOpenSideConfigGuiPacket((ITileGui)this.tile));
            } else if (guiButton.field_146127_k == 4) {
                this.tile.setRedstoneControl(!this.tile.getRedstoneControl());
                PacketHandler.instance.sendToServer((IMessage)new ToggleRedstoneControlPacket((ITile)this.tile));
            }
        }
    }

    public static class SideConfig
    extends GuiOreLeacher {
        public SideConfig(EntityPlayer player, TileItemFluidProcessor tile) {
            super(player, tile, (ContainerTile)new ContainerMachineConfig(player, (ITileSideConfigGui)tile));
        }

        protected void func_73869_a(char typedChar, int keyCode) throws IOException {
            if (this.isEscapeKeyDown(keyCode)) {
                QMDPacketHandler.instance.sendToServer((IMessage)new QMDOpenTileGuiPacket((ITileGui)this.tile));
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }

        @Override
        public void renderButtonTooltips(int mouseX, int mouseY) {
            this.drawTooltip(TextFormatting.BLUE + Lang.localise((String)"gui.nc.container.input_item_config"), mouseX, mouseY, 36, 11, 18, 18);
            this.drawTooltip(TextFormatting.DARK_AQUA + Lang.localise((String)"gui.nc.container.input_tank_config"), mouseX, mouseY, 36, 42, 18, 18);
            this.drawTooltip(TextFormatting.DARK_AQUA + Lang.localise((String)"gui.nc.container.input_tank_config"), mouseX, mouseY, 56, 42, 18, 18);
            this.drawTooltip(TextFormatting.DARK_AQUA + Lang.localise((String)"gui.nc.container.input_tank_config"), mouseX, mouseY, 76, 42, 18, 18);
            this.drawTooltip(TextFormatting.GOLD + Lang.localise((String)"gui.nc.container.output_item_config"), mouseX, mouseY, 112, 42, 18, 18);
            this.drawTooltip(TextFormatting.GOLD + Lang.localise((String)"gui.nc.container.output_item_config"), mouseX, mouseY, 132, 42, 18, 18);
            this.drawTooltip(TextFormatting.GOLD + Lang.localise((String)"gui.nc.container.output_item_config"), mouseX, mouseY, 152, 42, 18, 18);
            this.drawTooltip(TextFormatting.DARK_BLUE + Lang.localise((String)"gui.nc.container.upgrade_config"), mouseX, mouseY, 131, 63, 18, 18);
            this.drawTooltip(TextFormatting.YELLOW + Lang.localise((String)"gui.nc.container.upgrade_config"), mouseX, mouseY, 151, 63, 18, 18);
        }

        @Override
        protected void drawUpgradeRenderers() {
        }

        @Override
        protected void drawBackgroundExtras() {
        }

        @Override
        public void initButtons() {
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemInput(0, this.field_147003_i + 35, this.field_147009_r + 10));
            this.field_146292_n.add(new NCButton.SorptionConfig.FluidInput(1, this.field_147003_i + 35, this.field_147009_r + 41));
            this.field_146292_n.add(new NCButton.SorptionConfig.FluidInput(2, this.field_147003_i + 55, this.field_147009_r + 41));
            this.field_146292_n.add(new NCButton.SorptionConfig.FluidInput(3, this.field_147003_i + 75, this.field_147009_r + 41));
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemOutputSmall(4, this.field_147003_i + 111, this.field_147009_r + 41));
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemOutputSmall(5, this.field_147003_i + 131, this.field_147009_r + 41));
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemOutputSmall(6, this.field_147003_i + 151, this.field_147009_r + 41));
            this.field_146292_n.add(new NCButton.SorptionConfig.SpeedUpgrade(7, this.field_147003_i + 131, this.field_147009_r + 63));
            this.field_146292_n.add(new NCButton.SorptionConfig.EnergyUpgrade(8, this.field_147003_i + 151, this.field_147009_r + 63));
        }

        @Override
        protected void func_146284_a(GuiButton guiButton) {
            if (this.tile.func_145831_w().field_72995_K) {
                switch (guiButton.field_146127_k) {
                    case 0: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiItemSorptions.Input((NCGui)this, (ITileInventory)this.tile, 0));
                        return;
                    }
                    case 1: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiFluidSorptions.Input((NCGui)this, (ITileFluid)this.tile, 0));
                        return;
                    }
                    case 2: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiFluidSorptions.Input((NCGui)this, (ITileFluid)this.tile, 1));
                        return;
                    }
                    case 3: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiFluidSorptions.Input((NCGui)this, (ITileFluid)this.tile, 2));
                        return;
                    }
                    case 4: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiItemSorptions.Output((NCGui)this, (ITileInventory)this.tile, 1));
                        return;
                    }
                    case 5: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiItemSorptions.Output((NCGui)this, (ITileInventory)this.tile, 2));
                        return;
                    }
                    case 6: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiItemSorptions.Output((NCGui)this, (ITileInventory)this.tile, 3));
                        return;
                    }
                    case 7: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiItemSorptions.SpeedUpgrade((NCGui)this, (ITileInventory)this.tile, 4));
                        return;
                    }
                    case 8: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiItemSorptions.EnergyUpgrade((NCGui)this, (ITileInventory)this.tile, 5));
                        return;
                    }
                }
            }
        }
    }
}

