/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.jei.recipe;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import lach_01298.qmd.jei.ingredient.ParticleType;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.util.Units;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import nc.util.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class ParticleInfoRecipe
implements IRecipeWrapper {
    private final ParticleStack particle;
    private final List<ParticleStack> components;

    public ParticleInfoRecipe(ParticleStack particle, List<ParticleStack> components) {
        this.particle = particle;
        this.components = components;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ParticleType.Particle, this.components);
        ingredients.setOutput(ParticleType.Particle, (Object)this.particle);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FontRenderer fontRenderer = minecraft.field_71466_p;
        String nameString = Lang.localise((String)("qmd.particle." + this.particle.getParticle().getName() + ".name"));
        if (!this.components.isEmpty()) {
            String componentsString = Lang.localise((String)"gui.qmd.jei.particle.components");
            fontRenderer.func_78276_b(componentsString, 50, 15, Color.gray.getRGB());
        }
        String massString = Lang.localise((String)"gui.qmd.jei.particle.mass", (Object[])new Object[]{Units.getSIFormat(this.particle.getParticle().getMass(), 6, "eV/c^2")});
        DecimalFormat df = new DecimalFormat("#.##");
        String chargeString = Lang.localise((String)"gui.qmd.jei.particle.charge", (Object[])new Object[]{df.format(this.particle.getParticle().getCharge())});
        String spinString = Lang.localise((String)"gui.qmd.jei.particle.spin", (Object[])new Object[]{this.particle.getParticle().getSpin()});
        String colourString = Lang.localise((String)"gui.qmd.jei.particle.colour", (Object[])new Object[]{this.particle.getParticle().interactsWithStrong()});
        String weakChargeString = Lang.localise((String)"gui.qmd.jei.particle.weak", (Object[])new Object[]{this.particle.getParticle().interactsWithWeak()});
        String descString = Lang.localise((String)("qmd.particle." + this.particle.getParticle().getName() + ".desc"));
        fontRenderer.func_78276_b(nameString, 0, 0, Color.BLACK.getRGB());
        fontRenderer.func_78276_b(massString, 0, 27, Color.gray.getRGB());
        fontRenderer.func_78276_b(chargeString, 0, 37, Color.gray.getRGB());
        fontRenderer.func_78276_b(spinString, 0, 47, Color.gray.getRGB());
        fontRenderer.func_78276_b(colourString, 0, 57, Color.gray.getRGB());
        fontRenderer.func_78276_b(weakChargeString, 0, 67, Color.gray.getRGB());
        fontRenderer.func_78279_b(descString, 0, 80, 150, Color.gray.getRGB());
    }
}

