/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.jei.ingredient;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lach_01298.qmd.particle.Particle;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.util.Units;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import nc.util.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.TextFormatting;

public class ParticleStackRenderer
implements IIngredientRenderer<ParticleStack> {
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private final int amount;
    private final long energy;
    private final double focus;
    private final int width;
    private final int height;
    @Nullable
    private final IDrawable overlay;

    public ParticleStackRenderer() {
        this(0, 0L, 0.0, 16, 16, null);
    }

    public ParticleStackRenderer(int amount, long energy, double focus, int width, int height, @Nullable IDrawable overlay) {
        this.amount = amount;
        this.energy = energy;
        this.focus = focus;
        this.width = width;
        this.height = height;
        this.overlay = overlay;
    }

    public void render(Minecraft minecraft, int xPosition, int yPosition, @Nullable ParticleStack particleStack) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        this.drawParticle(minecraft, xPosition, yPosition, particleStack);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.overlay != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            this.overlay.draw(minecraft, xPosition, yPosition);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    public List<String> getTooltip(Minecraft minecraft, ParticleStack ingredient, ITooltipFlag tooltipFlag) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Lang.localise((String)ingredient.getParticle().getUnlocalizedName()));
        list.add(TextFormatting.GRAY + Lang.localise((String)"gui.qmd.particlestack.amount", (Object[])new Object[]{Units.getSIFormat(ingredient.getAmount(), "pu")}));
        list.add(TextFormatting.GRAY + Lang.localise((String)"gui.qmd.particlestack.mean_energy", (Object[])new Object[]{Units.getParticleEnergy(ingredient.getMeanEnergy())}));
        list.add(TextFormatting.GRAY + Lang.localise((String)"gui.qmd.particlestack.focus", (Object[])new Object[]{Units.getSIFormat(ingredient.getFocus(), "")}));
        return list;
    }

    private void drawParticle(Minecraft minecraft, int xPosition, int yPosition, @Nullable ParticleStack particleStack) {
        if (particleStack == null) {
            return;
        }
        Particle particle = particleStack.getParticle();
        if (particle == null) {
            return;
        }
        minecraft.field_71446_o.func_110577_a(particleStack.getParticle().getTexture());
        double zLevel = 100.0;
        double width = 16.0;
        double uMin = 0.0;
        double uMax = 1.0;
        double vMin = 0.0;
        double vMax = 1.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)xPosition, (double)yPosition + width, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        bufferBuilder.func_181662_b((double)xPosition + width, (double)(yPosition + 16), zLevel).func_187315_a(uMax, vMax).func_181675_d();
        bufferBuilder.func_181662_b((double)xPosition + width, (double)yPosition, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        bufferBuilder.func_181662_b((double)xPosition, (double)yPosition, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }
}

