/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.jei.ingredient;

import com.google.common.base.MoreObjects;
import java.awt.Color;
import java.util.Collections;
import javax.annotation.Nullable;
import lach_01298.qmd.particle.Particle;
import lach_01298.qmd.particle.ParticleStack;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ParticleStackHelper
implements IIngredientHelper<ParticleStack> {
    @Nullable
    public ParticleStack getMatch(Iterable<ParticleStack> ingredients, ParticleStack toMatch) {
        for (ParticleStack particleStack : ingredients) {
            if (particleStack == null || toMatch.getParticle() != particleStack.getParticle()) continue;
            return particleStack;
        }
        return null;
    }

    public String getDisplayName(ParticleStack ingredient) {
        return ingredient.getParticle().getUnlocalizedName();
    }

    public String getUniqueId(ParticleStack ingredient) {
        return "particle:" + ingredient.getParticle().getName();
    }

    public String getWildcardId(ParticleStack ingredient) {
        return this.getUniqueId(ingredient);
    }

    public String getModId(ParticleStack ingredient) {
        return "qmd";
    }

    public Iterable<Color> getColors(ParticleStack ingredient) {
        return Collections.emptyList();
    }

    public String getResourceId(ParticleStack ingredient) {
        ResourceLocation particleResourceName = ingredient.getParticle().getTexture();
        return particleResourceName.func_110623_a();
    }

    public ItemStack getCheatItemStack(ParticleStack ingredient) {
        return ItemStack.field_190927_a;
    }

    public ParticleStack copyIngredient(ParticleStack ingredient) {
        return ingredient.copy();
    }

    public String getErrorInfo(@Nullable ParticleStack ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(ParticleStack.class);
        Particle particle = ingredient.getParticle();
        if (particle != null) {
            toStringHelper.add("Particle", (Object)particle.getName());
        } else {
            toStringHelper.add("Particle", (Object)"null");
        }
        toStringHelper.add("amount", ingredient.getAmount());
        toStringHelper.add("Energy", ingredient.getMeanEnergy());
        toStringHelper.add("Focus", ingredient.getFocus());
        return toStringHelper.toString();
    }
}

