/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.capabilities;

import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.particle.IParticleStorage;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.particle.ParticleStorage;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilityParticleStackHandler {
    @CapabilityInject(value=IParticleStackHandler.class)
    public static Capability<IParticleStackHandler> PARTICLE_HANDLER_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IParticleStackHandler.class, new DefaultParticleHandlerStorage(), () -> new ParticleStorage(null, Integer.MAX_VALUE));
    }

    private static class DefaultParticleHandlerStorage<T extends IParticleStackHandler>
    implements Capability.IStorage<T> {
        private DefaultParticleHandlerStorage() {
        }

        public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
            if (!(instance instanceof IParticleStorage)) {
                throw new RuntimeException("IParticleStackHandler instance does not implement IParticleStorage");
            }
            NBTTagCompound nbt = new NBTTagCompound();
            IParticleStorage tank = (IParticleStorage)instance;
            ParticleStack particle = tank.getParticleStack();
            if (particle != null) {
                particle.writeToNBT(nbt);
            } else {
                nbt.func_74778_a("Empty", "");
            }
            nbt.func_74772_a("MaxEnergy", tank.getMaxEnergy());
            nbt.func_74768_a("Capacity", tank.getCapacity());
            nbt.func_74772_a("MinEnergy", tank.getMinEnergy());
            return nbt;
        }

        public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
            if (!(instance instanceof ParticleStorage)) {
                throw new RuntimeException("IParticleStackHandler instance is not instance of ParticleStorage");
            }
            NBTTagCompound tags = (NBTTagCompound)nbt;
            ParticleStorage tank = (ParticleStorage)instance;
            tank.setMaxEnergy(tags.func_74763_f("MaxEnergy"));
            tank.setCapacity(tags.func_74762_e("Capacity"));
            tank.setMinEnergy(tags.func_74763_f("MinEnergy"));
            tank.readFromNBT(tags);
        }
    }
}

