/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.triggers;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementManager;
import forestry.core.triggers.Sprite;
import forestry.core.utils.Translator;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Trigger
implements ITriggerExternal {
    private final String uid;
    private final String localization;
    private final String textureName;
    @SideOnly(value=Side.CLIENT)
    @Nullable
    private ISprite icon;

    protected Trigger(String uid, String textureName) {
        this(uid, uid, textureName);
    }

    protected Trigger(String uid, String localization, String textureName) {
        this.uid = "forestry:" + uid;
        this.localization = localization;
        this.textureName = textureName;
        StatementManager.registerStatement((IStatement)this);
    }

    public String getUniqueTag() {
        return this.uid;
    }

    public String getDescription() {
        return Translator.translateToLocal("for.trigger." + this.localization);
    }

    public IStatementParameter createParameter(int index) {
        return null;
    }

    public int maxParameters() {
        return 0;
    }

    public int minParameters() {
        return 0;
    }

    @Nullable
    public ISprite getSprite() {
        if (this.icon == null) {
            this.icon = new Sprite(new ResourceLocation("forestry", String.format("textures/gui/triggers/%s.png", this.textureName)));
        }
        return this.icon;
    }

    public IStatement rotateLeft() {
        return this;
    }

    public IStatement[] getPossible() {
        return new IStatement[0];
    }
}

