/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.soul.DemonWillHolder;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.util.handler.event.GenericHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@RitualRegister(value="ward_of_sacrosanctity")
public class RitualWardOfSacrosanctity
extends Ritual {
    public static final String SPAWN_WARD = "spawnWard";

    public RitualWardOfSacrosanctity() {
        super("ritualWardOfSacrosanctity", 0, 40000, "ritual.bloodmagic.wardOfSacrosanctityRitual");
        this.addBlockRange(SPAWN_WARD, new AreaDescriptor.Rectangle(new BlockPos(-16, -10, -16), 33));
        this.setMaximumVolumeAndDistanceOfRange(SPAWN_WARD, 0, 256, 256);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos pos = masterRitualStone.getBlockPos();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(world, pos);
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        double rawDrained = 0.0;
        double corrosiveDrained = 0.0;
        double destructiveDrained = 0.0;
        double steadfastDrained = 0.0;
        double vengefulDrained = 0.0;
        if (GenericHandler.preventSpawnMap.containsKey(world)) {
            Map<IMasterRitualStone, AreaDescriptor> preventSpawnMap = GenericHandler.preventSpawnMap.get(world);
            if (preventSpawnMap != null) {
                preventSpawnMap.put(masterRitualStone, masterRitualStone.getBlockRange(SPAWN_WARD));
            } else {
                preventSpawnMap = new HashMap<IMasterRitualStone, AreaDescriptor>();
                preventSpawnMap.put(masterRitualStone, masterRitualStone.getBlockRange(SPAWN_WARD));
                GenericHandler.preventSpawnMap.put(world, preventSpawnMap);
            }
        } else {
            HashMap<IMasterRitualStone, AreaDescriptor> preventSpawnMap = new HashMap<IMasterRitualStone, AreaDescriptor>();
            preventSpawnMap.put(masterRitualStone, masterRitualStone.getBlockRange(SPAWN_WARD));
            GenericHandler.preventSpawnMap.put(world, preventSpawnMap);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
    }

    @Override
    public int getRefreshTime() {
        return 25;
    }

    @Override
    public int getRefreshCost() {
        return 2;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        for (int i = 2; i < 5; ++i) {
            if (i < 4) {
                this.addParallelRunes(components, 1, 0, EnumRuneType.AIR);
            }
            this.addCornerRunes(components, i, 0, EnumRuneType.FIRE);
        }
        this.addParallelRunes(components, 5, 0, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 5, 6, 0, EnumRuneType.WATER);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualWardOfSacrosanctity();
    }
}

