/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.impl;

import WayofTime.bloodmagic.api.IBloodMagicBlacklist;
import WayofTime.bloodmagic.util.BMLog;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;

public class BloodMagicBlacklist
implements IBloodMagicBlacklist {
    private final Set<IBlockState> teleposer = Sets.newHashSet();
    private final Set<ResourceLocation> teleposerEntities = Sets.newHashSet();
    private final Set<IBlockState> transposition = Sets.newHashSet();
    private final Set<IBlockState> greenGrove = Sets.newHashSet();
    private final Set<ResourceLocation> sacrifice = Sets.newHashSet();

    @Override
    public void addTeleposer(@Nonnull IBlockState state) {
        if (!this.teleposer.contains(state)) {
            BMLog.API_VERBOSE.info("Blacklist: Added {} to the Teleposer blacklist.", state);
            this.teleposer.add(state);
        }
    }

    public void addTeleposer(@Nonnull Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            this.addTeleposer(state);
        }
    }

    @Override
    public void addTeleposer(@Nonnull ResourceLocation entityId) {
        if (!this.teleposerEntities.contains(entityId)) {
            BMLog.API_VERBOSE.info("Blacklist: Added {} to the Teleposer blacklist.", entityId);
            this.teleposerEntities.add(entityId);
        }
    }

    @Override
    public void addTransposition(@Nonnull IBlockState state) {
        if (!this.transposition.contains(state)) {
            BMLog.API_VERBOSE.info("Blacklist: Added {} to the Transposition blacklist.", state);
            this.transposition.add(state);
        }
    }

    public void addTransposition(@Nonnull Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            this.addTransposition(state);
        }
    }

    @Override
    public void addGreenGrove(@Nonnull IBlockState state) {
        if (!this.greenGrove.contains(state)) {
            BMLog.API_VERBOSE.info("Blacklist: Added {} to the Green Grove blacklist.", state);
            this.greenGrove.add(state);
        }
    }

    public void addGreenGrove(@Nonnull Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            this.addGreenGrove(state);
        }
    }

    @Override
    public void addWellOfSuffering(@Nonnull ResourceLocation entityId) {
        if (!this.sacrifice.contains(entityId)) {
            BMLog.API_VERBOSE.info("Blacklist: Added {} to the Well of Suffering blacklist.", entityId);
            this.sacrifice.add(entityId);
        }
    }

    public Set<IBlockState> getTeleposer() {
        return ImmutableSet.copyOf(this.teleposer);
    }

    public Set<ResourceLocation> getTeleposerEntities() {
        return ImmutableSet.copyOf(this.teleposerEntities);
    }

    public Set<IBlockState> getTransposition() {
        return ImmutableSet.copyOf(this.transposition);
    }

    public Set<IBlockState> getGreenGrove() {
        return ImmutableSet.copyOf(this.greenGrove);
    }

    public Set<ResourceLocation> getSacrifice() {
        return ImmutableSet.copyOf(this.sacrifice);
    }
}

