/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.annotations.ForRemoval;
import micdoodle8.mods.galacticraft.annotations.ReplaceWith;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.ShapedRecipesGC;
import micdoodle8.mods.galacticraft.api.recipe.ShapelessOreRecipeGC;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachine2;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachine4;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineBase;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.inventory.PersistantInventoryCrafting;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityElectricIngotCompressor
extends TileBaseElectricBlock
implements IInventoryDefaults,
ISidedInventory,
IMachineSides {
    private static final int PROCESS_TIME_REQUIRED_BASE = 200;
    private int processTimeRequiredBase;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = 200;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack producingStack = ItemStack.field_190927_a;
    private long ticks;
    private static final int[] allSlots = new int[]{0, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private boolean advanced;
    public PersistantInventoryCrafting compressingCraftMatrix = new PersistantInventoryCrafting();
    private static Random randnum = new Random();
    private IMachineSides.MachineSidePack[] machineSides;

    public TileEntityElectricIngotCompressor() {
        super("tile.machine2.4.name");
        this.processTimeRequiredBase = 200;
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 75.0f);
        this.setTierGC(2);
        this.inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    }

    public TileEntityElectricIngotCompressor(boolean advanced) {
        super("tile.machine4.11.name");
        this.processTimeRequired = this.processTimeRequiredBase = 120;
        this.advanced = true;
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 75.0f);
        this.setTierGC(3);
        this.inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            boolean updateInv = false;
            if (this.hasEnoughEnergyToRun) {
                if (this.canCompress()) {
                    ++this.processTicks;
                    this.processTimeRequired = this.processTimeRequiredBase / (1 + this.poweredByTierGC * 2);
                    if (this.processTicks >= this.processTimeRequired) {
                        if (this.advanced) {
                            this.field_145850_b.func_184133_a(null, this.func_174877_v(), GCSounds.advanced_compressor, SoundCategory.BLOCKS, 0.23f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 9.5f);
                        } else {
                            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.12f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f - 9.5f);
                        }
                        this.processTicks = 0;
                        this.compressItems();
                        updateInv = true;
                    }
                } else {
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
        ++this.ticks;
    }

    private boolean canCompress() {
        ItemStack itemstack = this.producingStack;
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.getInventory().get(1)).func_190926_b() && ((ItemStack)this.getInventory().get(2)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.getInventory().get(1)).func_190926_b() && !((ItemStack)this.getInventory().get(1)).func_77969_a(itemstack) || !((ItemStack)this.getInventory().get(2)).func_190926_b() && !((ItemStack)this.getInventory().get(2)).func_77969_a(itemstack)) {
            return false;
        }
        int contents1 = ((ItemStack)this.getInventory().get(1)).func_190916_E();
        int contents2 = ((ItemStack)this.getInventory().get(2)).func_190916_E();
        int result = itemstack.func_190916_E();
        if (ConfigManagerCore.quickMode && itemstack.func_77973_b().func_77667_c(itemstack).contains("compressed")) {
            result += result;
        }
        return (result += contents2 < contents1 ? contents2 : contents1) <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public void updateInput() {
        this.producingStack = CompressorRecipes.findMatchingRecipe(this.compressingCraftMatrix, this.field_145850_b);
    }

    public void compressItems() {
        int stackSize2;
        int stackSize1 = ((ItemStack)this.getInventory().get(1)).func_190926_b() ? 0 : ((ItemStack)this.getInventory().get(1)).func_190916_E();
        int n = stackSize2 = ((ItemStack)this.getInventory().get(2)).func_190926_b() ? 0 : ((ItemStack)this.getInventory().get(2)).func_190916_E();
        if (stackSize1 <= stackSize2) {
            this.compressIntoSlot(1);
            this.compressIntoSlot(2);
        } else {
            this.compressIntoSlot(2);
            this.compressIntoSlot(1);
        }
    }

    private void compressIntoSlot(int slot) {
        if (this.canCompress()) {
            ItemStack resultItemStack = this.producingStack.func_77946_l();
            if (ConfigManagerCore.quickMode && resultItemStack.func_77973_b().func_77667_c(resultItemStack).contains("compressed")) {
                resultItemStack.func_190917_f(resultItemStack.func_190916_E());
            }
            if (((ItemStack)this.getInventory().get(slot)).func_190926_b()) {
                this.getInventory().set(slot, (Object)resultItemStack);
            } else if (((ItemStack)this.getInventory().get(slot)).func_77969_a(resultItemStack)) {
                if (((ItemStack)this.getInventory().get(slot)).func_190916_E() + resultItemStack.func_190916_E() > resultItemStack.func_77976_d()) {
                    resultItemStack.func_190917_f(((ItemStack)this.getInventory().get(slot)).func_190916_E() - resultItemStack.func_77976_d());
                    GCCoreUtil.spawnItem(this.field_145850_b, this.func_174877_v(), resultItemStack);
                    ((ItemStack)this.getInventory().get(slot)).func_190920_e(resultItemStack.func_77976_d());
                } else {
                    ((ItemStack)this.getInventory().get(slot)).func_190917_f(resultItemStack.func_190916_E());
                }
            }
            for (int i = 0; i < this.compressingCraftMatrix.func_70302_i_(); ++i) {
                if (!this.compressingCraftMatrix.func_70301_a(i).func_190926_b() && this.compressingCraftMatrix.func_70301_a(i).func_77973_b() == Items.field_151131_as) {
                    this.compressingCraftMatrix.setInventorySlotContentsNoUpdate(i, new ItemStack(Items.field_151133_ar));
                    continue;
                }
                this.compressingCraftMatrix.func_70298_a(i, 1);
            }
            this.updateInput();
        }
    }

    @Override
    protected boolean handleInventory() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.advanced = nbt.func_74767_n("adv");
        if (this.advanced) {
            this.processTimeRequired = this.processTimeRequiredBase = 120;
            this.setTierGC(3);
        }
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.inventory = NonNullList.func_191197_a((int)(this.func_70302_i_() - this.compressingCraftMatrix.func_70302_i_()), (Object)ItemStack.field_190927_a);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j >= 0 && j < this.inventory.size()) {
                this.inventory.set(j, (Object)new ItemStack(nbttagcompound));
                continue;
            }
            if (j >= this.inventory.size() + this.compressingCraftMatrix.func_70302_i_()) continue;
            this.compressingCraftMatrix.func_70299_a(j - this.inventory.size(), new ItemStack(nbttagcompound));
        }
        this.readMachineSidesFromNBT(nbt);
        this.updateInput();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound var4;
        int i;
        super.func_189515_b(nbt);
        nbt.func_74757_a("adv", this.advanced);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        NBTTagList items = new NBTTagList();
        for (i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).func_77955_b(var4);
            items.func_74742_a((NBTBase)var4);
        }
        for (i = 0; i < this.compressingCraftMatrix.func_70302_i_(); ++i) {
            if (this.compressingCraftMatrix.func_70301_a(i).func_190926_b()) continue;
            var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)(i + this.inventory.size()));
            this.compressingCraftMatrix.func_70301_a(i).func_77955_b(var4);
            items.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)items);
        this.addMachineSidesToNBT(nbt);
        return nbt;
    }

    @Override
    public int func_70302_i_() {
        return super.func_70302_i_() + this.compressingCraftMatrix.func_70302_i_();
    }

    @Override
    public ItemStack func_70301_a(int par1) {
        if (par1 >= this.getInventory().size()) {
            return this.compressingCraftMatrix.func_70301_a(par1 - this.inventory.size());
        }
        return (ItemStack)this.inventory.get(par1);
    }

    @Override
    public ItemStack func_70298_a(int par1, int par2) {
        if (par1 >= this.inventory.size()) {
            ItemStack result = this.compressingCraftMatrix.func_70298_a(par1 - this.inventory.size(), par2);
            if (!result.func_190926_b()) {
                this.updateInput();
            }
            this.func_70296_d();
            return result;
        }
        if (!((ItemStack)this.inventory.get(par1)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(par1)).func_190916_E() <= par2) {
                ItemStack var3 = (ItemStack)this.inventory.get(par1);
                this.inventory.set(par1, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return var3;
            }
            ItemStack var3 = ((ItemStack)this.inventory.get(par1)).func_77979_a(par2);
            if (((ItemStack)this.inventory.get(par1)).func_190926_b()) {
                this.inventory.set(par1, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return var3;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_70304_b(int par1) {
        if (par1 >= this.inventory.size()) {
            this.func_70296_d();
            return this.compressingCraftMatrix.func_70304_b(par1 - this.inventory.size());
        }
        if (!((ItemStack)this.inventory.get(par1)).func_190926_b()) {
            ItemStack var2 = (ItemStack)this.inventory.get(par1);
            this.inventory.set(par1, (Object)ItemStack.field_190927_a);
            this.func_70296_d();
            return var2;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_70299_a(int par1, ItemStack stack) {
        if (par1 >= this.inventory.size()) {
            this.compressingCraftMatrix.func_70299_a(par1 - this.inventory.size(), stack);
            this.updateInput();
        } else {
            this.inventory.set(par1, (Object)stack);
            if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
        }
        this.func_70296_d();
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && entityplayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return itemStack != null && !itemStack.func_190926_b() && ItemElectricBase.isElectricItem(itemStack.func_77973_b());
        }
        if (slotID >= 3) {
            if (!this.producingStack.func_190926_b()) {
                ItemStack stackInSlot = this.func_70301_a(slotID);
                return !stackInSlot.func_190926_b() && stackInSlot.func_77969_a(itemStack);
            }
            return this.isItemCompressorInput(itemStack, slotID - 3);
        }
        return false;
    }

    public boolean isItemCompressorInput(ItemStack stack, int id) {
        for (IRecipe recipe : CompressorRecipes.getRecipeList()) {
            if (recipe instanceof ShapedRecipesGC) {
                if (id >= ((ShapedRecipesGC)recipe).recipeItems.length) continue;
                ItemStack itemstack1 = ((ShapedRecipesGC)recipe).recipeItems[id];
                if (stack.func_77973_b() != itemstack1.func_77973_b() || itemstack1.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != itemstack1.func_77952_i()) continue;
                for (int i = 0; i < ((ShapedRecipesGC)recipe).recipeItems.length; ++i) {
                    if (i == id) continue;
                    ItemStack itemstack2 = ((ShapedRecipesGC)recipe).recipeItems[i];
                    if (stack.func_77973_b() != itemstack2.func_77973_b() || itemstack2.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != itemstack2.func_77952_i()) continue;
                    ItemStack is3 = this.func_70301_a(id + 3);
                    ItemStack is4 = this.func_70301_a(i + 3);
                    return is3.func_190926_b() || !is4.func_190926_b() && is3.func_190916_E() < is4.func_190916_E();
                }
                return true;
            }
            if (!(recipe instanceof ShapelessOreRecipeGC)) continue;
            ArrayList<Object> required = new ArrayList<Object>(((ShapelessOreRecipeGC)recipe).getInput());
            Iterator<Object> req = required.iterator();
            int match = 0;
            block2: while (req.hasNext()) {
                Object next = req.next();
                if (next instanceof ItemStack) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)stack, (boolean)false)) continue;
                    ++match;
                    continue;
                }
                if (!(next instanceof List)) continue;
                Iterator itr = ((List)next).iterator();
                while (itr.hasNext()) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)stack, (boolean)false)) continue;
                    ++match;
                    continue block2;
                }
            }
            if (match == 0) continue;
            if (match == 1) {
                return true;
            }
            int slotsFilled = 0;
            for (int i = 3; i < 12; ++i) {
                ItemStack inMatrix = this.func_70301_a(i);
                if (inMatrix.func_190926_b() || !inMatrix.func_77969_a(stack)) continue;
                ++slotsFilled;
            }
            if (slotsFilled < match) {
                return this.func_70301_a(id + 3).func_190926_b();
            }
            return randnum.nextInt(match) == 0;
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{1, 2};
        }
        ArrayList<Integer> removeSlots = new ArrayList<Integer>();
        ArrayList<Integer> doneSlots = new ArrayList<Integer>();
        for (int i = 3; i < 12; ++i) {
            ItemStack stack1;
            if (doneSlots.contains(i) || (stack1 = this.func_70301_a(i)).func_190926_b()) continue;
            int lowestCount = stack1.func_190916_E();
            int lowestSlot = i;
            ArrayList<Integer> slotsWithSameItem = new ArrayList<Integer>();
            for (int j = i + 1; j < 12; ++j) {
                ItemStack stack2;
                if (doneSlots.contains(j) || (stack2 = this.func_70301_a(j)).func_190926_b() || !stack1.func_77969_a(stack2)) continue;
                slotsWithSameItem.add(j);
                if (stack2.func_190916_E() >= lowestCount) continue;
                lowestCount = stack2.func_190916_E();
                lowestSlot = j;
            }
            if (slotsWithSameItem.isEmpty()) continue;
            if (lowestSlot != i) {
                removeSlots.add(i);
            }
            for (Integer k : slotsWithSameItem) {
                doneSlots.add(k);
                if (k == lowestSlot) continue;
                removeSlots.add(k);
            }
        }
        if (removeSlots.size() > 0) {
            int[] returnSlots = new int[10 - removeSlots.size()];
            returnSlots[0] = 0;
            int j = 1;
            for (int i = 3; i < 12; ++i) {
                if (removeSlots.contains(i)) continue;
                returnSlots[j++] = i;
            }
            return returnSlots;
        }
        return allSlots;
    }

    @Override
    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID == 1 || slotID == 2;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    @Override
    public EnumFacing byIndex() {
        return BlockMachineBase.byIndex(this.field_145850_b.func_180495_p(this.func_174877_v()));
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case RIGHT: {
                return this.byIndex().func_176735_f();
            }
            case REAR: {
                return this.byIndex().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.byIndex().func_176746_e();
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN};
    }

    @Override
    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT};
    }

    @Override
    public synchronized IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    @Override
    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    @Override
    public IMachineSidesProperties getConfigurationType() {
        return this.advanced ? BlockMachine4.MACHINESIDES_RENDERTYPE : BlockMachine2.MACHINESIDES_RENDERTYPE;
    }

    @Override
    @Deprecated
    @ForRemoval(deadline="4.1.0")
    @ReplaceWith(value="byIndex()")
    public EnumFacing getFront() {
        return this.byIndex();
    }
}

