/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.util;

import java.util.Arrays;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ConjoinedItemHandler
implements IItemHandlerModifiable {
    private final IItemHandler[] delegates;
    private final int[] baseIndices;

    public ConjoinedItemHandler(Collection<IItemHandler> delegates) {
        int i = 0;
        for (IItemHandler delegate : delegates) {
            i += delegate.getSlots();
        }
        this.delegates = new IItemHandler[i];
        this.baseIndices = new int[i];
        i = 0;
        for (IItemHandler delegate : delegates) {
            int slotCount = delegate.getSlots();
            for (int j = 0; j < slotCount; ++j) {
                this.delegates[i + j] = delegate;
                this.baseIndices[i + j] = i;
            }
            i += slotCount;
        }
    }

    public ConjoinedItemHandler(IItemHandler ... delegates) {
        this(Arrays.asList(delegates));
    }

    public int getSlots() {
        return this.delegates.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.delegates[slot].getStackInSlot(slot - this.baseIndices[slot]);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        IItemHandler inv = this.delegates[slot];
        if (inv instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)inv).setStackInSlot(slot - this.baseIndices[slot], stack);
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.delegates[slot].insertItem(slot - this.baseIndices[slot], stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.delegates[slot].extractItem(slot - this.baseIndices[slot], amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.delegates[slot].getSlotLimit(slot - this.baseIndices[slot]);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.delegates[slot].isItemValid(slot - this.baseIndices[slot], stack);
    }
}

