/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile;

import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.GridFlags;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.me.GridAccessException;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.AENetworkProxy;
import io.github.phantamanta44.libnine.capability.impl.L9AspectInventory;
import io.github.phantamanta44.libnine.capability.provider.CapabilityBrokerDirPredicated;
import io.github.phantamanta44.libnine.tile.RegisterTile;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import io.github.phantamanta44.libnine.util.data.serialization.AutoSerialize;
import io.github.phantamanta44.libnine.util.helper.InventoryUtils;
import io.github.phantamanta44.libnine.util.world.BlockSide;
import io.github.phantamanta44.libnine.util.world.IAllocableSides;
import io.github.phantamanta44.libnine.util.world.SideAlloc;
import io.github.phantamanta44.libnine.util.world.WorldUtils;
import io.github.phantamanta44.threng.ThrEngConfig;
import io.github.phantamanta44.threng.block.BlockMachine;
import io.github.phantamanta44.threng.tile.base.IDroppableInventory;
import io.github.phantamanta44.threng.tile.base.TileNetworkDevice;
import io.github.phantamanta44.threng.util.AppEngUtils;
import io.github.phantamanta44.threng.util.ConjoinedItemHandler;
import io.github.phantamanta44.threng.util.InsertOnlyItemHandler;
import io.github.phantamanta44.threng.util.SlotType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

@RegisterTile(value="threng")
public class TileFastCraftingBus
extends TileNetworkDevice
implements ICraftingProvider,
IAllocableSides<SlotType.BasicIO>,
IDroppableInventory {
    @AutoSerialize(sync=false)
    private final L9AspectInventory patternInventory = new L9AspectInventory.Observable(9, (i, o, n) -> {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.aeGrid().ifPresent(grid -> grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode())));
        }
        this.setDirty();
    });
    @AutoSerialize(sync=false)
    private final L9AspectInventory importInventory = new L9AspectInventory.Observable(9, (i, o, n) -> this.setDirty());
    @AutoSerialize(sync=false)
    private final L9AspectInventory exportInventory = new L9AspectInventory.Observable(9, (i, o, n) -> this.setDirty());
    @AutoSerialize
    private final SideAlloc<SlotType.BasicIO> sides = new SideAlloc((Enum)SlotType.BasicIO.OUTPUT, this::getFrontFace);
    private final List<ItemStack> cachedExportInvState = new ArrayList<ItemStack>();

    public TileFastCraftingBus() {
        this.markRequiresSync();
        Predicate<ItemStack> patternPred = stack -> stack.func_77973_b() instanceof ICraftingPatternItem;
        for (int i2 = 0; i2 < 9; ++i2) {
            this.patternInventory.withPredicate(i2, patternPred);
        }
    }

    protected ICapabilityProvider initCapabilities() {
        InsertOnlyItemHandler imports = new InsertOnlyItemHandler((IItemHandler)this.importInventory);
        return new CapabilityBrokerDirPredicated().with(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)imports, this.sides.getPredicate((Enum)SlotType.BasicIO.INPUT)).with(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)imports, this.sides.getPredicate((Enum)SlotType.BasicIO.OMNI));
    }

    @Override
    @Nullable
    protected ItemStack getNetworkRepresentation() {
        return BlockMachine.Type.FAST_CRAFTER.newStack(1);
    }

    @Override
    protected void initProxy(AENetworkProxy proxy) {
        if (ThrEngConfig.networkDevices.fastCrafterIdlePower > 0.0) {
            proxy.setIdlePowerUsage(ThrEngConfig.networkDevices.fastCrafterIdlePower);
        }
        proxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public IItemHandlerModifiable getPatternInventory() {
        return this.patternInventory;
    }

    public IItemHandlerModifiable getImportInventory() {
        return this.importInventory;
    }

    public IItemHandlerModifiable getExportInventory() {
        return this.exportInventory;
    }

    @Override
    public void collectDrops(Accrue<ItemStack> drops) {
        InventoryUtils.accrue(drops, (IItemHandler[])new IItemHandler[]{this.importInventory, this.exportInventory, this.patternInventory});
    }

    public void setFace(BlockSide face, SlotType.BasicIO state) {
        this.sides.setFace(face, (Enum)state);
        this.setDirty();
    }

    public SlotType.BasicIO getFace(BlockSide face) {
        return (SlotType.BasicIO)this.sides.getFace(face);
    }

    public void tick() {
        if (!this.field_145850_b.field_72995_K) {
            this.aeGrid().ifPresent(grid -> {
                IMEMonitor storage = ((IStorageGrid)grid.getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
                AppEngUtils.importItems((IItemHandlerModifiable)this.importInventory, (IMEMonitor<IAEItemStack>)storage, energy, this.actionSource);
            });
            if (this.isBusy()) {
                IItemHandler conjItemHandler = this.computeAdjInvs();
                for (int i = 0; i < this.exportInventory.getSlots(); ++i) {
                    ItemStack stack = this.exportInventory.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    this.exportInventory.setStackInSlot(i, ItemHandlerHelper.insertItem((IItemHandler)conjItemHandler, (ItemStack)stack, (boolean)false));
                }
            }
        }
    }

    public void provideCrafting(ICraftingProviderHelper helper) {
        for (int i = 0; i < this.patternInventory.getSlots(); ++i) {
            ICraftingPatternItem item;
            ICraftingPatternDetails pattern;
            ItemStack stack = this.patternInventory.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICraftingPatternItem) || (pattern = (item = (ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)) == null) continue;
            helper.addCraftingOption((ICraftingMedium)this, pattern);
        }
    }

    public boolean pushPattern(ICraftingPatternDetails pattern, InventoryCrafting inv) {
        block12: {
            IItemHandler conjItemHandler = this.computeAdjInvs();
            for (IAEItemStack input : pattern.getCondensedInputs()) {
                if (ItemHandlerHelper.insertItem((IItemHandler)conjItemHandler, (ItemStack)input.getDefinition(), (boolean)true).func_190926_b()) continue;
                return false;
            }
            int outBufIndex = 0;
            for (IAEItemStack input : pattern.getCondensedInputs()) {
                this.exportInventory.setStackInSlot(outBufIndex++, input.createItemStack());
            }
            try {
                block4: for (ICraftingCPU cpu : this.getProxy().getCrafting().getCpus()) {
                    if (!(cpu instanceof CraftingCPUCluster)) continue;
                    for (AppEngUtils.CraftingTask task : AppEngUtils.getTasks((CraftingCPUCluster)cpu)) {
                        if (!task.getPattern().equals(pattern)) continue;
                        for (long invocations = task.getInvocations() - 1L; invocations > 0L; --invocations) {
                            for (int i = 0; i < this.exportInventory.getSlots(); ++i) {
                                this.cachedExportInvState.add(this.exportInventory.getStackInSlot(i).func_77946_l());
                            }
                            for (IAEItemStack input : pattern.getCondensedInputs()) {
                                if (ItemHandlerHelper.insertItem((IItemHandler)this.exportInventory, (ItemStack)input.createItemStack(), (boolean)false).func_190926_b()) continue;
                                for (int i = 0; i < this.cachedExportInvState.size(); ++i) {
                                    this.exportInventory.setStackInSlot(i, this.cachedExportInvState.get(i));
                                }
                                this.cachedExportInvState.clear();
                                break block12;
                            }
                            if (task.tryExtractItems(cpu.getActionSource())) {
                                this.cachedExportInvState.clear();
                                task.decrement();
                                continue;
                            }
                            for (int i = 0; i < this.cachedExportInvState.size(); ++i) {
                                this.exportInventory.setStackInSlot(i, this.cachedExportInvState.get(i));
                            }
                            this.cachedExportInvState.clear();
                            continue block4;
                        }
                        continue block4;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean isBusy() {
        for (int i = 0; i < this.exportInventory.getSlots(); ++i) {
            if (this.exportInventory.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    private IItemHandler computeAdjInvs() {
        ArrayList<IItemHandler> adjInvs = new ArrayList<IItemHandler>();
        for (BlockSide side : BlockSide.values()) {
            if (!((SlotType.BasicIO)this.sides.getFace((BlockSide)side)).allowsOutput) continue;
            EnumFacing dir = side.getDirection(this.getFrontFace());
            EnumFacing fromDir = dir.func_176734_d();
            TileEntity adj = WorldUtils.getAdjacentTile((TileEntity)this, (EnumFacing)dir);
            if (adj == null || !adj.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, fromDir)) continue;
            adjInvs.add((IItemHandler)adj.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, fromDir));
        }
        return new ConjoinedItemHandler(adjInvs);
    }
}

