/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.nbt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.phantamanta44.libnine.util.helper.JsonUtils9;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public interface ImmutableNbt<T extends NBTBase> {
    public static <T extends NBTBase> ImmutableNbt<T> wrap(T tag) {
        switch (tag.func_74732_a()) {
            case 10: {
                ImmutableMap.Builder entries = ImmutableMap.builder();
                NBTTagCompound compoundTag = (NBTTagCompound)tag;
                for (String key : compoundTag.func_150296_c()) {
                    entries.put((Object)key, ImmutableNbt.wrap(compoundTag.func_74781_a(key)));
                }
                return new ImmCompound(entries.build());
            }
            case 9: {
                ImmutableList.Builder entries = ImmutableList.builder();
                for (NBTBase entry : (NBTTagList)tag) {
                    entries.add(ImmutableNbt.wrap(entry));
                }
                return new ImmList(entries.build());
            }
            case 8: {
                return new ImmString(((NBTTagString)tag).func_150285_a_());
            }
            case 3: {
                return new ImmInteger(((NBTTagInt)tag).func_150287_d());
            }
            case 1: {
                return new ImmByte(((NBTTagByte)tag).func_150290_f());
            }
        }
        throw new UnsupportedOperationException("NBT tag type not supported: " + tag.getClass().getSimpleName());
    }

    public static ImmutableNbt<?> parse(JsonElement dto) {
        if (dto.isJsonObject()) {
            return ImmutableNbt.parseObject(dto.getAsJsonObject());
        }
        if (dto.isJsonArray()) {
            ImmutableList.Builder entries = ImmutableList.builder();
            for (JsonElement entry : dto.getAsJsonArray()) {
                entries.add(ImmutableNbt.parse(entry));
            }
            return new ImmList(entries.build());
        }
        if (dto.isJsonPrimitive()) {
            JsonPrimitive primDto = dto.getAsJsonPrimitive();
            if (primDto.isNumber()) {
                return new ImmInteger(primDto.getAsInt());
            }
            if (primDto.isString()) {
                return new ImmString(primDto.getAsString());
            }
            if (primDto.isBoolean()) {
                return new ImmByte(primDto.getAsBoolean() ? (byte)1 : 0);
            }
        }
        throw new IllegalArgumentException("Cannot parse NBT from JSON: " + JsonUtils9.GSON.toJson(dto));
    }

    public static ImmCompound parseObject(JsonObject dto) {
        ImmutableMap.Builder entries = ImmutableMap.builder();
        for (Map.Entry entry : dto.entrySet()) {
            entries.put(entry.getKey(), ImmutableNbt.parse((JsonElement)entry.getValue()));
        }
        return new ImmCompound(entries.build());
    }

    public int getTagType();

    public T createTag();

    default public T write(T tag) {
        return this.createTag();
    }

    default public T writeUnchecked(NBTBase tag) {
        return (T)this.write(tag);
    }

    public static class ImmByte
    implements ImmutableNbt<NBTTagByte> {
        private final byte value;

        public ImmByte(byte value) {
            this.value = value;
        }

        @Override
        public int getTagType() {
            return 1;
        }

        @Override
        public NBTTagByte createTag() {
            return new NBTTagByte(this.value);
        }
    }

    public static class ImmInteger
    implements ImmutableNbt<NBTTagInt> {
        private final int value;

        public ImmInteger(int value) {
            this.value = value;
        }

        @Override
        public int getTagType() {
            return 3;
        }

        @Override
        public NBTTagInt createTag() {
            return new NBTTagInt(this.value);
        }
    }

    public static class ImmString
    implements ImmutableNbt<NBTTagString> {
        private final String value;

        public ImmString(String value) {
            this.value = value;
        }

        @Override
        public int getTagType() {
            return 8;
        }

        @Override
        public NBTTagString createTag() {
            return new NBTTagString(this.value);
        }
    }

    public static class ImmList
    implements ImmutableNbt<NBTTagList> {
        private final ImmutableList<ImmutableNbt<?>> entries;

        public ImmList(ImmutableList<ImmutableNbt<?>> entries) {
            this.entries = entries;
        }

        @Override
        public int getTagType() {
            return 9;
        }

        @Override
        public NBTTagList createTag() {
            return this.write(new NBTTagList());
        }

        @Override
        public NBTTagList write(NBTTagList tag) {
            for (ImmutableNbt entry : this.entries) {
                tag.func_74742_a(entry.createTag());
            }
            return tag;
        }
    }

    public static class ImmCompound
    implements ImmutableNbt<NBTTagCompound> {
        private final Map<String, ImmutableNbt<?>> entries;

        public ImmCompound(ImmutableMap<String, ImmutableNbt<?>> entries) {
            this.entries = entries;
        }

        @Override
        public int getTagType() {
            return 10;
        }

        @Override
        public NBTTagCompound createTag() {
            return this.write(new NBTTagCompound());
        }

        @Override
        public NBTTagCompound write(NBTTagCompound tag) {
            this.entries.forEach((k, v) -> {
                if (tag.func_150297_b(k, v.getTagType())) {
                    Object newValue;
                    NBTBase value = tag.func_74781_a(k);
                    if (value != (newValue = v.writeUnchecked(value))) {
                        tag.func_74782_a(k, newValue);
                    }
                } else {
                    tag.func_74782_a(k, v.createTag());
                }
            });
            return tag;
        }
    }
}

