/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.audience;

import java.util.Arrays;
import java.util.stream.Collector;
import me.lucko.luckperms.lib.adventure.audience.Audiences;
import me.lucko.luckperms.lib.adventure.audience.EmptyAudience;
import me.lucko.luckperms.lib.adventure.audience.ForwardingAudience;
import me.lucko.luckperms.lib.adventure.audience.MessageType;
import me.lucko.luckperms.lib.adventure.bossbar.BossBar;
import me.lucko.luckperms.lib.adventure.inventory.Book;
import me.lucko.luckperms.lib.adventure.sound.Sound;
import me.lucko.luckperms.lib.adventure.sound.SoundStop;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.title.Title;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Audience {
    public static @NonNull Audience empty() {
        return EmptyAudience.INSTANCE;
    }

    public static @NonNull Audience audience(Audience ... audiences) {
        int length = audiences.length;
        if (length == 0) {
            return Audience.empty();
        }
        if (length == 1) {
            return audiences[0];
        }
        return Audience.audience(Arrays.asList(audiences));
    }

    public static @NonNull ForwardingAudience audience(@NonNull Iterable<? extends Audience> audiences) {
        return () -> audiences;
    }

    public static @NonNull Collector<? super Audience, ?, ForwardingAudience> toAudience() {
        return Audiences.COLLECTOR;
    }

    default public void sendMessage(@NonNull ComponentLike message) {
        this.sendMessage(message.asComponent());
    }

    default public void sendMessage(@NonNull Component message) {
        this.sendMessage(message, MessageType.SYSTEM);
    }

    default public void sendMessage(@NonNull ComponentLike message, @NonNull MessageType type) {
        this.sendMessage(message.asComponent(), type);
    }

    default public void sendMessage(@NonNull Component message, @NonNull MessageType type) {
    }

    default public void sendActionBar(@NonNull ComponentLike message) {
        this.sendActionBar(message.asComponent());
    }

    default public void sendActionBar(@NonNull Component message) {
    }

    default public void showTitle(@NonNull Title title) {
    }

    default public void clearTitle() {
    }

    default public void resetTitle() {
    }

    default public void showBossBar(@NonNull BossBar bar) {
    }

    default public void hideBossBar(@NonNull BossBar bar) {
    }

    default public void playSound(@NonNull Sound sound) {
    }

    default public void playSound(@NonNull Sound sound, double x, double y, double z) {
    }

    default public void stopSound(@NonNull SoundStop stop) {
    }

    default public void openBook(@NonNull Book.Builder book) {
        this.openBook(book.build());
    }

    default public void openBook(@NonNull Book book) {
    }
}

