/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.world.gen.structure;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import stevekung.mods.moreplanets.entity.EntitySpaceMinecartChest;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityInfectedCaveSpider;
import stevekung.mods.stevekunglib.utils.BlockStateProperty;

public class StructureNibiruMineshaftPieces {
    public static void registerStructurePieces() {
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"NibiruMSCorridor");
        MapGenStructureIO.func_143031_a(Cross.class, (String)"NibiruMSCrossing");
        MapGenStructureIO.func_143031_a(Room.class, (String)"NibiruMSRoom");
        MapGenStructureIO.func_143031_a(Stairs.class, (String)"NibiruMSStairs");
    }

    public static class Stairs
    extends Piece {
        public Stairs() {
        }

        public Stairs(int type, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            int i = this.func_74877_c();
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, i);
                        break;
                    }
                    case EAST: {
                        this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, i);
                    }
                }
            }
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_175804_a(world, box, 0, 5, 0, 2, 7, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 0, 0, 7, 2, 2, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (int i = 0; i < 5; ++i) {
                this.func_175804_a(world, box, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }
    }

    public static class Room
    extends Piece {
        private List<StructureBoundingBox> roomsLinkedToTheRoom = new LinkedList<StructureBoundingBox>();

        public Room() {
        }

        public Room(int type, Random rand, int x, int z) {
            super(type);
            this.field_74887_e = new StructureBoundingBox(x, 50, z, x + 7 + rand.nextInt(6), 54 + rand.nextInt(6), z + 7 + rand.nextInt(6));
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            Piece piece;
            int l;
            int i = this.func_74877_c();
            int k = this.field_74887_e.func_78882_c() - 3 - 1;
            if (k <= 0) {
                k = 1;
            }
            int j = 0;
            while (j < this.field_74887_e.func_78883_b() && (l = j + rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b()) {
                piece = this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + l, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                if (piece != null) {
                    StructureBoundingBox box = piece.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new StructureBoundingBox(box.field_78897_a, box.field_78895_b, this.field_74887_e.field_78896_c, box.field_78893_d, box.field_78894_e, this.field_74887_e.field_78896_c + 1));
                }
                j = l + 4;
            }
            int i1 = 0;
            while (i1 < this.field_74887_e.func_78883_b() && (l = i1 + rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b()) {
                piece = this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + l, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                if (piece != null) {
                    StructureBoundingBox box1 = piece.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new StructureBoundingBox(box1.field_78897_a, box1.field_78895_b, this.field_74887_e.field_78892_f - 1, box1.field_78893_d, box1.field_78894_e, this.field_74887_e.field_78892_f));
                }
                i1 = l + 4;
            }
            int j1 = 0;
            while (j1 < this.field_74887_e.func_78880_d() && (l = j1 + rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d()) {
                piece = this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78896_c + l, EnumFacing.WEST, i);
                if (piece != null) {
                    StructureBoundingBox box2 = piece.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.field_74887_e.field_78897_a, box2.field_78895_b, box2.field_78896_c, this.field_74887_e.field_78897_a + 1, box2.field_78894_e, box2.field_78892_f));
                }
                j1 = l + 4;
            }
            int k1 = 0;
            while (k1 < this.field_74887_e.func_78880_d() && (l = k1 + rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d()) {
                Piece structurecomponent = this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78896_c + l, EnumFacing.EAST, i);
                if (structurecomponent != null) {
                    StructureBoundingBox box3 = structurecomponent.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.field_74887_e.field_78893_d - 1, box3.field_78895_b, box3.field_78896_c, this.field_74887_e.field_78893_d, box3.field_78894_e, box3.field_78892_f));
                }
                k1 = l + 4;
            }
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, MPBlocks.INFECTED_DIRT.func_176223_P(), Blocks.field_150350_a.func_176223_P(), true);
            this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (StructureBoundingBox room : this.roomsLinkedToTheRoom) {
                this.func_175804_a(world, room, room.field_78897_a, room.field_78894_e - 2, room.field_78896_c, room.field_78893_d, room.field_78894_e, room.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.func_180777_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), false);
            return true;
        }

        public void func_181138_a(int x, int y, int z) {
            super.func_181138_a(x, y, z);
            for (StructureBoundingBox box : this.roomsLinkedToTheRoom) {
                box.func_78886_a(x, y, z);
            }
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            NBTTagList nbttaglist = new NBTTagList();
            for (StructureBoundingBox box : this.roomsLinkedToTheRoom) {
                nbttaglist.func_74742_a((NBTBase)box.func_151535_h());
            }
            nbt.func_74782_a("Entrances", (NBTBase)nbttaglist);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            NBTTagList nbttaglist = nbt.func_150295_c("Entrances", 11);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(nbttaglist.func_150306_c(i)));
            }
        }
    }

    static abstract class Piece
    extends StructureComponent {
        public Piece() {
        }

        public Piece(int type) {
            super(type);
        }

        protected void func_143012_a(NBTTagCompound nbt) {
        }

        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
        }

        protected IBlockState getPlanks() {
            return MPBlocks.INFECTED_OAK_PLANKS.func_176223_P();
        }

        protected IBlockState getFence() {
            return MPBlocks.INFECTED_OAK_FENCE.func_176223_P();
        }

        protected boolean isSupportingBox(World world, StructureBoundingBox box, int xMin, int x, int y, int z) {
            for (int i = xMin; i <= x; ++i) {
                if (this.func_175807_a(world, i, y + 1, z, box).func_185904_a() != Material.field_151579_a) continue;
                return false;
            }
            return true;
        }

        protected Piece generateAndAddPiece(StructureComponent component, List<StructureComponent> list, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            if (type > 8) {
                return null;
            }
            if (Math.abs(x - component.func_74874_b().field_78897_a) <= 80 && Math.abs(z - component.func_74874_b().field_78896_c) <= 80) {
                Piece piece = this.createRandomShaftPiece(list, rand, x, y, z, facing, type + 1);
                if (piece != null) {
                    list.add(piece);
                    piece.func_74861_a(component, list, rand);
                }
                return piece;
            }
            return null;
        }

        private Piece createRandomShaftPiece(List<StructureComponent> component, Random rand, int x, int y, int z, @Nullable EnumFacing facing, int type) {
            int i = rand.nextInt(100);
            if (i >= 80) {
                StructureBoundingBox box = this.findCrossing(component, rand, x, y, z, facing);
                if (box != null) {
                    return new Cross(type, box, facing);
                }
            } else if (i >= 70) {
                StructureBoundingBox box = this.findStairs(component, rand, x, y, z, facing);
                if (box != null) {
                    return new Stairs(type, box, facing);
                }
            } else {
                StructureBoundingBox box = this.findCorridorSize(component, rand, x, y, z, facing);
                if (box != null) {
                    return new Corridor(type, rand, box, facing);
                }
            }
            return null;
        }

        private StructureBoundingBox findCorridorSize(List<StructureComponent> list, Random rand, int x, int y, int z, EnumFacing facing) {
            int i;
            StructureBoundingBox box = new StructureBoundingBox(x, y, z, x, y + 2, z);
            for (i = rand.nextInt(3) + 2; i > 0; --i) {
                int j = i * 5;
                switch (facing) {
                    default: {
                        box.field_78893_d = x + 2;
                        box.field_78896_c = z - (j - 1);
                        break;
                    }
                    case SOUTH: {
                        box.field_78893_d = x + 2;
                        box.field_78892_f = z + j - 1;
                        break;
                    }
                    case WEST: {
                        box.field_78897_a = x - (j - 1);
                        box.field_78892_f = z + 2;
                        break;
                    }
                    case EAST: {
                        box.field_78893_d = x + j - 1;
                        box.field_78892_f = z + 2;
                    }
                }
                if (StructureComponent.func_74883_a(list, (StructureBoundingBox)box) == null) break;
            }
            return i > 0 ? box : null;
        }

        private StructureBoundingBox findCrossing(List<StructureComponent> list, Random rand, int x, int y, int z, EnumFacing facing) {
            StructureBoundingBox box = new StructureBoundingBox(x, y, z, x, y + 2, z);
            if (rand.nextInt(4) == 0) {
                box.field_78894_e += 4;
            }
            switch (facing) {
                default: {
                    box.field_78897_a = x - 1;
                    box.field_78893_d = x + 3;
                    box.field_78896_c = z - 4;
                    break;
                }
                case SOUTH: {
                    box.field_78897_a = x - 1;
                    box.field_78893_d = x + 3;
                    box.field_78892_f = z + 3 + 1;
                    break;
                }
                case WEST: {
                    box.field_78897_a = x - 4;
                    box.field_78896_c = z - 1;
                    box.field_78892_f = z + 3;
                    break;
                }
                case EAST: {
                    box.field_78893_d = x + 3 + 1;
                    box.field_78896_c = z - 1;
                    box.field_78892_f = z + 3;
                }
            }
            return StructureComponent.func_74883_a(list, (StructureBoundingBox)box) != null ? null : box;
        }

        private StructureBoundingBox findStairs(List<StructureComponent> list, Random rand, int x, int y, int z, EnumFacing facing) {
            StructureBoundingBox box = new StructureBoundingBox(x, y - 5, z, x, y + 2, z);
            switch (facing) {
                default: {
                    box.field_78893_d = x + 2;
                    box.field_78896_c = z - 8;
                    break;
                }
                case SOUTH: {
                    box.field_78893_d = x + 2;
                    box.field_78892_f = z + 8;
                    break;
                }
                case WEST: {
                    box.field_78897_a = x - 8;
                    box.field_78892_f = z + 2;
                    break;
                }
                case EAST: {
                    box.field_78893_d = x + 8;
                    box.field_78892_f = z + 2;
                }
            }
            return StructureComponent.func_74883_a(list, (StructureBoundingBox)box) != null ? null : box;
        }
    }

    public static class Cross
    extends Piece {
        private EnumFacing corridorDirection;
        private boolean isMultipleFloors;

        public Cross() {
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            nbt.func_74757_a("tf", this.isMultipleFloors);
            nbt.func_74768_a("D", this.corridorDirection.func_176736_b());
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            this.isMultipleFloors = nbt.func_74767_n("tf");
            this.corridorDirection = EnumFacing.func_176731_b((int)nbt.func_74762_e("D"));
        }

        public Cross(int type, StructureBoundingBox box, @Nullable EnumFacing facing) {
            super(type);
            this.corridorDirection = facing;
            this.field_74887_e = box;
            this.isMultipleFloors = box.func_78882_c() > 3;
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            int i = this.func_74877_c();
            switch (this.corridorDirection) {
                default: {
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                    break;
                }
                case SOUTH: {
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                    break;
                }
                case WEST: {
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    break;
                }
                case EAST: {
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                }
            }
            if (this.isMultipleFloors) {
                if (rand.nextBoolean()) {
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                }
                if (rand.nextBoolean()) {
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                }
                if (rand.nextBoolean()) {
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                }
                if (rand.nextBoolean()) {
                    this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                }
            }
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            IBlockState iblockstate = this.getPlanks();
            if (this.isMultipleFloors) {
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            } else {
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.placeSupportPillar(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (this.func_175807_a(world, i, this.field_74887_e.field_78895_b - 1, j, box).func_185904_a() != Material.field_151579_a || this.func_189916_b(world, i, this.field_74887_e.field_78895_b - 1, j, box) >= 8) continue;
                    this.func_175811_a(world, iblockstate, i, this.field_74887_e.field_78895_b - 1, j, box);
                }
            }
            return true;
        }

        private void placeSupportPillar(World world, StructureBoundingBox box, int x, int minY, int z, int maxY) {
            if (this.func_175807_a(world, x, maxY + 1, z, box).func_185904_a() != Material.field_151579_a) {
                this.func_175804_a(world, box, x, minY, z, x, maxY, z, this.getPlanks(), Blocks.field_150350_a.func_176223_P(), false);
            }
        }
    }

    public static class Corridor
    extends Piece {
        private boolean hasRails;
        private boolean hasSpiders;
        private boolean spawnerPlaced;
        private int sectionCount;

        public Corridor() {
        }

        public Corridor(int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
            this.hasRails = rand.nextInt(3) == 0;
            this.hasSpiders = !this.hasRails && rand.nextInt(23) == 0;
            this.sectionCount = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? box.func_78880_d() / 5 : box.func_78883_b() / 5;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            nbt.func_74757_a("hr", this.hasRails);
            nbt.func_74757_a("sc", this.hasSpiders);
            nbt.func_74757_a("hps", this.spawnerPlaced);
            nbt.func_74768_a("Num", this.sectionCount);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            this.hasRails = nbt.func_74767_n("hr");
            this.hasSpiders = nbt.func_74767_n("sc");
            this.spawnerPlaced = nbt.func_74767_n("hps");
            this.sectionCount = nbt.func_74762_e("Num");
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            block24: {
                int i = this.func_74877_c();
                int j = rand.nextInt(4);
                EnumFacing enumfacing = this.func_186165_e();
                if (enumfacing != null) {
                    switch (enumfacing) {
                        default: {
                            if (j <= 1) {
                                this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.WEST, i);
                                break;
                            }
                            this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.EAST, i);
                            break;
                        }
                        case SOUTH: {
                            if (j <= 1) {
                                this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.WEST, i);
                                break;
                            }
                            this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.EAST, i);
                            break;
                        }
                        case WEST: {
                            if (j <= 1) {
                                this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                                break;
                            }
                            this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                            break;
                        }
                        case EAST: {
                            if (j <= 1) {
                                this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                                break;
                            }
                            this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (enumfacing != EnumFacing.NORTH && enumfacing != EnumFacing.SOUTH) {
                    int i1 = this.field_74887_e.field_78897_a + 3;
                    while (i1 + 3 <= this.field_74887_e.field_78893_d) {
                        int j1 = rand.nextInt(5);
                        if (j1 == 0) {
                            this.generateAndAddPiece(component, list, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i + 1);
                        } else if (j1 == 1) {
                            this.generateAndAddPiece(component, list, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i + 1);
                        }
                        i1 += 5;
                    }
                } else {
                    int k = this.field_74887_e.field_78896_c + 3;
                    while (k + 3 <= this.field_74887_e.field_78892_f) {
                        int l = rand.nextInt(5);
                        if (l == 0) {
                            this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, k, EnumFacing.WEST, i + 1);
                        } else if (l == 1) {
                            this.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, k, EnumFacing.EAST, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean func_186167_a(World world, StructureBoundingBox structurebb, Random rand, int x, int y, int z, ResourceLocation loot) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (structurebb.func_175898_b((Vec3i)blockpos) && world.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a && world.func_180495_p(blockpos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
                IBlockState iblockstate = Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)(rand.nextBoolean() ? BlockRailBase.EnumRailDirection.NORTH_SOUTH : BlockRailBase.EnumRailDirection.EAST_WEST));
                this.func_175811_a(world, iblockstate, x, y, z, structurebb);
                EntitySpaceMinecartChest entityminecartchest = new EntitySpaceMinecartChest(world, (float)blockpos.func_177958_n() + 0.5f, (float)blockpos.func_177956_o() + 0.5f, (float)blockpos.func_177952_p() + 0.5f);
                entityminecartchest.func_184289_a(loot, rand.nextLong());
                entityminecartchest.func_174899_a(MPBlocks.INFECTED_CHEST.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)EnumFacing.NORTH));
                entityminecartchest.func_94086_l(8);
                world.func_72838_d((Entity)entityminecartchest);
                return true;
            }
            return false;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            int i1 = this.sectionCount * 5 - 1;
            IBlockState iblockstate = this.getPlanks();
            this.func_175804_a(world, box, 0, 0, 0, 2, 1, i1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_189914_a(world, box, rand, 0.8f, 0, 2, 0, 2, 2, i1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false, 0);
            if (this.hasSpiders) {
                this.func_189914_a(world, box, rand, 0.6f, 0, 0, 0, 2, 1, i1, Blocks.field_150321_G.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false, 8);
            }
            for (int j1 = 0; j1 < this.sectionCount; ++j1) {
                int k2;
                int k1 = 2 + j1 * 5;
                this.placeSupport(world, box, 0, 0, k1, 2, 2, rand);
                this.placeCobWeb(world, box, rand, 0.1f, 0, 2, k1 - 1);
                this.placeCobWeb(world, box, rand, 0.1f, 2, 2, k1 - 1);
                this.placeCobWeb(world, box, rand, 0.1f, 0, 2, k1 + 1);
                this.placeCobWeb(world, box, rand, 0.1f, 2, 2, k1 + 1);
                this.placeCobWeb(world, box, rand, 0.05f, 0, 2, k1 - 2);
                this.placeCobWeb(world, box, rand, 0.05f, 2, 2, k1 - 2);
                this.placeCobWeb(world, box, rand, 0.05f, 0, 2, k1 + 2);
                this.placeCobWeb(world, box, rand, 0.05f, 2, 2, k1 + 2);
                if (rand.nextInt(100) == 0) {
                    this.func_186167_a(world, box, rand, 2, 0, k1 - 1, MPLootTables.COMMON_SPACE_MINESHAFT);
                }
                if (!this.hasSpiders || this.spawnerPlaced) continue;
                int l1 = this.func_74862_a(0);
                int i2 = k1 - 1 + rand.nextInt(3);
                int j2 = this.func_74865_a(1, i2);
                BlockPos blockpos = new BlockPos(j2, l1, k2 = this.func_74873_b(1, i2));
                if (!box.func_175898_b((Vec3i)blockpos) || this.func_189916_b(world, 1, 0, i2, box) >= 8) continue;
                this.spawnerPlaced = true;
                world.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileentity = world.func_175625_s(blockpos);
                if (!(tileentity instanceof TileEntityMobSpawner)) continue;
                ((TileEntityMobSpawner)tileentity).func_145881_a().func_190894_a(EntityList.func_191306_a(EntityInfectedCaveSpider.class));
            }
            for (int l2 = 0; l2 <= 2; ++l2) {
                for (int i3 = 0; i3 <= i1; ++i3) {
                    IBlockState iblockstate3 = this.func_175807_a(world, l2, -1, i3, box);
                    if (iblockstate3.func_185904_a() != Material.field_151579_a || this.func_189916_b(world, l2, -1, i3, box) >= 8) continue;
                    this.func_175811_a(world, iblockstate, l2, -1, i3, box);
                }
            }
            if (this.hasRails) {
                IBlockState iblockstate1 = Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                for (int j3 = 0; j3 <= i1; ++j3) {
                    IBlockState iblockstate2 = this.func_175807_a(world, 1, -1, j3, box);
                    if (iblockstate2.func_185904_a() == Material.field_151579_a || !iblockstate2.func_185913_b()) continue;
                    float f = this.func_189916_b(world, 1, 0, j3, box) > 8 ? 0.9f : 0.7f;
                    this.func_175809_a(world, box, rand, f, 1, 0, j3, iblockstate1);
                }
            }
            return true;
        }

        private void placeSupport(World world, StructureBoundingBox box, int par3, int par4, int par5, int par6, int par7, Random rand) {
            if (this.isSupportingBox(world, box, par3, par7, par6, par5)) {
                IBlockState iblockstate = this.getPlanks();
                IBlockState iblockstate1 = this.getFence();
                IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
                this.func_175804_a(world, box, par3, par4, par5, par3, par6 - 1, par5, iblockstate1, iblockstate2, false);
                this.func_175804_a(world, box, par7, par4, par5, par7, par6 - 1, par5, iblockstate1, iblockstate2, false);
                if (rand.nextInt(4) == 0) {
                    this.func_175804_a(world, box, par3, par6, par5, par3, par6, par5, iblockstate, iblockstate2, false);
                    this.func_175804_a(world, box, par7, par6, par5, par7, par6, par5, iblockstate, iblockstate2, false);
                } else {
                    this.func_175804_a(world, box, par3, par6, par5, par7, par6, par5, iblockstate, iblockstate2, false);
                    this.func_175809_a(world, box, rand, 0.05f, par3 + 1, par6, par5 - 1, MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH));
                    this.func_175809_a(world, box, rand, 0.05f, par3 + 1, par6, par5 + 1, MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH));
                }
            }
        }

        private void placeCobWeb(World world, StructureBoundingBox box, Random rand, float chance, int x, int y, int z) {
            if (this.func_189916_b(world, x, y, z, box) < 8) {
                this.func_175809_a(world, box, rand, chance, x, y, z, Blocks.field_150321_G.func_176223_P());
            }
        }
    }
}

