/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.integration.waila;

import java.util.List;
import java.util.UUID;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.WailaPlugin;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.blocks.BlockDummy;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.integration.waila.HUDHandlerFurnaceMP;
import stevekung.mods.moreplanets.integration.waila.WailaUtils;
import stevekung.mods.moreplanets.planets.diona.tileentity.TileEntityDarkEnergyCore;
import stevekung.mods.moreplanets.planets.diona.tileentity.TileEntityDarkEnergyGenerator;
import stevekung.mods.moreplanets.planets.nibiru.tileentity.TileEntityNuclearWasteGenerator;
import stevekung.mods.moreplanets.planets.nibiru.tileentity.TileEntityNuclearWasteTank;
import stevekung.mods.moreplanets.tileentity.TileEntityBlackHoleStorage;
import stevekung.mods.moreplanets.tileentity.TileEntityDarkEnergyReceiver;
import stevekung.mods.moreplanets.tileentity.TileEntityDummy;
import stevekung.mods.moreplanets.tileentity.TileEntityShieldGenerator;
import stevekung.mods.moreplanets.tileentity.TileEntitySpaceWarpPadFull;
import stevekung.mods.moreplanets.utils.IDescription;
import stevekung.mods.moreplanets.utils.LoggerMP;
import stevekung.mods.moreplanets.utils.tileentity.TileEntityEnergyStorageClusterMP;
import stevekung.mods.stevekunglib.utils.CommonUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;
import stevekung.mods.stevekunglib.utils.client.ClientUtils;

@WailaPlugin
public class WailaTileEntityProviderMP
implements IWailaDataProvider,
IWailaPlugin {
    public WailaTileEntityProviderMP() {
        WailaUtils.dataProvider = this;
    }

    public void register(IWailaRegistrar register) {
        LoggerMP.info("Waila Integration initialized");
        WailaUtils.register = register;
        HUDHandlerFurnaceMP.register(register);
        WailaUtils.register(TileEntityDarkEnergyReceiver.class, true, true, false, false, false);
        WailaUtils.register(TileEntityDarkEnergyCore.class, true, true, false, false, false);
        WailaUtils.register(TileEntitySpaceWarpPadFull.class, true, true, false, false, false);
        WailaUtils.register(TileEntityDarkEnergyGenerator.class, true, true, false, false, false);
        WailaUtils.register(TileEntityEnergyStorageClusterMP.class, true, true, false, false, false);
        WailaUtils.register(TileEntityBlackHoleStorage.class, true, true, false, false, false);
        WailaUtils.register(TileEntityShieldGenerator.class, true, true, false, false, false);
        WailaUtils.register(TileEntityNuclearWasteGenerator.class, true, true, false, false, false);
        WailaUtils.register(TileEntityNuclearWasteTank.class, true, true, false, false, false);
        WailaUtils.register(IDescription.class, false, false, true, false, false);
        WailaUtils.register(BlockDummy.class, true, true, true, false, false);
        WailaUtils.register(MPBlocks.DER_SOLAR1_DUMMY.getClass(), true, true, true, false, false);
        WailaUtils.register(MPBlocks.DER_SOLAR2_DUMMY.getClass(), true, true, true, false, false);
        WailaUtils.register(MPBlocks.DER_SOLAR3_DUMMY.getClass(), true, true, true, false, false);
        WailaUtils.register(MPBlocks.DER_SOLAR4_DUMMY.getClass(), true, true, true, false, false);
        WailaUtils.register(MPBlocks.WARP_PAD_DUMMY.getClass(), true, true, true, false, false);
        WailaUtils.register(MPBlocks.SHIELD_GENERATOR_DUMMY.getClass(), true, true, true, false, false);
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return ItemStack.field_190927_a;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        int transform;
        int process;
        TileEntity tile = accessor.getTileEntity();
        Block block = accessor.getBlock();
        NBTTagCompound nbt = accessor.getNBTData();
        if (nbt.func_74764_b("EnergyF") && block != MPBlocks.NWT_MIDDLE_DUMMY && block != MPBlocks.NWT_TOP_DUMMY && !(tile instanceof TileEntityNuclearWasteTank)) {
            tooltip.add(TextFormatting.GREEN + LangUtils.translate((String)"gui.message.energy") + ": " + EnergyDisplayHelper.getEnergyDisplayS((float)nbt.func_74760_g("EnergyF")));
        }
        if (block == MPBlocks.DER_SOLAR1_DUMMY || block == MPBlocks.DER_SOLAR2_DUMMY || block == MPBlocks.DER_SOLAR3_DUMMY || block == MPBlocks.DER_SOLAR4_DUMMY) {
            process = nbt.func_74762_e("ActivatedTick") * 100 / 12000;
            int destruct = nbt.func_74762_e("FailedTick");
            if (destruct > 0) {
                destruct = 600 - destruct;
                tooltip.add(TextFormatting.DARK_RED + LangUtils.translate((String)"gui.status.destruct.name") + ": " + CommonUtils.ticksToElapsedTime((int)destruct));
            } else {
                tooltip.add(LangUtils.translate((String)"gui.message.status.name") + ": " + nbt.func_74779_i("Status"));
            }
            if (process > 0 && process < 100) {
                tooltip.add("Process: " + process + "%");
            }
        }
        if (block == MPBlocks.WARP_PAD_DUMMY && tile instanceof TileEntityDummy) {
            TileEntityDummy dummy = (TileEntityDummy)tile;
            TileEntitySpaceWarpPadFull warp = (TileEntitySpaceWarpPadFull)accessor.getWorld().func_175625_s(dummy.mainBlockPosition);
            String dimension = LangUtils.translate((String)"gui.status.unknown.name");
            String name = LangUtils.translate((String)"gui.status.unknown.name");
            String dest = LangUtils.translate((String)"gui.status.unknown.name");
            if (warp.hasWarpCore() && ((ItemStack)warp.getInventory().get(1)).func_77942_o()) {
                NBTTagCompound compound = ((ItemStack)warp.getInventory().get(1)).func_77978_p();
                dimension = String.valueOf(compound.func_74762_e("DimensionID"));
                name = WorldUtil.getProviderForDimensionClient((int)compound.func_74762_e("DimensionID")).func_186058_p().func_186065_b();
                dest = compound.func_74762_e("X") + " " + compound.func_74762_e("Y") + " " + compound.func_74762_e("Z");
            }
            tooltip.add(LangUtils.translate((String)"gui.status.dimension.name") + ": " + dimension + " ");
            tooltip.add(LangUtils.translate((String)"gui.status.name.name") + ": " + name);
            tooltip.add(LangUtils.translate((String)"gui.status.destination.name") + ": " + dest);
        }
        if (block == MPBlocks.SHIELD_GENERATOR_DUMMY) {
            int chargeCooldown = nbt.func_74762_e("ShieldChargeCooldown");
            tooltip.add(LangUtils.translate((String)"gui.message.status.name") + ": " + nbt.func_74779_i("Status"));
            tooltip.add(LangUtils.translate((String)"gui.status.shield_damage.name") + ": " + nbt.func_74762_e("ShieldDamage"));
            tooltip.add(LangUtils.translate((String)"gui.status.shield_size.name") + ": " + nbt.func_74762_e("MaxShieldSize"));
            tooltip.add(LangUtils.translate((String)"gui.status.shield_capacity.name") + ": " + nbt.func_74762_e("ShieldCapacity") + "/" + nbt.func_74762_e("MaxShieldCapacity"));
            if (chargeCooldown > 0) {
                tooltip.add(LangUtils.translate((String)"gui.status.shield_charge_cooldown.name") + ": " + chargeCooldown / 20);
            }
        }
        if (block == MPBlocks.NWT_MIDDLE_DUMMY || block == MPBlocks.NWT_TOP_DUMMY) {
            if (!nbt.func_74767_n("HasRod") && !nbt.func_74767_n("CreateRod")) {
                tooltip.add(LangUtils.translate((String)"gui.status.no_waste_rod"));
            }
            if (nbt.func_74775_l("FluidTank").func_74762_e("Amount") > 0 && nbt.func_74775_l("FluidTank").func_74762_e("Amount") < 3000) {
                int amount = nbt.func_74775_l("FluidTank").func_74762_e("Amount") * 100 / 3000;
                tooltip.add(LangUtils.translate((String)"gui.status.has_waste"));
                tooltip.add(LangUtils.translate((String)"gui.status.waste_fluid_amount") + ": " + amount + "%");
            }
            if (nbt.func_74762_e("Time") > 0 && nbt.func_74775_l("FluidTank").func_74762_e("Amount") == 3000) {
                int cooldown = nbt.func_74762_e("RodCreateTime") * 100 / nbt.func_74762_e("Time");
                tooltip.add(LangUtils.translate((String)"gui.status.rod_processing"));
                tooltip.add(LangUtils.translate((String)"gui.status.create_rod_progress.name") + ": " + cooldown + "%");
            }
        }
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            process = nbt.func_74762_e("ActivatedTick") * 100 / 12000;
            int destruct = nbt.func_74762_e("FailedTick");
            if (destruct > 0) {
                destruct = 600 - destruct;
                tooltip.add(TextFormatting.DARK_RED + LangUtils.translate((String)"gui.status.destruct.name") + ": " + CommonUtils.ticksToElapsedTime((int)destruct));
            } else {
                tooltip.add(LangUtils.translate((String)"gui.message.status.name") + ": " + nbt.func_74779_i("Status"));
            }
            if (process > 0 && process < 100) {
                tooltip.add(LangUtils.translate((String)"gui.status.process.name") + ": " + process + "%");
            }
        }
        if (tile instanceof TileEntityDarkEnergyCore && (transform = nbt.func_74762_e("ProduceTime")) > 0) {
            tooltip.add(LangUtils.translate((String)"gui.status.transform_time.name") + ": " + CommonUtils.ticksToElapsedTime((int)transform));
        }
        if (tile instanceof TileEntityDarkEnergyGenerator) {
            int generateWatts = nbt.func_74762_e("GenerateWatts");
            int fuel = nbt.func_74762_e("DarkEnergyFuel");
            tooltip.add(LangUtils.translate((String)"gui.message.generating.name") + ": " + (generateWatts > 0 ? EnergyDisplayHelper.getEnergyDisplayS((float)generateWatts) + "/t" : LangUtils.translate((String)"gui.status.not_generating.name")));
            tooltip.add(LangUtils.translate((String)"gui.status.dark_energy_fuel.name") + ": " + (fuel > 0 ? String.valueOf(fuel * 100 / 1000) + "%" : TextFormatting.GOLD + LangUtils.translate((String)"gui.status.empty.name")));
        }
        if (tile instanceof TileEntitySpaceWarpPadFull) {
            TileEntitySpaceWarpPadFull warp = (TileEntitySpaceWarpPadFull)tile;
            String dimension = LangUtils.translate((String)"gui.status.unknown.name");
            String name = LangUtils.translate((String)"gui.status.unknown.name");
            String dest = LangUtils.translate((String)"gui.status.unknown.name");
            if (warp.hasWarpCore() && ((ItemStack)warp.getInventory().get(1)).func_77942_o()) {
                NBTTagCompound compound = ((ItemStack)warp.getInventory().get(1)).func_77978_p();
                dimension = String.valueOf(compound.func_74762_e("DimensionID"));
                name = WorldUtil.getProviderForDimensionClient((int)compound.func_74762_e("DimensionID")).func_186058_p().func_186065_b();
                dest = compound.func_74762_e("X") + " " + compound.func_74762_e("Y") + " " + compound.func_74762_e("Z");
            }
            tooltip.add(LangUtils.translate((String)"gui.status.dimension.name") + ": " + dimension + " ");
            tooltip.add(LangUtils.translate((String)"gui.status.name.name") + ": " + name);
            tooltip.add(LangUtils.translate((String)"gui.status.destination.name") + ": " + dest);
        }
        if (tile instanceof TileEntityEnergyStorageClusterMP || tile instanceof TileEntityNuclearWasteGenerator) {
            tooltip.add(TextFormatting.GREEN + LangUtils.translate((String)"gui.message.max_energy") + ": " + EnergyDisplayHelper.getEnergyDisplayS((float)nbt.func_74760_g("MaxEnergy")));
            tooltip.add(LangUtils.translate((String)"gui.max_output.desc") + ": " + EnergyDisplayHelper.getEnergyDisplayS((float)nbt.func_74760_g("MaxOutput")) + "/t");
            if (nbt.func_74764_b("Status")) {
                tooltip.add(LangUtils.translate((String)"gui.message.status.name") + ": " + nbt.func_74779_i("Status"));
            }
        }
        if (tile instanceof TileEntityBlackHoleStorage) {
            String owner = LangUtils.translate((String)"gui.status.unknown.name");
            String collectMode = nbt.func_74779_i("CollectMode").equals("item") ? LangUtils.translate((String)"gui.status.collect_item.name") : (nbt.func_74779_i("CollectMode").equals("item_and_xp") ? LangUtils.translate((String)"gui.status.collect_item_and_xp.name") : LangUtils.translate((String)"gui.status.collect_xp.name"));
            try {
                owner = accessor.getWorld().func_152378_a(UUID.fromString(nbt.func_74779_i("OwnerUUID"))).func_70005_c_();
            }
            catch (Exception e) {
                owner = "";
            }
            int xp = nbt.func_150297_b("XpFluid", 10) ? nbt.func_74775_l("XpFluid").func_74762_e("Amount") : 0;
            tooltip.add(LangUtils.translate((String)"gui.status.owner.name") + ": " + owner);
            tooltip.add(LangUtils.translate((String)"gui.status.mode.name") + ": " + collectMode);
            tooltip.add(LangUtils.translate((String)"desc.bhs_xp.name") + ": " + xp + "/" + 1000000);
        }
        if (tile instanceof TileEntityShieldGenerator) {
            int chargeCooldown = nbt.func_74762_e("ShieldChargeCooldown");
            tooltip.add(LangUtils.translate((String)"gui.message.status.name") + ": " + nbt.func_74779_i("Status"));
            tooltip.add(LangUtils.translate((String)"gui.status.shield_damage.name") + ": " + nbt.func_74762_e("ShieldDamage"));
            tooltip.add(LangUtils.translate((String)"gui.status.shield_size.name") + ": " + nbt.func_74762_e("MaxShieldSize"));
            tooltip.add(LangUtils.translate((String)"gui.status.shield_capacity.name") + ": " + nbt.func_74762_e("ShieldCapacity") + "/" + nbt.func_74762_e("MaxShieldCapacity"));
            if (chargeCooldown > 0) {
                tooltip.add(LangUtils.translate((String)"gui.status.shield_charge_cooldown.name") + ": " + chargeCooldown / 20);
            }
        }
        if (tile instanceof TileEntityNuclearWasteTank) {
            if (!nbt.func_74767_n("HasRod") && !nbt.func_74767_n("CreateRod")) {
                tooltip.add(LangUtils.translate((String)"gui.status.no_waste_rod"));
            }
            if (nbt.func_74775_l("FluidTank").func_74762_e("Amount") > 0 && nbt.func_74775_l("FluidTank").func_74762_e("Amount") < 3000) {
                int amount = nbt.func_74775_l("FluidTank").func_74762_e("Amount") * 100 / 3000;
                tooltip.add(LangUtils.translate((String)"gui.status.has_waste"));
                tooltip.add(LangUtils.translate((String)"gui.status.waste_fluid_amount") + ": " + amount + "%");
            }
            if (nbt.func_74762_e("Time") > 0 && nbt.func_74775_l("FluidTank").func_74762_e("Amount") == 3000) {
                int cooldown = nbt.func_74762_e("RodCreateTime") * 100 / nbt.func_74762_e("Time");
                tooltip.add(LangUtils.translate((String)"gui.status.rod_processing"));
                tooltip.add(LangUtils.translate((String)"gui.status.create_rod_progress.name") + ": " + cooldown + "%");
            }
        }
        return tooltip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile = accessor.getTileEntity();
        Block block = accessor.getBlock();
        if (ConfigManagerMP.moreplanets_other.enableDescriptionInWaila) {
            if (block instanceof IDescription) {
                IDescription desc = (IDescription)block;
                if (ClientUtils.isShiftKeyDown()) {
                    desc.getDescription().addDescription(itemStack, tooltip);
                } else {
                    tooltip.add(LangUtils.translate((String)"desc.shift_info.name"));
                }
            }
            if (block.getClass().equals(BlockDummy.class)) {
                TileEntityDummy dummy = (TileEntityDummy)tile;
                if (accessor.getWorld().func_180495_p(dummy.mainBlockPosition).func_177230_c() instanceof IDescription) {
                    IDescription desc = (IDescription)accessor.getWorld().func_180495_p(dummy.mainBlockPosition).func_177230_c();
                    if (ClientUtils.isShiftKeyDown()) {
                        desc.getDescription().addDescription(itemStack, tooltip);
                    } else {
                        tooltip.add(LangUtils.translate((String)"desc.shift_info.name"));
                    }
                }
            }
        }
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound nbt, World world, BlockPos pos) {
        TileBaseUniversalElectricalSource generator;
        if (tile instanceof TileEntityDummy) {
            TileEntityDummy dummy = (TileEntityDummy)tile;
            if (dummy.mainBlockPosition != null) {
                BlockPos dummyPos = dummy.mainBlockPosition;
                if (world.func_175625_s(dummyPos) instanceof TileEntityDarkEnergyReceiver) {
                    TileEntityDarkEnergyReceiver receiver = (TileEntityDarkEnergyReceiver)world.func_175625_s(dummy.mainBlockPosition);
                    nbt.func_74778_a("Status", receiver.getGuiStatusWaila());
                    return receiver.func_189515_b(nbt);
                }
                if (world.func_175625_s(dummyPos) instanceof TileEntityShieldGenerator) {
                    TileEntityShieldGenerator shield = (TileEntityShieldGenerator)world.func_175625_s(dummy.mainBlockPosition);
                    nbt.func_74778_a("Status", shield.getStatus());
                    return shield.func_189515_b(nbt);
                }
                if (world.func_175625_s(dummyPos) instanceof TileEntityNuclearWasteTank) {
                    TileEntityNuclearWasteTank tank = (TileEntityNuclearWasteTank)world.func_175625_s(dummy.mainBlockPosition);
                    return tank.func_189515_b(nbt);
                }
                if (world.func_175625_s(dummyPos) instanceof TileEntitySpaceWarpPadFull) {
                    TileEntitySpaceWarpPadFull pad = (TileEntitySpaceWarpPadFull)world.func_175625_s(dummy.mainBlockPosition);
                    return pad.func_189515_b(nbt);
                }
            }
        }
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            TileEntityDarkEnergyReceiver receiver = (TileEntityDarkEnergyReceiver)tile;
            nbt.func_74778_a("Status", receiver.getGuiStatusWaila());
            return receiver.func_189515_b(nbt);
        }
        if (tile instanceof TileEntityDarkEnergyGenerator) {
            generator = (TileEntityDarkEnergyGenerator)tile;
            nbt.func_74768_a("GenerateWatts", generator.generateWatts);
            return generator.func_189515_b(nbt);
        }
        if (tile instanceof TileEntityEnergyStorageClusterMP) {
            TileEntityEnergyStorageClusterMP energy = (TileEntityEnergyStorageClusterMP)tile;
            nbt.func_74776_a("MaxEnergy", energy.getMaxEnergyStoredGC());
            nbt.func_74776_a("MaxOutput", energy.storage.getMaxExtract());
            return energy.func_189515_b(nbt);
        }
        if (tile instanceof TileEntityShieldGenerator) {
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
            nbt.func_74778_a("Status", shield.getStatus());
            return shield.func_189515_b(nbt);
        }
        if (tile instanceof TileEntityNuclearWasteGenerator) {
            generator = (TileEntityNuclearWasteGenerator)tile;
            nbt.func_74778_a("Status", generator.getStatus());
            nbt.func_74776_a("MaxEnergy", generator.getMaxEnergyStoredGC());
            nbt.func_74776_a("MaxOutput", generator.storage.getMaxExtract());
            return generator.func_189515_b(nbt);
        }
        if (tile instanceof TileEntityNuclearWasteTank) {
            TileEntityNuclearWasteTank tank = (TileEntityNuclearWasteTank)tile;
            return tank.func_189515_b(nbt);
        }
        return tile.func_189515_b(nbt);
    }
}

