/*
 * Decompiled with CFR 0.152.
 */
package bq_rf.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_rf.client.gui.tasks.PanelTaskRate;
import bq_rf.core.BQRF;
import bq_rf.tasks.IRfTask;
import bq_rf.tasks.factory.FactoryTaskRfRate;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.Level;

public class TaskRfRate
implements ITask,
IRfTask {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    private final HashMap<UUID, Integer> userProgress = new HashMap();
    public int rate = 100000;
    public int duration = 200;
    public boolean delExcess = false;
    public final HashMap<UUID, Long> lastInput = new HashMap();

    public ResourceLocation getFactoryID() {
        return FactoryTaskRfRate.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_rf.task.rf_rate";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.userProgress.clear();
            this.completeUsers.clear();
        } else {
            this.userProgress.remove(uuid);
            this.completeUsers.remove(uuid);
        }
    }

    @Override
    public ItemStack submitItem(DBEntry<IQuest> quest, UUID owner, ItemStack stack) {
        if (stack.func_190926_b()) {
            return stack;
        }
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (cap == null) {
            return stack;
        }
        int progress = this.getUsersProgress(owner);
        int extracted = cap.extractEnergy(this.delExcess ? Integer.MAX_VALUE : this.rate, true);
        if (extracted >= this.rate) {
            progress = Math.min(progress + 1, this.duration);
            long tmp = System.currentTimeMillis() / 1000L;
            this.lastInput.put(owner, tmp);
        }
        this.setUserProgress(owner, progress);
        if (progress >= this.duration) {
            QuestCache qc;
            this.setComplete(owner);
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            EntityPlayerMP player = server == null ? null : server.func_184103_al().func_177451_a(owner);
            QuestCache questCache = qc = player == null ? null : (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            if (qc != null) {
                qc.markQuestDirty(quest.getID());
            }
        }
        return stack;
    }

    @Override
    public int submitEnergy(DBEntry<IQuest> quest, UUID owner, int amount) {
        if (this.isComplete(owner)) {
            return amount;
        }
        int progress = this.getUsersProgress(owner);
        if (amount >= this.rate) {
            progress = Math.min(progress + 1, this.duration);
            long tmp = System.currentTimeMillis() / 1000L;
            this.lastInput.put(owner, tmp);
        }
        this.setUserProgress(owner, progress);
        if (progress >= this.duration) {
            QuestCache qc;
            this.setComplete(owner);
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            EntityPlayerMP player = server == null ? null : server.func_184103_al().func_177451_a(owner);
            QuestCache questCache = qc = player == null ? null : (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            if (qc != null) {
                qc.markQuestDirty(quest.getID());
            }
        }
        return this.delExcess ? 0 : amount - this.rate;
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        int total = this.getUsersProgress(pInfo.UUID);
        if (total >= this.duration) {
            this.setComplete(pInfo.UUID);
        }
    }

    public long GetUserLast(UUID uuid) {
        Long l = this.lastInput.get(uuid);
        return l == null ? 0L : l;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("rf", this.rate);
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74757_a("voidExcess", this.delExcess);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.rate = nbt.func_74762_e("rf");
        this.duration = nbt.func_74762_e("duration");
        this.delExcess = nbt.func_74767_n("voidExcess");
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQRF.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                this.userProgress.put(uuid, pTag.func_74762_e("value"));
                continue;
            }
            catch (Exception e) {
                BQRF.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                Integer data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    pJson.func_74768_a("value", data.intValue());
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                pJson.func_74768_a("value", data.intValue());
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    private void setUserProgress(UUID uuid, Integer progress) {
        this.userProgress.put(uuid, progress);
    }

    public Integer getUsersProgress(UUID ... uuid) {
        int total = 0;
        for (UUID mem : uuid) {
            Integer n = this.userProgress.get(mem);
            total += n == null ? 0 : n;
        }
        return total;
    }

    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskRate(rect, this);
    }

    public GuiScreen getTaskEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }
}

