/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.storage.services;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.storage.dataaccess.IDataTranslator;
import io.github.nucleuspowered.storage.dataobjects.IDataObject;
import io.github.nucleuspowered.storage.dataobjects.keyed.DataKey;
import io.github.nucleuspowered.storage.dataobjects.keyed.IKeyedDataObject;
import io.github.nucleuspowered.storage.persistence.IStorageRepository;
import io.github.nucleuspowered.storage.queryobjects.IQueryObject;
import io.github.nucleuspowered.storage.services.IStorageService;
import io.github.nucleuspowered.storage.services.ServicesUtil;
import io.github.nucleuspowered.storage.util.KeyedObject;
import io.github.nucleuspowered.storage.util.ThrownBiConsumer;
import io.github.nucleuspowered.storage.util.ThrownFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.plugin.PluginContainer;

public abstract class AbstractKeyedService<Q extends IQueryObject<UUID, Q>, D extends IKeyedDataObject<D>>
implements IStorageService.Keyed.KeyedData<UUID, Q, D> {
    private final LoadingCache<UUID, ReentrantReadWriteLock> dataLocks = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<UUID, ReentrantReadWriteLock>(){

        public @NonNull ReentrantReadWriteLock load(@NonNull UUID key) {
            return new ReentrantReadWriteLock();
        }
    });
    private final Cache<UUID, D> cache = Caffeine.newBuilder().removalListener(this::onRemoval).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private final Supplier<IStorageRepository.Keyed<UUID, Q, ?>> storageRepositorySupplier;
    private final Supplier<D> createNew;
    private final ThrownBiConsumer<UUID, D, Exception> save;
    private final ThrownFunction<Q, Map<UUID, D>, Exception> getAll;
    private final ThrownFunction<Q, Optional<KeyedObject<UUID, D>>, Exception> getQuery;
    private final ThrownFunction<UUID, Optional<D>, Exception> get;
    private final PluginContainer pluginContainer;
    private final Consumer<D> upgrader;
    private final Consumer<D> versionSetter;

    public <O> AbstractKeyedService(Supplier<IDataTranslator<D, O>> dts, Supplier<IStorageRepository.Keyed<UUID, Q, O>> srs, Consumer<D> upgrader, Consumer<D> versionSetter, PluginContainer pluginContainer) {
        this(() -> (IKeyedDataObject)((IDataTranslator)dts.get()).createNew(), (key, udo) -> ((IStorageRepository.Keyed)srs.get()).save(key, ((IDataTranslator)dts.get()).toDataAccessObject(udo)), query -> (ImmutableMap)((IStorageRepository.Keyed)srs.get()).getAll(query).entrySet().stream().filter(x -> x.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, arg_0 -> AbstractKeyedService.lambda$null$3((Supplier)dts, arg_0))), uuid -> ((IStorageRepository.Keyed)srs.get()).get(uuid).map(((IDataTranslator)dts.get())::fromDataAccessObject), query -> ((IStorageRepository.Keyed)srs.get()).get(query).map(arg_0 -> AbstractKeyedService.lambda$null$6((Supplier)dts, arg_0)), srs::get, upgrader, versionSetter, pluginContainer);
    }

    private AbstractKeyedService(Supplier<D> createNew, ThrownBiConsumer<UUID, D, Exception> save, ThrownFunction<Q, Map<UUID, D>, Exception> getAll, ThrownFunction<UUID, Optional<D>, Exception> get, ThrownFunction<Q, Optional<KeyedObject<UUID, D>>, Exception> getQuery, Supplier<IStorageRepository.Keyed<UUID, Q, ?>> storageRepositorySupplier, Consumer<D> upgrader, Consumer<D> versionSetter, PluginContainer pluginContainer) {
        this.pluginContainer = pluginContainer;
        this.createNew = createNew;
        this.save = save;
        this.getAll = getAll;
        this.get = get;
        this.getQuery = getQuery;
        this.upgrader = upgrader;
        this.versionSetter = versionSetter;
        this.storageRepositorySupplier = storageRepositorySupplier;
    }

    @Override
    public D createNew() {
        IKeyedDataObject data = (IKeyedDataObject)this.createNew.get();
        this.versionSetter.accept(data);
        return (D)data;
    }

    @Override
    public CompletableFuture<Void> clearCache() {
        this.cache.invalidateAll();
        return ServicesUtil.run(() -> {
            this.storageRepositorySupplier.get().clearCache();
            return null;
        }, this.pluginContainer);
    }

    @Override
    public CompletableFuture<Void> clearCacheUnless(Set<UUID> keysToKeep) {
        Set keysToRemove = this.cache.asMap().keySet().stream().filter(x -> !keysToKeep.contains(x)).collect(Collectors.toSet());
        this.cache.invalidateAll(keysToRemove);
        return ServicesUtil.run(() -> {
            this.storageRepositorySupplier.get().clearCache(keysToRemove);
            return null;
        }, this.pluginContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Optional<D>> get(@NonNull UUID key) {
        ReentrantReadWriteLock.ReadLock lock = ((ReentrantReadWriteLock)this.dataLocks.get((Object)key)).readLock();
        try {
            lock.lock();
            IKeyedDataObject result = (IKeyedDataObject)this.cache.getIfPresent((Object)key);
            if (result != null) {
                CompletableFuture<Optional<D>> completableFuture = CompletableFuture.completedFuture(Optional.of(result));
                return completableFuture;
            }
        }
        finally {
            lock.unlock();
        }
        return ServicesUtil.run(() -> this.getFromRepo(key), this.pluginContainer);
    }

    @Override
    public CompletableFuture<D> getOrNew(@Nonnull UUID key) {
        return this.get((Q)key).thenApply(d -> d.orElseGet(() -> {
            IDataObject result = this.createNew();
            this.save(key, (D)result);
            return result;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<D> getOnThread(@NonNull UUID key) {
        ReentrantReadWriteLock.ReadLock lock = ((ReentrantReadWriteLock)this.dataLocks.get((Object)key)).readLock();
        try {
            lock.lock();
            IKeyedDataObject result = (IKeyedDataObject)this.cache.getIfPresent((Object)key);
            if (result != null) {
                Optional<IKeyedDataObject> optional = Optional.of(result);
                return optional;
            }
        }
        finally {
            lock.unlock();
        }
        try {
            return this.getFromRepo(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<D> getFromRepo(@NonNull UUID key) throws Exception {
        ReentrantReadWriteLock.WriteLock lock = ((ReentrantReadWriteLock)this.dataLocks.get((Object)key)).writeLock();
        try {
            lock.lock();
            Optional<D> r = this.get.apply(key);
            r.ifPresent(d -> {
                this.upgrader.accept(d);
                this.cache.put((Object)key, d);
            });
            Optional<D> optional = r;
            return optional;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public CompletableFuture<Optional<KeyedObject<UUID, D>>> get(@NonNull Q query) {
        return ServicesUtil.run(() -> {
            Optional<KeyedObject<UUID, D>> r = this.getQuery.apply(query);
            r.ifPresent(d -> {
                if (d.getValue().isPresent()) {
                    this.cache.put(d.getKey(), d.getValue().get());
                } else {
                    this.cache.invalidate(d.getKey());
                }
            });
            return r;
        }, this.pluginContainer);
    }

    @Override
    public CompletableFuture<Map<UUID, D>> getAll(@NonNull Q query) {
        return ServicesUtil.run(() -> {
            Map<UUID, D> res = this.getAll.apply(query);
            res.forEach((arg_0, arg_1) -> this.cache.put(arg_0, arg_1));
            return res;
        }, this.pluginContainer);
    }

    @Override
    public CompletableFuture<Boolean> exists(@NonNull UUID key) {
        return ServicesUtil.run(() -> this.storageRepositorySupplier.get().exists(key), this.pluginContainer);
    }

    @Override
    public CompletableFuture<Integer> count(@NonNull Q query) {
        return ServicesUtil.run(() -> this.storageRepositorySupplier.get().count((IQueryObject)query), this.pluginContainer);
    }

    @Override
    public <T2> CompletableFuture<Void> setAndSave(@NonNull UUID key, DataKey<T2, ? extends D> dataKey, T2 data) {
        return this.getOrNew(key).thenAccept(x -> {
            x.set(dataKey, data);
            try {
                this.saveOnThread(key, x);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public <T2> CompletableFuture<Void> removeAndSave(@NonNull UUID key, DataKey<T2, ? extends D> dataKey) {
        return this.getOrNew(key).handle((x, ex) -> {
            x.remove(dataKey);
            try {
                this.saveOnThread(key, x);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> save(@NonNull UUID key, @NonNull D value) {
        return ServicesUtil.run(() -> {
            this.saveOnThread(key, value);
            return null;
        }, this.pluginContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOnThread(@NonNull UUID key, @NonNull D value) throws Exception {
        ReentrantReadWriteLock reentrantReadWriteLock = (ReentrantReadWriteLock)this.dataLocks.get((Object)key);
        ReentrantReadWriteLock.WriteLock lock = reentrantReadWriteLock.writeLock();
        try {
            lock.lock();
            this.cache.put((Object)key, value);
            this.save.apply(key, value);
            value.markDirty(false);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public CompletableFuture<Void> delete(@NonNull UUID key) {
        return ServicesUtil.run(() -> {
            ReentrantReadWriteLock reentrantReadWriteLock = (ReentrantReadWriteLock)this.dataLocks.get((Object)key);
            ReentrantReadWriteLock.WriteLock lock = reentrantReadWriteLock.writeLock();
            try {
                lock.lock();
                this.storageRepositorySupplier.get().delete(key);
                IKeyedDataObject o = (IKeyedDataObject)this.cache.getIfPresent((Object)key);
                if (o != null) {
                    o.markDirty(false);
                }
                this.cache.invalidate((Object)key);
                Void void_ = null;
                return void_;
            }
            finally {
                lock.unlock();
            }
        }, this.pluginContainer);
    }

    @Override
    public CompletableFuture<Void> ensureSaved() {
        return ServicesUtil.run(() -> {
            for (Map.Entry objectToSave : new HashMap(this.cache.asMap()).entrySet()) {
                if (objectToSave.getValue() == null || !((IKeyedDataObject)objectToSave.getValue()).isDirty()) continue;
                this.save((UUID)objectToSave.getKey(), (D)((IKeyedDataObject)objectToSave.getValue()));
            }
            return null;
        }, this.pluginContainer);
    }

    void onRemoval(@Nullable UUID uuid, @Nullable D dataObject, @Nonnull RemovalCause removalCause) {
        if (removalCause.wasEvicted() && uuid != null && dataObject != null && dataObject.isDirty()) {
            this.save(uuid, dataObject);
        }
    }

    private static /* synthetic */ KeyedObject lambda$null$6(Supplier dts, KeyedObject x) {
        return x.mapValue(((IDataTranslator)dts.get())::fromDataAccessObject);
    }

    private static /* synthetic */ IKeyedDataObject lambda$null$3(Supplier dts, Map.Entry x) {
        return (IKeyedDataObject)((IDataTranslator)dts.get()).fromDataAccessObject(x.getValue());
    }
}

