/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.DefaultLogger;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.LoggerProxy;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Metadata;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Module;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleMetadata;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.SystemConfig;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.ModuleData;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.AbstractConfigAdapter;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.ConstructionPhase;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.LoadingStatus;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.ModulePhase;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.IncorrectAdapterTypeException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.MissingDependencyException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.NoModuleException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.QuickStartModuleDiscoveryException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.QuickStartModuleLoaderException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.UndisableableModuleException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.loaders.PhasedModuleEnabler;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public abstract class ModuleHolder<M extends Module, D extends M> {
    private final Class<M> baseClass;
    private final Class<D> disableableClass;
    private final boolean allowDisabling;
    private ConstructionPhase currentPhase = ConstructionPhase.INITALISED;
    private final Map<String, ModuleMetadata<? extends M>> discoveredModules = Maps.newLinkedHashMap();
    private final Map<String, ModuleMetadata<? extends D>> enabledDisableableModules = Maps.newHashMap();
    private final Map<String, M> enabledModules = Maps.newHashMap();
    private final Map<String, D> disableableModules = Maps.newHashMap();
    protected final SystemConfig<?, M> config;
    protected final LoggerProxy loggerProxy;
    private final PhasedModuleEnabler<M, D> enabler;
    private final boolean requireAnnotation;
    private final boolean processDoNotMerge;
    private final Function<M, String> headerProcessor;
    private final Function<Class<? extends M>, String> descriptionProcessor;
    private final String moduleSection;
    @Nullable
    private final String moduleSectionHeader;

    protected <R extends ModuleHolder<M, D>, B extends Builder<M, D, R, B>> ModuleHolder(B builder) throws QuickStartModuleDiscoveryException {
        try {
            this.baseClass = builder.moduleType;
            this.disableableClass = builder.disableableClass;
            this.config = new SystemConfig(builder.configurationLoader, builder.loggerProxy, builder.configurationOptionsTransformer, (List<AbstractConfigAdapter.Transformation>)ImmutableList.copyOf(builder.transformations));
            this.loggerProxy = builder.loggerProxy;
            this.enabler = builder.enabler;
            this.requireAnnotation = builder.requireAnnotation;
            this.processDoNotMerge = builder.doNotMerge;
            this.descriptionProcessor = builder.moduleDescriptionHandler == null ? m -> {
                ModuleData md = m.getAnnotation(ModuleData.class);
                if (md != null) {
                    return md.description();
                }
                return "";
            } : builder.moduleDescriptionHandler;
            this.headerProcessor = builder.moduleConfigurationHeader == null ? m -> "" : builder.moduleConfigurationHeader;
            this.moduleSection = builder.moduleConfigSection;
            this.moduleSectionHeader = builder.moduleDescription;
            this.allowDisabling = builder.allowDisabling;
        }
        catch (Exception e) {
            throw new QuickStartModuleDiscoveryException("Unable to start QuickStart", e);
        }
    }

    public final void startDiscover() throws QuickStartModuleDiscoveryException {
        try {
            Preconditions.checkState((this.currentPhase == ConstructionPhase.INITALISED ? 1 : 0) != 0);
            this.currentPhase = ConstructionPhase.DISCOVERING;
            Set<Class<M>> modules = this.discoverModules();
            HashMap discovered = Maps.newHashMap();
            for (Class<M> s : modules) {
                ModuleMetadata<M> ms;
                String id;
                if (s.isAnnotationPresent(ModuleData.class)) {
                    ModuleData md = s.getAnnotation(ModuleData.class);
                    id = md.id().toLowerCase();
                    ms = new ModuleMetadata<M>(s, this.disableableClass.isAssignableFrom(s), md);
                } else {
                    if (this.requireAnnotation) {
                        this.loggerProxy.warn(MessageFormat.format("The module class {0} does not have a ModuleData annotation associated with it. It is not being loaded as the module container requires the annotation to be present.", s.getName()));
                        continue;
                    }
                    id = s.getName().toLowerCase();
                    this.loggerProxy.warn(MessageFormat.format("The module {0} does not have a ModuleData annotation associated with it. We're just assuming an ID of {0}.", id));
                    ms = new ModuleMetadata<M>(s, this.disableableClass.isAssignableFrom(s), id, id, LoadingStatus.ENABLED, false);
                }
                if (discovered.containsKey(id)) {
                    throw new QuickStartModuleDiscoveryException("Duplicate module ID \"" + id + "\" was discovered - loading cannot continue.");
                }
                discovered.put(id, ms);
            }
            this.resolveDependencyOrder(discovered);
            List moduleMetadataList = this.discoveredModules.values().stream().filter(rModuleMetadata -> !rModuleMetadata.isMandatory()).collect(Collectors.toList());
            this.config.attachModulesConfig(moduleMetadataList, this.descriptionProcessor, this.moduleSection, this.moduleSectionHeader);
            this.config.saveAdapterDefaults(false);
            try {
                ((HashMap)this.config.getConfigAdapter().getNode()).forEach((k, v) -> {
                    try {
                        ModuleMetadata<M> ms = this.discoveredModules.get(k);
                        if (ms != null) {
                            ms.setStatus((LoadingStatus)((Object)v));
                        } else {
                            this.loggerProxy.warn(String.format("Ignoring module entry %s in the configuration file: module does not exist.", k));
                        }
                    }
                    catch (IllegalStateException ex) {
                        this.loggerProxy.warn("A mandatory module can't have its status changed by config. Falling back to FORCELOAD for " + k);
                    }
                });
            }
            catch (ObjectMappingException e) {
                this.loggerProxy.warn("Could not load modules config, falling back to defaults.");
                e.printStackTrace();
            }
            this.currentPhase = ConstructionPhase.DISCOVERED;
        }
        catch (QuickStartModuleDiscoveryException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new QuickStartModuleDiscoveryException("Unable to discover QuickStart modules", e);
        }
    }

    private void resolveDependencyOrder(Map<String, ModuleMetadata<? extends M>> modules) throws Exception {
        this.processDependencyStep(modules, x -> ((ModuleMetadata)x.getValue()).getDependencies().isEmpty() && ((ModuleMetadata)x.getValue()).getSoftDependencies().isEmpty());
        while (!modules.isEmpty()) {
            Set<String> addedModules = this.discoveredModules.keySet();
            this.processDependencyStep(modules, x -> addedModules.containsAll(((ModuleMetadata)x.getValue()).getDependencies()) && addedModules.containsAll(((ModuleMetadata)x.getValue()).getSoftDependencies()));
        }
    }

    private void processDependencyStep(Map<String, ModuleMetadata<? extends M>> modules, Predicate<Map.Entry<String, ModuleMetadata<? extends M>>> predicate) {
        List<Map.Entry> modulesToAdd = modules.entrySet().stream().filter(predicate).sorted((x, y) -> ((ModuleMetadata)x.getValue()).isMandatory() == ((ModuleMetadata)y.getValue()).isMandatory() ? ((String)x.getKey()).compareTo((String)y.getKey()) : Boolean.compare(((ModuleMetadata)x.getValue()).isMandatory(), ((ModuleMetadata)y.getValue()).isMandatory())).collect(Collectors.toList());
        if (modulesToAdd.isEmpty()) {
            throw new IllegalStateException("Some modules have circular dependencies: " + String.join((CharSequence)", ", modules.keySet()));
        }
        modulesToAdd.forEach(x -> {
            this.discoveredModules.put((String)x.getKey(), (ModuleMetadata<M>)x.getValue());
            modules.remove(x.getKey());
        });
    }

    private boolean dependenciesSatisfied(ModuleMetadata<? extends M> moduleMetadata, Set<String> enabledModules) {
        if (moduleMetadata.getDependencies().isEmpty()) {
            return true;
        }
        for (String m : moduleMetadata.getDependencies()) {
            if (enabledModules.contains(m) && this.dependenciesSatisfied(this.discoveredModules.get(m), enabledModules)) continue;
            return false;
        }
        return true;
    }

    protected abstract Set<Class<? extends M>> discoverModules() throws Exception;

    public ConstructionPhase getCurrentPhase() {
        return this.currentPhase;
    }

    public Set<String> getDisableableModules() {
        return this.getModules(ModuleStatusTristate.ENABLE);
    }

    public Set<String> getModules(ModuleStatusTristate enabledOnly) {
        Preconditions.checkNotNull((Object)((Object)enabledOnly));
        Preconditions.checkState((this.currentPhase != ConstructionPhase.INITALISED && this.currentPhase != ConstructionPhase.DISCOVERING ? 1 : 0) != 0);
        return this.discoveredModules.entrySet().stream().filter(enabledOnly.statusPredicate).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Map<String, LoadingStatus> getModulesWithLoadingState() {
        Preconditions.checkState((this.currentPhase != ConstructionPhase.INITALISED && this.currentPhase != ConstructionPhase.DISCOVERING ? 1 : 0) != 0);
        return ImmutableMap.copyOf(this.discoveredModules.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((ModuleMetadata)v.getValue()).getStatus())));
    }

    public boolean isModuleLoaded(String moduleId) throws NoModuleException {
        if (this.currentPhase != ConstructionPhase.ENABLING && this.currentPhase != ConstructionPhase.ENABLED) {
            return false;
        }
        ModuleMetadata<M> ms = this.discoveredModules.get(moduleId);
        if (ms == null) {
            throw new NoModuleException(moduleId);
        }
        return ms.getPhase() == ModulePhase.ENABLED;
    }

    public void disableModule(String moduleName) throws UndisableableModuleException, NoModuleException, QuickStartModuleLoaderException {
        if (this.currentPhase == ConstructionPhase.DISCOVERED) {
            ModuleMetadata<M> ms = this.discoveredModules.get(moduleName);
            if (ms == null) {
                throw new NoModuleException(moduleName);
            }
            if (ms.isMandatory() || ms.getStatus() == LoadingStatus.FORCELOAD) {
                throw new UndisableableModuleException(moduleName);
            }
            ms.setStatus(LoadingStatus.DISABLED);
        } else {
            Preconditions.checkState((this.currentPhase == ConstructionPhase.ENABLED ? 1 : 0) != 0);
            if (!this.allowDisabling) {
                throw new UndisableableModuleException(moduleName.toLowerCase(), "Cannot disable modules in this holder.");
            }
            ModuleMetadata<D> ms = this.enabledDisableableModules.get(moduleName);
            if (ms == null || !ms.isRuntimeAlterable()) {
                throw new UndisableableModuleException(moduleName.toLowerCase(), "Cannot disable this module at runtime!");
            }
            Preconditions.checkState((ms.getPhase() != ModulePhase.ERRORED ? 1 : 0) != 0, (Object)"Cannot disable this module as it errored!");
            Preconditions.checkState((ms.getPhase() == ModulePhase.ENABLED ? 1 : 0) != 0, (Object)"Cannot disable this module as it is not enabled!");
            Module module = (Module)this.disableableModules.get(moduleName);
            for (String phase : this.enabler.getDisablePhases()) {
                try {
                    this.enabler.startDisablePhase(phase, this, module);
                }
                catch (Exception e) {
                    this.detachConfig(ms.getName());
                    ms.setPhase(ModulePhase.ERRORED);
                    throw new QuickStartModuleLoaderException.Disabling(module.getClass(), "Could not disable the module " + ms.getId(), e);
                }
            }
            this.detachConfig(ms.getName());
            ms.setPhase(ModulePhase.DISABLED);
            this.enabledModules.remove(moduleName);
            this.enabledDisableableModules.remove(moduleName);
        }
    }

    protected final Class<M> getBaseClass() {
        return this.baseClass;
    }

    public <T extends M> Optional<T> getModule(String id) {
        return Optional.ofNullable((Module)this.enabledModules.get(id));
    }

    protected M getModule(ModuleMetadata<? extends M> spec) throws Exception {
        Module module = (Module)this.enabledModules.get(spec.getId());
        if (module == null) {
            return this.constructModule(spec);
        }
        return (M)module;
    }

    protected abstract M constructModule(ModuleMetadata<? extends M> var1) throws Exception;

    public void loadModules(boolean failOnOneError) throws QuickStartModuleLoaderException.Construction, QuickStartModuleLoaderException.Enabling {
        Preconditions.checkArgument((this.currentPhase == ConstructionPhase.DISCOVERED ? 1 : 0) != 0);
        this.currentPhase = ConstructionPhase.ENABLING;
        Set<String> disabledModules = this.getModules(ModuleStatusTristate.DISABLE);
        while (!disabledModules.isEmpty()) {
            List toDisable = this.getModules(ModuleStatusTristate.ENABLE).stream().map(this.discoveredModules::get).filter(x -> !Collections.disjoint(disabledModules, x.getDependencies())).collect(Collectors.toList());
            if (toDisable.isEmpty()) break;
            if (toDisable.stream().anyMatch(ModuleMetadata::isMandatory)) {
                String s = toDisable.stream().filter(ModuleMetadata::isMandatory).map(ModuleMetadata::getId).collect(Collectors.joining(", "));
                Class clazz = toDisable.stream().filter(ModuleMetadata::isMandatory).findFirst().get().getModuleClass();
                throw new QuickStartModuleLoaderException.Construction(clazz, "Tried to disable mandatory module", new IllegalStateException("Dependency failure, tried to disable a mandatory module (" + s + ")"));
            }
            toDisable.forEach(k -> {
                k.setStatus(LoadingStatus.DISABLED);
                disabledModules.add(k.getId());
            });
        }
        this.getModules(ModuleStatusTristate.DISABLE).forEach(k -> this.discoveredModules.get(k).setPhase(ModulePhase.DISABLED));
        for (String s : this.getModules(ModuleStatusTristate.ENABLE)) {
            ModuleMetadata<M> moduleMetadata = this.discoveredModules.get(s);
            try {
                this.enabledModules.put(s, this.constructModule(moduleMetadata));
                moduleMetadata.setPhase(ModulePhase.CONSTRUCTED);
            }
            catch (Exception construction) {
                construction.printStackTrace();
                moduleMetadata.setPhase(ModulePhase.ERRORED);
                this.loggerProxy.error("The module " + moduleMetadata.getModuleClass().getName() + " failed to construct.");
                if (!failOnOneError) continue;
                this.currentPhase = ConstructionPhase.ERRORED;
                throw new QuickStartModuleLoaderException.Construction(moduleMetadata.getModuleClass(), "The module " + moduleMetadata.getModuleClass().getName() + " failed to construct.", construction);
            }
        }
        if (this.enabledModules.isEmpty()) {
            this.currentPhase = ConstructionPhase.ERRORED;
            throw new QuickStartModuleLoaderException.Construction(null, "No modules were constructed.", null);
        }
        this.enabledModules.forEach((k, v) -> {
            if (this.disableableClass.isAssignableFrom(v.getClass())) {
                this.disableableModules.put((String)k, this.disableableClass.cast(v));
            }
        });
        int size = this.enabledModules.size();
        Iterator<Object> im = this.enabledModules.entrySet().iterator();
        while (im.hasNext()) {
            Map.Entry<String, M> entry = im.next();
            try {
                ((Module)entry.getValue()).checkExternalDependencies();
            }
            catch (MissingDependencyException ex) {
                this.discoveredModules.get(entry.getKey()).setStatus(LoadingStatus.DISABLED);
                this.discoveredModules.get(entry.getKey()).setPhase(ModulePhase.DISABLED);
                this.loggerProxy.warn("Module " + entry.getKey() + " can not be enabled because an external dependency could not be satisfied.");
                this.loggerProxy.warn("Message was: " + ex.getMessage());
                im.remove();
            }
        }
        while (size != this.enabledModules.size()) {
            size = this.enabledModules.size();
            im = this.enabledModules.entrySet().iterator();
            while (im.hasNext()) {
                Map.Entry entry = (Map.Entry)im.next();
                if (this.dependenciesSatisfied(this.discoveredModules.get(entry.getKey()), this.getModules(ModuleStatusTristate.ENABLE))) continue;
                im.remove();
                this.loggerProxy.warn("Module " + (String)entry.getKey() + " can not be enabled because an external dependency on a module it depends on could not be satisfied.");
                this.discoveredModules.get(entry.getKey()).setStatus(LoadingStatus.DISABLED);
                this.discoveredModules.get(entry.getKey()).setPhase(ModulePhase.DISABLED);
            }
        }
        for (String string : this.enabledModules.keySet()) {
            Module m = (Module)this.enabledModules.get(string);
            try {
                this.attachConfig(string, m);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!failOnOneError) continue;
                throw new QuickStartModuleLoaderException.Enabling(m.getClass(), "Failed to attach config.", e);
            }
        }
        Set<String> phases = this.enabler.getEnablePhases();
        for (String phase : phases) {
            this.loggerProxy.info(String.format("Starting phase: %s", phase));
            try {
                this.enabler.startEnablePrePhase(phase, this);
            }
            catch (Exception ex) {
                this.currentPhase = ConstructionPhase.ERRORED;
                throw new RuntimeException("Could not load modules, phase " + phase + " failed to load.", ex);
            }
            Iterator<String> is = this.enabledModules.keySet().iterator();
            while (is.hasNext()) {
                String i = is.next();
                ModuleMetadata<M> ms = this.discoveredModules.get(i);
                if (ms.getPhase() == ModulePhase.ERRORED) continue;
                try {
                    Module m = (Module)this.enabledModules.get(i);
                    this.enabler.startEnablePhase(phase, this, m);
                }
                catch (Exception construction) {
                    construction.printStackTrace();
                    is.remove();
                    ms.setPhase(ModulePhase.ERRORED);
                    this.loggerProxy.error("The module " + ms.getModuleClass().getName() + " failed to enable.");
                    if (!failOnOneError) continue;
                    this.currentPhase = ConstructionPhase.ERRORED;
                    throw new QuickStartModuleLoaderException.Enabling(ms.getModuleClass(), "The module " + ms.getModuleClass().getName() + " failed to enable.", construction);
                }
            }
        }
        if (this.enabledModules.isEmpty()) {
            this.currentPhase = ConstructionPhase.ERRORED;
            throw new QuickStartModuleLoaderException.Enabling(null, "No modules were enabled.", null);
        }
        this.enabledModules.forEach((k, v) -> this.discoveredModules.get(k).setPhase(ModulePhase.ENABLED));
        this.resetDisableableList();
        try {
            this.config.saveAdapterDefaults(this.processDoNotMerge);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.currentPhase = ConstructionPhase.ENABLED;
    }

    private void resetDisableableList() {
        this.enabledDisableableModules.clear();
        this.discoveredModules.values().stream().filter(x -> x.getPhase() == ModulePhase.ENABLED).filter(ModuleMetadata::isRuntimeAlterable).forEach(x -> this.enabledDisableableModules.put(x.getId(), (ModuleMetadata<D>)x));
    }

    public void runtimeEnable(String name) throws Exception {
        this.runtimeEnable((Set<String>)ImmutableSet.of((Object)name));
    }

    public void runtimeEnable(Set<String> name) throws Exception {
        Preconditions.checkState((this.currentPhase == ConstructionPhase.ENABLED ? 1 : 0) != 0);
        Set modulesToCheck = name.stream().map(String::toLowerCase).collect(Collectors.toSet());
        HashSet<ModuleMetadata<M>> containers = new HashSet<ModuleMetadata<M>>();
        for (String string : modulesToCheck) {
            Preconditions.checkState((!this.isModuleLoaded(string) ? 1 : 0) != 0, (Object)"Module is already loaded!");
            ModuleMetadata<M> ms = this.discoveredModules.get(string);
            Preconditions.checkState((boolean)this.disableableClass.isAssignableFrom(ms.getModuleClass()), (Object)("Module " + name + " cannot be enabled at runtime!"));
            containers.add(ms);
        }
        for (ModuleMetadata moduleMetadata : containers) {
            try {
                Module module = (Module)this.disableableModules.get(moduleMetadata.getId());
                if (module == null) {
                    module = this.constructModule(moduleMetadata);
                    this.disableableModules.put(moduleMetadata.getId(), module);
                }
                moduleMetadata.setPhase(ModulePhase.CONSTRUCTED);
                Set<String> phases = this.enabler.getEnablePhases();
                module.checkExternalDependencies();
                for (String phase : phases) {
                    this.enabler.startEnablePhase(phase, this, module);
                }
                moduleMetadata.setPhase(ModulePhase.ENABLED);
                this.enabledModules.put(moduleMetadata.getId(), module);
            }
            catch (Exception construction) {
                moduleMetadata.setPhase(ModulePhase.ERRORED);
                throw construction;
            }
        }
        this.resetDisableableList();
    }

    private void attachConfig(String name, M m) throws Exception {
        Optional<AbstractConfigAdapter<?>> a = m.getConfigAdapter();
        if (a.isPresent()) {
            this.config.attachConfigAdapter(name, a.get(), this.headerProcessor.apply(m));
        }
    }

    private void detachConfig(String name) {
        this.config.detachConfigAdapter(name);
    }

    public final <C extends AbstractConfigAdapter<?>> C getConfigAdapterForModule(String module, Class<C> adapterClass) throws NoModuleException, IncorrectAdapterTypeException {
        return this.config.getConfigAdapterForModule(module, adapterClass);
    }

    public final void saveSystemConfig() throws IOException {
        this.config.save();
    }

    public final void refreshSystemConfig() throws IOException {
        this.config.save(true);
    }

    public final void reloadSystemConfig() throws IOException {
        this.config.load();
    }

    public final Optional<String> getIdForModule(Module module) {
        return this.discoveredModules.entrySet().stream().filter(x -> ((ModuleMetadata)x.getValue()).getModuleClass() == module.getClass()).map(Map.Entry::getKey).findFirst();
    }

    public static enum ModuleStatusTristate {
        ENABLE(k -> ((ModuleMetadata)k.getValue()).getStatus() != LoadingStatus.DISABLED && ((ModuleMetadata)k.getValue()).getPhase() != ModulePhase.ERRORED && ((ModuleMetadata)k.getValue()).getPhase() != ModulePhase.DISABLED),
        DISABLE(k -> !ModuleStatusTristate.ENABLE.statusPredicate.test((Map.Entry<String, ? extends ModuleMetadata<? extends Module>>)k)),
        ALL(k -> true);

        private final Predicate<Map.Entry<String, ? extends ModuleMetadata<? extends Module>>> statusPredicate;

        private ModuleStatusTristate(Predicate<Map.Entry<String, ? extends ModuleMetadata<? extends Module>>> p) {
            this.statusPredicate = p;
        }
    }

    public static abstract class Builder<M extends Module, D extends M, R extends ModuleHolder<M, D>, T extends Builder<M, D, R, T>> {
        boolean allowDisabling = false;
        final Class<M> moduleType;
        final Class<D> disableableClass;
        PhasedModuleEnabler<M, D> enabler;
        ConfigurationLoader<? extends ConfigurationNode> configurationLoader;
        boolean requireAnnotation = false;
        LoggerProxy loggerProxy;
        final List<AbstractConfigAdapter.Transformation> transformations = new ArrayList<AbstractConfigAdapter.Transformation>();
        Function<ConfigurationOptions, ConfigurationOptions> configurationOptionsTransformer = x -> x;
        boolean doNotMerge = false;
        @Nullable
        Function<Class<? extends M>, String> moduleDescriptionHandler = null;
        @Nullable
        Function<M, String> moduleConfigurationHeader = null;
        String moduleConfigSection = "modules";
        @Nullable
        String moduleDescription = null;

        protected abstract T getThis();

        public Builder(Class<M> moduleType, Class<D> disableableClass) {
            this.moduleType = moduleType;
            this.disableableClass = disableableClass;
        }

        public T setConfigurationLoader(ConfigurationLoader<? extends ConfigurationNode> configurationLoader) {
            this.configurationLoader = configurationLoader;
            return this.getThis();
        }

        public T setConfigurationOptionsTransformer(Function<ConfigurationOptions, ConfigurationOptions> optionsTransformer) {
            Preconditions.checkNotNull(optionsTransformer);
            this.configurationOptionsTransformer = optionsTransformer;
            return this.getThis();
        }

        public T setLoggerProxy(LoggerProxy loggerProxy) {
            this.loggerProxy = loggerProxy;
            return this.getThis();
        }

        public T setModuleEnabler(PhasedModuleEnabler<M, D> enabler) {
            this.enabler = enabler;
            return this.getThis();
        }

        public T setRequireModuleDataAnnotation(boolean requireAnnotation) {
            this.requireAnnotation = requireAnnotation;
            return this.getThis();
        }

        public T setNoMergeIfPresent(boolean noMergeIfPresent) {
            this.doNotMerge = noMergeIfPresent;
            return this.getThis();
        }

        public T setModuleDescriptionHandler(@Nullable Function<Class<? extends M>, String> handler) {
            this.moduleDescriptionHandler = handler;
            return this.getThis();
        }

        public T setModuleConfigurationHeader(@Nullable Function<M, String> header) {
            this.moduleConfigurationHeader = header;
            return this.getThis();
        }

        public T setModuleConfigSectionName(String name) {
            Preconditions.checkNotNull((Object)name);
            this.moduleConfigSection = name;
            return this.getThis();
        }

        public T setModuleConfigSectionDescription(@Nullable String description) {
            this.moduleDescription = description;
            return this.getThis();
        }

        public T transformConfig(AbstractConfigAdapter.Transformation transformation) {
            this.transformations.add(transformation);
            return this.getThis();
        }

        public T setAllowDisable(boolean allowDisable) {
            this.allowDisabling = allowDisable;
            return this.getThis();
        }

        protected void checkBuild() {
            Preconditions.checkNotNull(this.configurationLoader);
            Preconditions.checkNotNull((Object)this.moduleConfigSection);
            Preconditions.checkNotNull(this.enabler);
            if (this.loggerProxy == null) {
                this.loggerProxy = DefaultLogger.INSTANCE;
            }
            Metadata.getStartupMessage().ifPresent(x -> this.loggerProxy.info((String)x));
        }

        public abstract R build() throws Exception;

        public final R build(boolean startDiscover) throws Exception {
            R build = this.build();
            if (startDiscover) {
                ((ModuleHolder)build).startDiscover();
            }
            return build;
        }
    }
}

