/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.util;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import javax.inject.Singleton;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandSource;

@Singleton
public class CommandNameCache {
    public static final CommandNameCache INSTANCE = new CommandNameCache();
    private final Map<CommandMapping, ImmutableSet<String>> mappingSetMap = new WeakHashMap<CommandMapping, ImmutableSet<String>>();

    private CommandNameCache() {
    }

    public Set<String> getFromCommandAndSource(String command, CommandSource source) {
        Optional oc = Sponge.getCommandManager().get(command, source);
        return oc.map(INSTANCE::getLowercase).orElseGet(HashSet::new);
    }

    public Set<String> getLowercase(CommandMapping mapping) {
        return new HashSet<String>((Collection)this.mappingSetMap.computeIfAbsent(mapping, x -> (ImmutableSet)x.getAllAliases().stream().map(String::toLowerCase).collect(ImmutableSet.toImmutableSet())));
    }
}

