/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.reloadable;

import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class ReloadableService
implements IReloadableService {
    private final Set<IReloadableService.Reloadable> earlyReloadables = new HashSet<IReloadableService.Reloadable>();
    private final Set<IReloadableService.Reloadable> reloadables = new HashSet<IReloadableService.Reloadable>();
    private final Set<IReloadableService.DataLocationReloadable> dataLocationReloadables = new HashSet<IReloadableService.DataLocationReloadable>();

    @Override
    public void registerEarlyReloadable(IReloadableService.Reloadable reloadable) {
        this.earlyReloadables.add(reloadable);
    }

    @Override
    public void registerReloadable(IReloadableService.Reloadable reloadable) {
        this.reloadables.add(reloadable);
    }

    @Override
    public void fireReloadables(INucleusServiceCollection serviceCollection) {
        for (IReloadableService.Reloadable reloadable : this.earlyReloadables) {
            reloadable.onReload(serviceCollection);
        }
        for (IReloadableService.Reloadable reloadable1 : this.reloadables) {
            reloadable1.onReload(serviceCollection);
        }
    }

    @Override
    public void registerDataFileReloadable(IReloadableService.DataLocationReloadable dataLocationReloadable) {
        this.dataLocationReloadables.add(dataLocationReloadable);
    }

    @Override
    public void fireDataFileReloadables(INucleusServiceCollection serviceCollection) {
        for (IReloadableService.DataLocationReloadable dataLocationReloadable : this.dataLocationReloadables) {
            dataLocationReloadable.onDataFileLocationChange(serviceCollection);
        }
    }
}

