/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.economy;

import io.github.nucleuspowered.nucleus.services.interfaces.IEconomyServiceProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;

@Singleton
public class EconomyServiceProvider
implements IEconomyServiceProvider {
    private final IMessageProviderService messageProviderService;

    @Inject
    public EconomyServiceProvider(IMessageProviderService messageProviderService) {
        this.messageProviderService = messageProviderService;
    }

    @Override
    public boolean serviceExists() {
        return Sponge.getServiceManager().provide(EconomyService.class).isPresent();
    }

    @Override
    public String getCurrencySymbol(double cost) {
        Optional oes = Sponge.getServiceManager().provide(EconomyService.class);
        return oes.map(economyService -> economyService.getDefaultCurrency().format(BigDecimal.valueOf(cost)).toPlain()).orElseGet(() -> String.valueOf(cost));
    }

    @Override
    public boolean hasBalance(Player src, double balance) {
        Optional oes = Sponge.getServiceManager().provide(EconomyService.class);
        if (oes.isPresent()) {
            EconomyService es = (EconomyService)oes.get();
            Optional ua = es.getOrCreateAccount(src.getUniqueId());
            return ua.isPresent() && ((UniqueAccount)ua.get()).getBalance(es.getDefaultCurrency()).doubleValue() >= balance;
        }
        return true;
    }

    @Override
    public boolean withdrawFromPlayer(Player src, double cost) {
        return this.withdrawFromPlayer(src, cost, true);
    }

    @Override
    public boolean withdrawFromPlayer(Player src, double cost, boolean message) {
        Optional oes = Sponge.getServiceManager().provide(EconomyService.class);
        if (oes.isPresent()) {
            EconomyService es = (EconomyService)oes.get();
            Optional a = es.getOrCreateAccount(src.getUniqueId());
            if (!a.isPresent()) {
                this.messageProviderService.sendMessageTo((CommandSource)src, "cost.noaccount");
                return false;
            }
            TransactionResult tr = ((UniqueAccount)a.get()).withdraw(es.getDefaultCurrency(), BigDecimal.valueOf(cost), CauseStackHelper.createCause(src));
            if (tr.getResult() == ResultType.ACCOUNT_NO_FUNDS) {
                if (message) {
                    this.messageProviderService.sendMessageTo((CommandSource)src, "cost.nofunds", this.getCurrencySymbol(cost));
                }
                return false;
            }
            if (tr.getResult() != ResultType.SUCCESS) {
                this.messageProviderService.sendMessageTo((CommandSource)src, "cost.error");
                return false;
            }
            if (message) {
                this.messageProviderService.sendMessageTo((CommandSource)src, "cost.complete", this.getCurrencySymbol(cost));
            }
        }
        return true;
    }

    @Override
    public boolean depositInPlayer(User src, double cost) {
        return this.depositInPlayer(src, cost, true);
    }

    @Override
    public boolean depositInPlayer(User src, double cost, boolean message) {
        Optional oes = Sponge.getServiceManager().provide(EconomyService.class);
        if (oes.isPresent()) {
            EconomyService es = (EconomyService)oes.get();
            Optional a = es.getOrCreateAccount(src.getUniqueId());
            if (!a.isPresent()) {
                src.getPlayer().ifPresent(x -> this.messageProviderService.sendMessageTo((CommandSource)x, "cost.noaccount"));
                return false;
            }
            TransactionResult tr = ((UniqueAccount)a.get()).deposit(es.getDefaultCurrency(), BigDecimal.valueOf(cost), CauseStackHelper.createCause(src));
            if (tr.getResult() != ResultType.SUCCESS && src.isOnline()) {
                src.getPlayer().ifPresent(x -> this.messageProviderService.sendMessageTo((CommandSource)x, "cost.error"));
                return false;
            }
            if (message && src.isOnline()) {
                src.getPlayer().ifPresent(x -> this.messageProviderService.sendMessageTo((CommandSource)x, "cost.refund", this.getCurrencySymbol(cost)));
            }
        }
        return true;
    }
}

