/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command.control;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.util.NoExceptionAutoClosable;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandInterceptor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusArgumentParseException;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusCommandException;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.config.CommandModifiersConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.control.CommandMetadata;
import io.github.nucleuspowered.nucleus.scaffold.command.control.UsageCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.impl.CommandContextImpl;
import io.github.nucleuspowered.nucleus.scaffold.command.modifier.CommandModifierFactory;
import io.github.nucleuspowered.nucleus.scaffold.command.modifier.ICommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.util.PrettyPrinter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandPermissionException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.args.parsing.InputTokenizer;
import org.spongepowered.api.command.args.parsing.SingleArg;
import org.spongepowered.api.command.source.CommandBlockSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class CommandControl
implements CommandCallable {
    private static final String CONTEXT_KEY = "nucleus_command";
    private static final InputTokenizer tokeniser = InputTokenizer.quotedStrings((boolean)false);
    private final INucleusServiceCollection serviceCollection;
    private final ImmutableList<String> basicPermission;
    private final CommandMetadata metadata;
    private final @Nullable ICommandExecutor<? extends CommandSource> executor;
    private final Class<? extends CommandSource> sourceType;
    private final UsageCommand usageCommand;
    private final boolean isAsync;
    private final SortedMap<String, CommandCallable> subcommands = new TreeMap<String, CommandCallable>();
    private final Map<String, CommandCallable> primarySubcommands = new HashMap<String, CommandCallable>();
    private final CommandElement element;
    private final String commandKey;
    private final Context context;
    private final List<String> aliases;
    private final boolean hasHelpCommand;
    private final ImmutableMap<CommandModifier, ICommandModifier> modifiers;
    private final Map<String, String> exemptionPermissions;
    private final CommandModifiersConfig commandModifiersConfig = new CommandModifiersConfig();
    private final String command;
    private boolean acceptingRegistration = true;

    public CommandControl(@Nullable ICommandExecutor<? extends CommandSource> executor, @Nullable CommandControl parent, CommandMetadata meta, INucleusServiceCollection serviceCollection) {
        CommandElement[] elements;
        this.executor = meta.getCommandAnnotation().hasExecutor() ? executor : null;
        this.metadata = meta;
        this.commandKey = meta.getCommandKey();
        this.context = new Context(CONTEXT_KEY, this.commandKey.replace(".", " "));
        this.basicPermission = ImmutableList.copyOf((Object[])meta.getCommandAnnotation().basePermission());
        this.serviceCollection = serviceCollection;
        this.hasHelpCommand = meta.getCommandAnnotation().hasHelpCommand();
        CommandElement[] commandElementArray = elements = executor == null ? new CommandElement[]{} : executor.parameters(serviceCollection);
        this.element = elements.length == 0 ? GenericArguments.none() : (elements.length == 1 ? elements[0] : GenericArguments.seq((CommandElement[])elements));
        this.aliases = ImmutableList.copyOf((Object[])meta.getAliases());
        Class c = CommandSource.class;
        if (this.executor != null) {
            for (Type type : this.executor.getClass().getGenericInterfaces()) {
                if (!type.getTypeName().startsWith(ICommandExecutor.class.getName()) || !(type instanceof ParameterizedType)) continue;
                c = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                break;
            }
        }
        this.sourceType = c;
        this.usageCommand = new UsageCommand(this);
        this.command = parent != null ? parent.command + " " + meta.getAliases()[0] : meta.getAliases()[0];
        this.isAsync = meta.getCommandAnnotation().async();
        this.modifiers = CommandControl.validateModifiers(this, serviceCollection.logger(), meta.getCommandAnnotation());
        this.exemptionPermissions = this.modifiers.keySet().stream().collect(Collectors.toMap(CommandModifier::value, CommandModifier::exemptPermission));
    }

    public void attach(String alias, CommandControl commandControl) {
        Preconditions.checkState((boolean)this.acceptingRegistration, (Object)"Registration is complete.");
        this.subcommands.putIfAbsent(alias, commandControl);
        this.primarySubcommands.putIfAbsent(commandControl.getCommandKey().substring(commandControl.getCommandKey().lastIndexOf(".") + 1), commandControl);
    }

    public void completeRegistration(INucleusServiceCollection serviceCollection) {
        Preconditions.checkState((boolean)this.acceptingRegistration, (Object)"Registration is complete.");
        this.acceptingRegistration = false;
        if (this.executor instanceof IReloadableService.Reloadable) {
            IReloadableService.Reloadable reloadable = (IReloadableService.Reloadable)((Object)this.executor);
            serviceCollection.reloadableService().registerReloadable(reloadable);
            reloadable.onReload(serviceCollection);
        }
    }

    public @NonNull CommandResult process(@NonNull CommandSource source, @NonNull String arguments) throws CommandException {
        CommandArgs args = new CommandArgs(arguments, tokeniser.tokenize(arguments, false));
        ICommandResult commandResult = this.process(Sponge.getCauseStackManager().getCurrentCause(), source, arguments, args);
        return commandResult.isSuccess() ? CommandResult.success() : CommandResult.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommandResult process(@Nonnull Cause cause, @NonNull CommandSource source, @NonNull String arguments, CommandArgs args) throws CommandException {
        ArrayList thrown = Lists.newArrayList();
        CommandContext context = new CommandContext();
        CommandArgs.Snapshot state = args.getSnapshot();
        if (args.hasNext()) {
            String next = args.peek();
            CommandCallable callable = (CommandCallable)this.subcommands.get(next);
            if (callable != null) {
                try {
                    if (callable instanceof CommandControl) {
                        args.next();
                        ICommandResult iCommandResult = ((CommandControl)callable).process(cause, source, CommandControl.getArgumentStringFromCurrentArgumentState(args), args);
                        return iCommandResult;
                    }
                    int successCount = callable.process(source, CommandControl.getArgumentStringFromCurrentArgumentState(args)).getSuccessCount().orElse(0);
                    ICommandResult iCommandResult = successCount > 0 ? ICommandResult.success() : ICommandResult.fail();
                    return iCommandResult;
                }
                catch (ArgumentParseException e) {
                    if (callable instanceof CommandControl) {
                        CommandControl control = (CommandControl)callable;
                        thrown.add(Tuple.of((Object)(this.command + " " + next), (Object)((Object)NucleusArgumentParseException.from(this.serviceCollection.messageProvider(), e, control.getUsage(source), control.getSubcommandTexts()))));
                    } else {
                        thrown.add(Tuple.of((Object)(this.command + " " + next), (Object)((Object)NucleusArgumentParseException.from(this.serviceCollection.messageProvider(), e, callable.getUsage(source), Text.of()))));
                    }
                }
                finally {
                    args.applySnapshot(state);
                }
            }
            if (this.hasHelpCommand && next.toLowerCase().equals("help") || next.toLowerCase().equals("?")) {
                this.usageCommand.process(CommandControl.getContextFrom(source, cause, context, (Map<CommandModifier, ICommandModifier>)ImmutableMap.of(), this, this.serviceCollection), this.command, null);
                return ICommandResult.success();
            }
        }
        this.checkSourceType(source);
        Map<CommandModifier, ICommandModifier> modifiers = this.selectAppropriateModifiers(source);
        ICommandContext.Mutable<? extends CommandSource> contextSource = CommandControl.getContextFrom(source, cause, context, modifiers, this, this.serviceCollection);
        Throwable throwable = null;
        try (NoExceptionAutoClosable closable = this.serviceCollection.permissionService().setContextTemporarily((Subject)source, this.context);){
            Object object;
            Optional<ICommandResult> result;
            if (!this.testPermission(source)) {
                throw new CommandPermissionException();
            }
            for (Map.Entry<CommandModifier, ICommandModifier> x : modifiers.entrySet()) {
                Optional<Text> req = x.getValue().testRequirement(contextSource, this, this.serviceCollection, x.getKey());
                if (!req.isPresent()) continue;
                throw new CommandException(req.get());
            }
            if (this.executor == null) {
                if (thrown.isEmpty()) {
                    this.usageCommand.process(contextSource, this.command, args.nextIfPresent().map(String::toLowerCase).orElse(null));
                    ICommandResult iCommandResult = contextSource.successResult();
                    return iCommandResult;
                }
                throw new NucleusCommandException(thrown, false, this.serviceCollection.messageProvider());
            }
            try {
                try {
                    this.element.parse(source, args, context);
                    if (args.hasNext()) {
                        thrown.add(Tuple.of((Object)this.command, (Object)((Object)new NucleusArgumentParseException(this.serviceCollection.messageProvider(), Text.of((Object[])new Object[]{TextColors.RED, "Too many arguments"}), args.getRaw(), args.getRawPosition(), Text.of((Object[])new Object[]{this.getUsage(source)}), this.getSubcommandTexts(source), true))));
                        throw new NucleusCommandException(thrown, true, this.serviceCollection.messageProvider());
                    }
                }
                catch (NucleusCommandException nce) {
                    throw nce;
                }
                catch (ArgumentParseException ape) {
                    thrown.add(Tuple.of((Object)this.command, (Object)((Object)NucleusArgumentParseException.from(this.serviceCollection.messageProvider(), ape, Text.of((Object[])new Object[]{this.getUsage(source)}), this.getSubcommandTexts(source)))));
                    throw new NucleusCommandException(thrown, true, this.serviceCollection.messageProvider());
                }
                catch (Throwable throwable2) {
                    String m = throwable2.getMessage() == null ? "null" : throwable2.getMessage();
                    thrown.add(Tuple.of((Object)this.command, (Object)((Object)new CommandException(this.serviceCollection.messageProvider().getMessageFor(source, "command.exception.unexpected", m), throwable2))));
                    throwable2.printStackTrace();
                    throw new NucleusCommandException(thrown, true, this.serviceCollection.messageProvider());
                }
                result = this.executor.preExecute(contextSource);
                if (result.isPresent()) {
                    this.onResult(source, contextSource, result.get());
                    object = result.get();
                    return object;
                }
            }
            catch (Exception ex) {
                try {
                    this.runFailActions(contextSource);
                    throw ex;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            for (Map.Entry<CommandModifier, ICommandModifier> modifier : contextSource.modifiers().entrySet()) {
                if (!modifier.getKey().onExecute() || !(result = modifier.getValue().preExecute(contextSource, this, this.serviceCollection, modifier.getKey())).isPresent()) continue;
                this.onResult(source, contextSource, result.get());
                ICommandResult iCommandResult = result.get();
                return iCommandResult;
            }
            object = this.execute(source, contextSource);
            return object;
        }
    }

    public Text getSubcommandTexts() {
        return this.getSubcommandTexts(null);
    }

    public Text getSubcommandTexts(@Nullable CommandSource source) {
        return Text.joinWith((Text)Text.of((String)", "), (Iterable)this.primarySubcommands.entrySet().stream().filter(x -> source == null || ((CommandCallable)x.getValue()).testPermission(source)).map(x -> Text.of((String)((String)x.getKey()))).collect(Collectors.toList()));
    }

    private <T extends CommandSource> void runFailActions(ICommandContext<T> contextSource) {
        contextSource.failActions().forEach(x -> x.accept(contextSource));
    }

    public void startExecute(@NonNull ICommandContext<? extends CommandSource> contextSource) {
        CommandSource source;
        try {
            source = contextSource.getCommandSource();
        }
        catch (CommandException ex) {
            this.serviceCollection.logger().warn("Could not get command source, cancelling command execution (did the player disconnect?)", (Throwable)ex);
            return;
        }
        try {
            this.execute(source, contextSource);
        }
        catch (CommandException ex) {
            Text message = ex.getText() == null ? Text.of((Object[])new Object[]{TextColors.RED, "Unknown error!"}) : ex.getText();
            this.onFail(contextSource, message);
            this.serviceCollection.logger().warn("Error executing command {}", (Object)this.command, (Object)ex);
        }
    }

    private ICommandResult execute(CommandSource source, @NonNull ICommandContext<? extends CommandSource> context) throws CommandException {
        ICommandResult result;
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0, (Object)"executor");
        for (ICommandInterceptor commandInterceptor : context.getServiceCollection().commandMetadataService().interceptors()) {
            commandInterceptor.onPreCommand(this.executor.getClass(), this, context);
        }
        if (this.isAsync) {
            this.runAsync(source, context);
            result = context.successResult();
        } else {
            result = this.executor.execute(context);
            this.onResult(source, context, result);
            for (ICommandInterceptor commandInterceptor : context.getServiceCollection().commandMetadataService().interceptors()) {
                commandInterceptor.onPostCommand(this.executor.getClass(), this, context, result);
            }
        }
        return result;
    }

    private void runAsync(CommandSource source, ICommandContext<? extends CommandSource> context) {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0, (Object)"executor");
        Task.builder().execute(task -> {
            ICommandResult result;
            try {
                result = this.executor.execute(context);
            }
            catch (CommandException e) {
                result = context.errorResultLiteral(e.getText());
            }
            ICommandResult fResult = result;
            Task.builder().execute(t -> {
                try {
                    this.onResult(source, context, fResult);
                    for (ICommandInterceptor commandInterceptor : context.getServiceCollection().commandMetadataService().interceptors()) {
                        commandInterceptor.onPostCommand(this.executor.getClass(), this, context, fResult);
                    }
                }
                catch (CommandException e) {
                    e.printStackTrace();
                }
            }).submit((Object)this.serviceCollection.pluginContainer());
        }).async().submit((Object)this.serviceCollection.pluginContainer());
    }

    private void onResult(CommandSource source, ICommandContext<? extends CommandSource> contextSource, ICommandResult result) throws CommandException {
        if (result.isSuccess()) {
            this.onSuccess(contextSource);
        } else if (!result.isWillContinue()) {
            this.onFail(contextSource, result.getErrorMessage(source).orElse(null));
        }
    }

    private void onSuccess(ICommandContext<? extends CommandSource> source) throws CommandException {
        for (Map.Entry<CommandModifier, ICommandModifier> x : source.modifiers().entrySet()) {
            if (!x.getKey().onCompletion()) continue;
            x.getValue().onCompletion(source, this, this.serviceCollection, x.getKey());
        }
    }

    public void onFail(ICommandContext<? extends CommandSource> source, @Nullable Text errorMessage) {
        this.runFailActions(source);
        if (errorMessage != null) {
            source.getCommandSourceUnchecked().sendMessage(errorMessage);
        }
    }

    private Map<CommandModifier, ICommandModifier> selectAppropriateModifiers(CommandSource source) throws CommandException {
        return this.modifiers.entrySet().stream().filter(x -> ((CommandModifier)x.getKey()).target().isInstance(source)).filter(x -> {
            try {
                return ((ICommandModifier)x.getValue()).canExecuteModifier(this.serviceCollection, source);
            }
            catch (CommandException e) {
                e.printStackTrace();
                return false;
            }
        }).filter(x -> ((CommandModifier)x.getKey()).exemptPermission().isEmpty() || !this.serviceCollection.permissionService().hasPermission((Subject)source, ((CommandModifier)x.getKey()).exemptPermission())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public @NonNull List<String> getSuggestions(@NonNull CommandSource source, @NonNull String arguments, @Nullable Location<World> targetPosition) throws CommandException {
        CommandCallable callable;
        ArrayList singleArgs = Lists.newArrayList((Iterable)tokeniser.tokenize(arguments, false));
        if (arguments.isEmpty() || arguments.endsWith(" ")) {
            singleArgs.add(new SingleArg("", arguments.length() - 1, arguments.length() - 1));
        }
        CommandArgs args = new CommandArgs(arguments, (List)singleArgs);
        ArrayList options = Lists.newArrayList();
        CommandContext context = new CommandContext();
        context.putArg("tab-complete-50456", (Object)true);
        if (args.size() == 1) {
            this.subcommands.keySet().stream().filter(x -> x.toLowerCase().startsWith(args.get(0).toLowerCase())).forEach(options::add);
        } else if (args.size() > 1 && (callable = (CommandCallable)this.subcommands.get(args.peek().toLowerCase())) != null) {
            CommandArgs.Snapshot state = args.getSnapshot();
            String[] splitArgs = arguments.split(" ", 2);
            String targetArg = splitArgs.length == 1 ? "" : splitArgs[1];
            options.addAll(callable.getSuggestions(source, targetArg, targetPosition));
            args.applySnapshot(state);
        }
        options.addAll(this.element.complete(source, args, context));
        return options.stream().distinct().collect(Collectors.toList());
    }

    public ImmutableList<String> getPermission() {
        return this.basicPermission;
    }

    public boolean testPermission(@NonNull CommandSource source) {
        return this.basicPermission.stream().allMatch(x -> this.serviceCollection.permissionService().hasPermission((Subject)source, (String)x));
    }

    public @NonNull Optional<Text> getShortDescription(@NonNull CommandSource source) {
        return Optional.of(this.serviceCollection.messageProvider().getMessageFor(source, this.metadata.getCommandAnnotation().commandDescriptionKey() + ".desc"));
    }

    public Optional<Text> getExtendedDescription(@NonNull CommandSource source) {
        try {
            return Optional.ofNullable(this.serviceCollection.messageProvider().getMessageFor(source, this.metadata.getCommandAnnotation().commandDescriptionKey() + ".extended"));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public @NonNull Optional<Text> getHelp(@NonNull CommandSource source) {
        Optional<Text> extended = this.getExtendedDescription(source);
        if (extended.isPresent()) {
            return this.getShortDescription(source).map(text -> Optional.of(Text.of((Object[])new Object[]{text, Text.NEW_LINE, Util.SPACE, Text.NEW_LINE, extended.get()}))).orElse(extended);
        }
        return this.getShortDescription(source);
    }

    public @NonNull Text getUsage(@NonNull CommandSource source) {
        Text.Builder builder = this.getUsageText(source).toBuilder();
        Collection<Text> ct = this.getSubcommandText(source);
        if (!ct.isEmpty()) {
            builder.append(new Text[]{Text.NEW_LINE}).append(new Text[]{Text.joinWith((Text)Text.NEW_LINE, ct)});
        }
        return builder.build();
    }

    public Collection<Text> getSubcommandText(@NonNull CommandSource source) {
        ArrayList<Text> texts = new ArrayList<Text>();
        if (!this.primarySubcommands.isEmpty()) {
            this.primarySubcommands.values().stream().filter(commandControl -> commandControl instanceof CommandControl && commandControl.testPermission(source)).map(commandControl -> ((CommandControl)commandControl).getUsageText(source)).forEach(texts::add);
        }
        return texts;
    }

    public Text getUsageText(@NonNull CommandSource source) {
        return this.serviceCollection.messageProvider().getMessageFor(source, "command.usage.bl", new Text[]{Text.of((String)this.command), this.element.getUsage(source)});
    }

    private @Nullable CommandCallable getSubcommand(String subcommand, @Nullable CommandSource source) {
        CommandCallable control = (CommandCallable)this.subcommands.get(subcommand.toLowerCase());
        if (source == null || control.testPermission(source)) {
            return control;
        }
        return null;
    }

    public CommandModifiersConfig getCommandModifiersConfig() {
        return this.commandModifiersConfig;
    }

    Collection<CommandCallable> getSubcommands() {
        return this.subcommands.values();
    }

    public String getCommand() {
        return this.command;
    }

    public String getModifierKey() {
        return this.metadata.getMetadataKey();
    }

    public boolean isModifierKeyRedirected() {
        return this.metadata.isModifierKeyRedirect();
    }

    Class<? extends CommandSource> getSourceType() {
        return this.sourceType;
    }

    public CommandMetadata getMetadata() {
        return this.metadata;
    }

    boolean hasExecutor() {
        return this.executor != null;
    }

    private CommandException getExceptionFromKey(CommandSource source, String key, String ... subs) {
        return new CommandException(this.serviceCollection.messageProvider().getMessageFor(source, key, subs));
    }

    private void checkSourceType(CommandSource source) throws CommandException {
        if (!this.sourceType.isInstance(source)) {
            if (this.sourceType.equals(Player.class) && !(source instanceof Player)) {
                throw this.getExceptionFromKey(source, "command.playeronly", new String[0]);
            }
            if (this.sourceType.equals(ConsoleSource.class) && !(source instanceof ConsoleSource)) {
                throw this.getExceptionFromKey(source, "command.consoleonly", new String[0]);
            }
            if (this.sourceType.equals(CommandBlockSource.class) && !(source instanceof CommandBlockSource)) {
                throw this.getExceptionFromKey(source, "command.commandblockonly", new String[0]);
            }
            throw this.getExceptionFromKey(source, "command.unknownsource", new String[0]);
        }
    }

    public String getCommandKey() {
        return this.commandKey;
    }

    public Context getContext() {
        return this.context;
    }

    public Map<CommandModifier, ICommandModifier> getCommandModifiers() {
        return this.modifiers;
    }

    public int getCooldown() {
        return this.commandModifiersConfig.getCooldown();
    }

    public int getCooldown(Subject subject) {
        String exemptionPermission = this.exemptionPermissions.get("nucleus:has_cooldown");
        if (exemptionPermission != null && this.serviceCollection.permissionService().hasPermission(subject, exemptionPermission)) {
            return 0;
        }
        return this.serviceCollection.permissionService().getIntOptionFromSubject(subject, String.format("nucleus.%s.cooldown", this.command.replace(" ", "."))).orElseGet(this::getCooldown);
    }

    public int getWarmup() {
        return this.commandModifiersConfig.getWarmup();
    }

    public int getWarmup(Subject subject) {
        String exemptionPermission = this.exemptionPermissions.get("nucleus:has_warmup");
        if (exemptionPermission != null && this.serviceCollection.permissionService().hasPermission(subject, exemptionPermission)) {
            return 0;
        }
        return this.serviceCollection.permissionService().getIntOptionFromSubject(subject, String.format("nucleus.%s.warmup", this.command.replace(" ", "."))).orElseGet(this::getWarmup);
    }

    public double getCost() {
        return this.commandModifiersConfig.getCost();
    }

    public double getCost(Subject subject) {
        String exemptionPermission = this.exemptionPermissions.get("nucleus:has_cost");
        if (exemptionPermission != null && this.serviceCollection.permissionService().hasPermission(subject, exemptionPermission)) {
            return 0.0;
        }
        return this.serviceCollection.permissionService().getDoubleOptionFromSubject(subject, String.format("nucleus.%s.cost", this.command.replace(" ", "."))).orElseGet(this::getCost);
    }

    Collection<String> getAliases() {
        return ImmutableList.copyOf(this.aliases);
    }

    private static ImmutableMap<CommandModifier, ICommandModifier> validateModifiers(CommandControl control, Logger logger, Command command) {
        if (command.modifiers().length == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder modifiers = new ImmutableMap.Builder();
        for (CommandModifier modifier : command.modifiers()) {
            try {
                ICommandModifier commandModifier = Sponge.getRegistry().getType(CommandModifierFactory.class, modifier.value()).map(x -> (ICommandModifier)x.apply(control)).orElseThrow(() -> new IllegalArgumentException("Could not get registry entry for \"" + modifier.value() + "\""));
                commandModifier.validate(modifier);
                modifiers.put((Object)modifier, (Object)commandModifier);
            }
            catch (IllegalArgumentException ex) {
                PrettyPrinter printer = new PrettyPrinter();
                printer.add("Could not add modifier to command!").centre().hr();
                printer.add("Command Description Key: ");
                printer.add("  " + command.commandDescriptionKey());
                printer.add("Modifier: ");
                printer.add("  " + modifier.value());
                printer.hr();
                printer.add("Message:");
                printer.add(ex.getMessage());
                printer.hr();
                printer.add("Stack trace:");
                printer.add(ex);
                printer.log(logger, Level.ERROR);
            }
        }
        return modifiers.build();
    }

    private static ICommandContext.Mutable<? extends CommandSource> getContextFrom(CommandSource source, Cause cause, CommandContext context, Map<CommandModifier, ICommandModifier> modifiers, CommandControl control, INucleusServiceCollection serviceCollection) throws CommandException {
        if (source instanceof Player) {
            return new CommandContextImpl.PlayerSource(cause, context, serviceCollection, () -> (Player)Sponge.getServer().getPlayer(((Player)source).getUniqueId()).orElseThrow(() -> new CommandException((Text)Text.of((String)"Player is no longer available."))), (Player)source, control, modifiers);
        }
        if (source instanceof ConsoleSource) {
            return new CommandContextImpl.Console(cause, context, serviceCollection, Sponge.getServer().getConsole(), control, modifiers, serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class).isConsoleOverride());
        }
        return new CommandContextImpl.Any(cause, context, serviceCollection, source, control, modifiers);
    }

    private static String getArgumentStringFromCurrentArgumentState(CommandArgs args) {
        return args.getRaw().substring(args.getRawPosition()).trim();
    }
}

