/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.services;

import com.flowpowered.math.GenericMath;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.modules.world.WorldKeys;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfig;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IWorldDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.spongepowered.api.event.world.ChunkPreGenerationEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.ChunkPreGenerate;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class WorldHelper
implements IReloadableService.Reloadable,
ServiceBase {
    private final INucleusServiceCollection serviceCollection;
    private boolean notify = false;
    private boolean display = true;
    private long timeToNotify = 20000L;
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("0.##");
    private static final String TIME_FORMAT = "s's 'S'ms'";
    private final Map<UUID, ChunkPreGenerate> pregen = Maps.newHashMap();

    @Inject
    public WorldHelper(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
    }

    public boolean isPregenRunningForWorld(UUID uuid) {
        this.cleanup();
        return this.pregen.containsKey(uuid);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        WorldConfig config = serviceCollection.moduleDataProvider().getModuleConfig(WorldConfig.class);
        this.notify = config.isDisplayAfterEachGen();
        this.display = config.isDisplayWarningGeneration();
        this.timeToNotify = config.getNotificationInterval() * 1000L;
    }

    public boolean startPregenningForWorld(World world, int aggressiveLevel, long saveTime, @Nullable Integer tickPercent, @Nullable Integer tickFrequency, boolean onRestart) {
        this.cleanup();
        if (!this.isPregenRunningForWorld(world.getUniqueId())) {
            WorldProperties wp = world.getProperties();
            ChunkPreGenerate.Builder wbcp = world.newChunkPreGenerate(wp.getWorldBorderCenter(), wp.getWorldBorderDiameter()).owner((Object)this.serviceCollection.pluginContainer()).addListener((Consumer)new Listener(this.serviceCollection, aggressiveLevel, saveTime, this.notify, this.display, this.timeToNotify));
            if (tickPercent != null) {
                wbcp.tickPercentLimit(Math.max(0.0f, Math.min((float)tickPercent.intValue() / 100.0f, 1.0f)));
            } else if (aggressiveLevel == 2) {
                wbcp.tickPercentLimit(0.95f);
            } else if (aggressiveLevel == 1) {
                wbcp.tickPercentLimit(0.9f);
            } else {
                wbcp.tickPercentLimit(0.8f);
            }
            tickFrequency = tickFrequency != null ? Integer.valueOf(Math.max(1, tickFrequency)) : (aggressiveLevel == 2 ? Integer.valueOf(1) : (aggressiveLevel == 1 ? Integer.valueOf(3) : Integer.valueOf(4)));
            wbcp.tickInterval(tickFrequency.intValue());
            if (onRestart) {
                IWorldDataObject service = (IWorldDataObject)this.serviceCollection.storageManager().getWorldService().getOrNewOnThread(world.getUniqueId());
                service.set(WorldKeys.WORLD_PREGEN_START, true);
                service.set(WorldKeys.WORLD_PREGEN_AGGRESSIVE_LEVEL, aggressiveLevel);
                service.set(WorldKeys.WORLD_PREGEN_SAVE_FREQUENCY, saveTime);
                service.set(WorldKeys.WORLD_PREGEN_TICK_FREQUENCY, tickFrequency);
                service.set(WorldKeys.WORLD_PREGEN_TICK_PERCENT, tickPercent);
                this.serviceCollection.storageManager().getWorldService().save(world.getUniqueId(), service);
            }
            this.pregen.put(world.getUniqueId(), wbcp.start());
            return true;
        }
        return false;
    }

    public boolean cancelPregenRunningForWorld(UUID uuid) {
        this.cleanup();
        if (this.pregen.containsKey(uuid)) {
            ChunkPreGenerate cpg = this.pregen.remove(uuid);
            this.getChannel().send(this.serviceCollection.messageProvider().getMessage("command.pregen.gen.cancelled2", String.valueOf(cpg.getTotalGeneratedChunks()), String.valueOf(cpg.getTotalSkippedChunks()), DurationFormatUtils.formatDuration((long)cpg.getTotalTime().toMillis(), (String)TIME_FORMAT, (boolean)false)));
            cpg.cancel();
            return true;
        }
        return false;
    }

    private synchronized void cleanup() {
        this.pregen.entrySet().removeIf(x -> ((ChunkPreGenerate)x.getValue()).isCancelled());
    }

    private MessageChannel getChannel() {
        return MessageChannel.combined((MessageChannel[])new MessageChannel[]{MessageChannel.TO_CONSOLE, this.serviceCollection.permissionService().permissionMessageChannel("nucleus.world.border.gen.notify")});
    }

    private static class Listener
    implements Consumer<ChunkPreGenerationEvent> {
        private final int aggressiveLevel;
        private final long timeToSave;
        private final INucleusServiceCollection serviceCollection;
        private final boolean notify;
        private final boolean display;
        private final long timeToNotify;
        private boolean highMemTriggered = false;
        private long time = 0L;
        private long lastSaveTime;
        private long lastNotifyTime;

        Listener(INucleusServiceCollection serviceCollection, int aggressiveLevel, long timeToSave, boolean notify, boolean display, long timeToNotify) {
            this.serviceCollection = serviceCollection;
            this.aggressiveLevel = aggressiveLevel;
            this.lastSaveTime = System.currentTimeMillis();
            this.timeToSave = timeToSave;
            this.notify = notify;
            this.display = display;
            this.timeToNotify = timeToNotify;
        }

        @Override
        public void accept(ChunkPreGenerationEvent event) {
            ChunkPreGenerate cpg = event.getChunkPreGenerate();
            if (event instanceof ChunkPreGenerationEvent.Pre) {
                if (this.aggressiveLevel == 0) {
                    long percent = this.getMemPercent();
                    if (percent >= 90L) {
                        if (!this.highMemTriggered) {
                            event.getTargetWorld().getLoadedChunks().forEach(Chunk::unloadChunk);
                            this.save(event.getTargetWorld());
                            this.serviceCollection.messageProvider().getMessage("command.pregen.gen.memory.high", String.valueOf(percent));
                            this.highMemTriggered = true;
                            this.save(event.getTargetWorld());
                        }
                        ((ChunkPreGenerationEvent.Pre)event).setSkipStep(true);
                    } else if (this.highMemTriggered && percent <= 80L) {
                        this.highMemTriggered = false;
                        this.serviceCollection.messageProvider().getMessage("command.pregen.gen.memory.low");
                    }
                }
            } else if (event instanceof ChunkPreGenerationEvent.Post) {
                long time;
                ChunkPreGenerationEvent.Post cpp = (ChunkPreGenerationEvent.Post)event;
                this.time += cpp.getTimeTakenForStep().toMillis();
                Text message = cpp.getChunksSkippedThisStep() > 0 ? this.serviceCollection.messageProvider().getMessage("command.pregen.gen.notifyskipped", String.valueOf(cpp.getChunksGeneratedThisStep()), String.valueOf(cpp.getChunksSkippedThisStep()), DurationFormatUtils.formatDuration((long)cpp.getTimeTakenForStep().toMillis(), (String)WorldHelper.TIME_FORMAT, (boolean)false), DurationFormatUtils.formatDuration((long)cpp.getChunkPreGenerate().getTotalTime().toMillis(), (String)WorldHelper.TIME_FORMAT, (boolean)false), String.valueOf(GenericMath.floor((float)(cpg.getTotalGeneratedChunks() * 100 / cpg.getTargetTotalChunks())))) : this.serviceCollection.messageProvider().getMessage("command.pregen.gen.notify", String.valueOf(cpp.getChunksGeneratedThisStep()), DurationFormatUtils.formatDuration((long)cpp.getTimeTakenForStep().toMillis(), (String)WorldHelper.TIME_FORMAT, (boolean)false), DurationFormatUtils.formatDuration((long)cpp.getChunkPreGenerate().getTotalTime().toMillis(), (String)WorldHelper.TIME_FORMAT, (boolean)false), String.valueOf(GenericMath.floor((float)(cpg.getTotalGeneratedChunks() * 100 / cpg.getTargetTotalChunks()))));
                if (this.notify) {
                    this.getChannel().send(message);
                }
                if (this.lastSaveTime + this.timeToSave < (time = System.currentTimeMillis())) {
                    this.save(event.getTargetWorld());
                }
                if (this.display && this.lastNotifyTime + this.timeToNotify < time) {
                    MessageChannel.TO_ALL.send(this.serviceCollection.messageProvider().getMessage("command.pregen.gen.all"));
                    double total = (double)(100 * (cpg.getTotalGeneratedChunks() + cpg.getTotalSkippedChunks())) / (double)cpg.getTargetTotalChunks();
                    this.getChannel().send(this.serviceCollection.messageProvider().getMessage("command.pregen.gen.quickstatus", PERCENT_FORMAT.format(total), String.valueOf(cpg.getTotalGeneratedChunks() + cpg.getTotalSkippedChunks()), String.valueOf(cpg.getTargetTotalChunks())));
                    this.lastNotifyTime = time;
                }
            } else if (event instanceof ChunkPreGenerationEvent.Complete) {
                this.getChannel().send(this.serviceCollection.messageProvider().getMessage("command.pregen.gen.completed", String.valueOf(cpg.getTotalGeneratedChunks()), String.valueOf(cpg.getTotalSkippedChunks()), DurationFormatUtils.formatDuration((long)this.time, (String)WorldHelper.TIME_FORMAT, (boolean)false), DurationFormatUtils.formatDuration((long)cpg.getTotalTime().toMillis(), (String)WorldHelper.TIME_FORMAT, (boolean)false)));
                this.serviceCollection.storageManager().getWorldService().getOrNew(event.getTargetWorld().getUniqueId()).thenAccept(x -> x.set(WorldKeys.WORLD_PREGEN_START, false));
            }
        }

        private long getMemPercent() {
            long max = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
            long total = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
            long free = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
            return (max - total + free) * 100L / max;
        }

        private void save(World world) {
            this.getChannel().send(this.serviceCollection.messageProvider().getMessage("command.pregen.gen.saving"));
            try {
                world.save();
                this.getChannel().send(this.serviceCollection.messageProvider().getMessage("command.pregen.gen.saved"));
            }
            catch (Throwable e) {
                this.getChannel().send(this.serviceCollection.messageProvider().getMessage("command.pregen.gen.savefailed"));
                e.printStackTrace();
            }
            finally {
                this.lastSaveTime = System.currentTimeMillis();
            }
        }

        private MessageChannel getChannel() {
            return MessageChannel.combined((MessageChannel[])new MessageChannel[]{MessageChannel.TO_CONSOLE, this.serviceCollection.permissionService().permissionMessageChannel("nucleus.world.border.gen.notify")});
        }
    }
}

