/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.listeners;

import io.github.nucleuspowered.nucleus.modules.world.WorldKeys;
import io.github.nucleuspowered.nucleus.modules.world.services.WorldHelper;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IWorldDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.queryobjects.IWorldQueryObject;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.World;

public class WorldGenListener
implements ListenerBase {
    private final INucleusServiceCollection serviceCollection;

    @Inject
    public WorldGenListener(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
    }

    @Listener
    public void onStart(GameStartedServerEvent event) {
        Task.builder().execute(() -> Sponge.getServer().getWorlds().forEach(this::onWorldLoad)).delay(1L, TimeUnit.SECONDS).submit((Object)this.serviceCollection.pluginContainer());
    }

    @Listener
    public void onWorldLoad(LoadWorldEvent event) {
        if (Sponge.getGame().getState() == GameState.SERVER_STARTED) {
            Task.builder().execute(() -> this.onWorldLoad(event.getTargetWorld())).delay(1L, TimeUnit.SECONDS).submit((Object)this.serviceCollection.pluginContainer());
        }
    }

    private void onWorldLoad(World world) {
        WorldHelper worldHelper = this.serviceCollection.getServiceUnchecked(WorldHelper.class);
        CompletableFuture cfo = this.serviceCollection.storageManager().getWorldService().get((IWorldQueryObject)((Object)world.getUniqueId()));
        Task.builder().delay(500L, TimeUnit.MILLISECONDS).interval(500L, TimeUnit.MILLISECONDS).execute(task -> {
            try {
                if (cfo.isDone()) {
                    IWorldDataObject worldDataObject;
                    boolean act;
                    Optional optionalWorldDataObject;
                    task.cancel();
                    if (!cfo.isCompletedExceptionally() && (optionalWorldDataObject = (Optional)cfo.join()).isPresent() && (act = (worldDataObject = (IWorldDataObject)optionalWorldDataObject.get()).get(WorldKeys.WORLD_PREGEN_START).orElse(false).booleanValue()) && worldHelper.startPregenningForWorld(world, worldDataObject.getOrDefault(WorldKeys.WORLD_PREGEN_AGGRESSIVE_LEVEL), worldDataObject.getOrDefault(WorldKeys.WORLD_PREGEN_SAVE_FREQUENCY), worldDataObject.getOrDefault(WorldKeys.WORLD_PREGEN_TICK_PERCENT), worldDataObject.getOrDefault(WorldKeys.WORLD_PREGEN_TICK_FREQUENCY), true)) {
                        this.serviceCollection.messageProvider().sendMessageTo((CommandSource)Sponge.getServer().getConsole(), "command.world.gen.started", world.getName());
                    }
                }
            }
            catch (IllegalStateException e) {
                this.serviceCollection.logger().error("Could not determine World Generation restart status for world {}, WorldProperties could not be loaded from the Sponge World Manager (Sponge.getServer().getWorldProperties({}) returned empty.)", (Object)world.getName(), (Object)world.getUniqueId());
                e.printStackTrace();
            }
        }).submit((Object)this.serviceCollection.pluginContainer());
    }
}

