/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.note.listeners;

import io.github.nucleuspowered.nucleus.modules.note.config.NoteConfig;
import io.github.nucleuspowered.nucleus.modules.note.data.NoteData;
import io.github.nucleuspowered.nucleus.modules.note.services.NoteHandler;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MutableMessageChannel;

public class NoteListener
implements ListenerBase.Conditional {
    private final NoteHandler noteHandler;
    private final IPermissionService permissionService;
    private final IMessageProviderService messageService;
    private final PluginContainer pluginContainer;

    @Inject
    public NoteListener(INucleusServiceCollection serviceCollection) {
        this.noteHandler = serviceCollection.getServiceUnchecked(NoteHandler.class);
        this.permissionService = serviceCollection.permissionService();
        this.messageService = serviceCollection.messageProvider();
        this.pluginContainer = serviceCollection.pluginContainer();
    }

    @Listener
    public void onPlayerLogin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        Sponge.getScheduler().createTaskBuilder().async().delay(500L, TimeUnit.MILLISECONDS).execute(() -> {
            List<NoteData> notes = this.noteHandler.getNotesInternal((User)player);
            if (notes != null && !notes.isEmpty()) {
                MutableMessageChannel messageChannel = this.permissionService.permissionMessageChannel("nucleus.note.showonlogin").asMutable();
                messageChannel.send(this.messageService.getMessage("note.login.notify", player.getName(), String.valueOf(notes.size())).toBuilder().onHover((HoverAction)TextActions.showText((Text)this.messageService.getMessage("note.login.view", player.getName()))).onClick((ClickAction)TextActions.runCommand((String)("/checknotes " + player.getName()))).build());
            }
        }).submit((Object)this.pluginContainer);
    }

    @Override
    public boolean shouldEnable(INucleusServiceCollection serviceCollection) {
        return serviceCollection.moduleDataProvider().getModuleConfig(NoteConfig.class).isShowOnLogin();
    }
}

