/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mail.commands;

import io.github.nucleuspowered.nucleus.modules.mail.commands.MailCommand;
import io.github.nucleuspowered.nucleus.modules.mail.services.MailHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"send", "s", "#sendmail"}, basePermission={"nucleus.mail.send.base"}, commandDescriptionKey="mail.send", async=true, parentCommand=MailCommand.class)
public class SendMailCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection), NucleusParameters.MESSAGE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User pl = context.getOne("user", User.class).orElseThrow(() -> context.createException("args.user.none", new Object[0]));
        if (!context.testPermissionFor((Subject)pl, "nucleus.mail.base")) {
            return context.errorResult("command.mail.send.error", pl.getName());
        }
        String m = context.getOne("message", String.class).orElseThrow(() -> context.createException("args.message.none", new Object[0]));
        MailHandler handler = context.getServiceCollection().getServiceUnchecked(MailHandler.class);
        if (context.is(Player.class)) {
            handler.sendMail((User)context.getIfPlayer(), pl, m);
        } else {
            handler.sendMailFromConsole(pl, m);
        }
        return context.errorResult("command.mail.send.successful", pl.getName());
    }
}

