/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mail.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.mail.NucleusMailService;
import io.github.nucleuspowered.nucleus.api.module.mail.data.MailMessage;
import io.github.nucleuspowered.nucleus.modules.mail.data.MailData;
import io.github.nucleuspowered.nucleus.modules.mail.services.MailHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.Identifiable;

public class MailReadBase {
    public static MailReadBase INSTANCE = new MailReadBase();
    static final String FILTERS = "filters";

    private MailReadBase() {
    }

    public ICommandResult executeCommand(ICommandContext<? extends CommandSource> context, User target, Collection<NucleusMailService.MailFilter> lmf) throws CommandException {
        MailHandler handler = context.getServiceCollection().getServiceUnchecked(MailHandler.class);
        List<MailMessage> lmd = !lmf.isEmpty() ? handler.getMailInternal(target, lmf.toArray(new NucleusMailService.MailFilter[0])) : handler.getMailInternal(target, new NucleusMailService.MailFilter[0]);
        if (lmd.isEmpty()) {
            if (context.is(target)) {
                context.sendMessage(!lmf.isEmpty() ? "command.mail.none.filter" : "command.mail.none.normal.self", new Object[0]);
            } else {
                context.sendMessage(!lmf.isEmpty() ? "command.mail.none.filter" : "command.mail.none.normal.other", target.getName());
            }
            return context.successResult();
        }
        List mails = lmd.stream().sorted(Comparator.comparing(MailMessage::getDate)).map(x -> this.createMessage(context, (MailMessage)x, target)).collect(Collectors.toList());
        PaginationList.Builder b = Util.getPaginationBuilder(context.getCommandSource()).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(this.getHeader(context, target, !lmf.isEmpty())).contents(mails);
        if (!context.is(Player.class)) {
            b.linesPerPage(-1);
        } else {
            b.header(context.getMessage("mail.header", new Object[0]));
        }
        b.sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }

    private Text getHeader(ICommandContext<? extends CommandSource> context, User user, boolean isFiltered) {
        if (context.is(user)) {
            return context.getMessage(isFiltered ? "mail.title.filter.self" : "mail.title.nofilter.self", new Object[0]);
        }
        return context.getMessage(isFiltered ? "mail.title.filter.other" : "mail.title.nofilter.other", user.getName());
    }

    private Text createMessage(ICommandContext<? extends CommandSource> context, MailMessage md, User user) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("MMM dd, yyyy").withZone(ZoneId.systemDefault());
        UUID uuid = this.getUuid(md);
        Text name = context.getServiceCollection().playerDisplayNameService().getDisplayName(uuid);
        return name.toBuilder().color(TextColors.GREEN).style(new TextStyle[]{TextStyles.UNDERLINE}).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.mail.hover", new Object[0]))).onClick((ClickAction)TextActions.executeCallback(src -> {
            src.sendMessage(Text.builder().append(new Text[]{context.getMessage("command.mail.date", new Object[0])}).append(new Text[]{Text.of((Object[])new Object[]{" ", TextColors.WHITE, dtf.format(md.getDate())})}).build());
            Text.Builder tb = Text.builder().append(new Text[]{context.getMessage("command.mail.sender", new Object[0])}).append(new Text[]{Text.of((Object[])new Object[]{" ", TextColors.WHITE, name})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, " - "})});
            if (!uuid.equals(Util.CONSOLE_FAKE_UUID)) {
                tb.append(new Text[]{context.getMessage("standard.reply", new Object[0]).toBuilder().color(TextColors.GREEN).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.mail.reply.label", name))).onClick((ClickAction)TextActions.suggestCommand((String)("/mail send " + name + " "))).build()}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, " - "})});
            }
            src.sendMessage(tb.append(new Text[]{context.getMessage("standard.delete", new Object[0]).toBuilder().color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.mail.delete.label", new Object[0]))).onClick((ClickAction)TextActions.executeCallback(s -> {
                if (context.getServiceCollection().getServiceUnchecked(MailHandler.class).removeMail(user, md)) {
                    context.sendMessage("command.mail.delete.success", new Object[0]);
                } else {
                    context.sendMessage("command.mail.delete.fail", new Object[0]);
                }
            })).build()}).build());
            context.sendMessage("command.mail.message", new Object[0]);
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.WHITE, md.getMessage()}));
        })).append(new Text[]{Text.of((String)(": " + md.getMessage()))}).build();
    }

    private UUID getUuid(MailMessage message) {
        if (message instanceof MailData) {
            return ((MailData)message).getUuid();
        }
        return message.getSender().map(Identifiable::getUniqueId).orElse(Util.CONSOLE_FAKE_UUID);
    }
}

