/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jump.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.modules.jump.config.JumpConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@NonnullByDefault
@Command(aliases={"thru", "through"}, basePermission={"nucleus.thru.base"}, commandDescriptionKey="thru", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.thru.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.thru.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.thru.exempt.cost")})
public class ThruCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private int maxThru = 20;

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player player = context.getIfPlayer();
        BlockRay playerBlockRay = BlockRay.from((Entity)player).distanceLimit((double)this.maxThru).build();
        World world = player.getWorld();
        while (playerBlockRay.hasNext() && world.getBlockType(playerBlockRay.next().getBlockPosition()).equals(BlockTypes.AIR)) {
        }
        if (!playerBlockRay.hasNext()) {
            return context.errorResult("command.thru.nowall", new Object[0]);
        }
        do {
            BlockRayHit b = playerBlockRay.next();
            if (!player.getWorld().getBlockType(b.getBlockPosition()).equals(BlockTypes.AIR)) continue;
            if (!Util.isLocationInWorldBorder((Location<World>)b.getLocation())) {
                return context.errorResult("command.jump.outsideborder", new Object[0]);
            }
            boolean result = context.getServiceCollection().teleportService().teleportPlayerSmart(player, (Location<World>)b.getLocation(), false, true, TeleportScanners.NO_SCAN.get()).isSuccessful();
            if (result) {
                context.sendMessage("command.thru.success", new Object[0]);
                return context.successResult();
            }
            return context.errorResult("command.thru.notsafe", new Object[0]);
        } while (playerBlockRay.hasNext());
        return context.errorResult("command.thru.nospot", new Object[0]);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.maxThru = serviceCollection.moduleDataProvider().getModuleConfig(JumpConfig.class).getMaxThru();
    }
}

