/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands;

import io.github.nucleuspowered.nucleus.quickstart.annotation.RequireExistenceOf;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.mutable.item.PlainPagedData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.plugin.meta.util.NonnullByDefault;

@NonnullByDefault
@RequireExistenceOf(value="org.spongepowered.api.data.manipulator.mutable.item.PlainPagedData")
@Command(aliases={"unsignbook", "unsign"}, basePermission={"nucleus.unsignbook.base"}, commandDescriptionKey="unsignbook", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.unsignbook.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.unsignbook.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.unsignbook.exempt.cost")}, associatedPermissions={"nucleus.unsignbook.others"})
public class UnsignBookCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOnlyOtherUserPermissionElement(true, "nucleus.unsignbook.others")};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User target = context.getUserFromArgs();
        boolean isSelf = context.is(target);
        Optional<ItemStack> bookToUnsign = target.getItemInHand(HandTypes.MAIN_HAND).filter(item -> item.getType().equals(ItemTypes.WRITTEN_BOOK));
        if (bookToUnsign.isPresent()) {
            ItemStack unsignedBook = ItemStack.builder().itemType(ItemTypes.WRITABLE_BOOK).itemData((DataManipulator)bookToUnsign.get().get(Keys.BOOK_PAGES).map(this::from).orElseGet(this::createData)).quantity(bookToUnsign.get().getQuantity()).build();
            target.setItemInHand(HandTypes.MAIN_HAND, unsignedBook);
            if (isSelf) {
                context.sendMessage("command.unsignbook.success.self", new Object[0]);
            } else {
                context.sendMessage("command.unsignbook.success.other", target.getName());
            }
            return context.successResult();
        }
        if (isSelf) {
            return context.errorResult("command.unsignbook.notinhand.self", new Object[0]);
        }
        return context.errorResult("command.unsignbook.notinhand.other", target.getName());
    }

    private PlainPagedData from(List<Text> texts) {
        PlainPagedData ppd = this.createData();
        for (Text text : texts) {
            ppd.addElement((Object)TextSerializers.FORMATTING_CODE.serialize(text));
        }
        return ppd;
    }

    private PlainPagedData createData() {
        return (PlainPagedData)((DataManipulatorBuilder)Sponge.getDataManager().getManipulatorBuilder(PlainPagedData.class).get()).create();
    }
}

