/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.invulnerability.services;

import io.github.nucleuspowered.nucleus.api.module.invulnerability.NucleusInvulnerabilityService;
import io.github.nucleuspowered.nucleus.modules.invulnerability.InvulnerabilityKeys;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.scaffold.service.annotations.APIService;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@APIService(value=NucleusInvulnerabilityService.class)
@NonnullByDefault
public class InvulnerabilityService
implements NucleusInvulnerabilityService,
ContextCalculator<Subject>,
ServiceBase {
    private final Map<UUID, Integer> previousHungerValues = new HashMap<UUID, Integer>();
    private final Map<UUID, Boolean> invulnerabilityCache = new HashMap<UUID, Boolean>();
    private final Context context = new Context("nucleus-invulnerable", "true");
    private final INucleusServiceCollection serviceCollection;

    @Inject
    public InvulnerabilityService(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
    }

    public void accumulateContexts(Subject calculable, Set<Context> accumulator) {
        if (calculable instanceof Player && this.isInvulnerable((User)((Player)calculable))) {
            accumulator.add(this.context);
        }
    }

    public boolean matches(Context context, Subject calculable) {
        return this.context.equals((Object)context) && calculable instanceof Player && this.isInvulnerable((User)((Player)calculable));
    }

    @Override
    public boolean isInvulnerable(User user) {
        Optional op = user.getPlayer();
        if (op.isPresent()) {
            return this.invulnerabilityCache.computeIfAbsent(user.getUniqueId(), uuid -> this.serviceCollection.storageManager().getUserService().getOnThread(user.getUniqueId()).flatMap(x -> x.get(InvulnerabilityKeys.INVLUNERABLE)).orElse(false));
        }
        return this.serviceCollection.storageManager().getUserService().getOnThread(user.getUniqueId()).flatMap(x -> x.get(InvulnerabilityKeys.INVLUNERABLE)).orElse(false);
    }

    @Override
    public void setInvulnerable(User user, boolean invulnerable) {
        this.serviceCollection.storageManager().getUserService().setAndSave(user.getUniqueId(), InvulnerabilityKeys.INVLUNERABLE, invulnerable);
        if (invulnerable) {
            user.getPlayer().ifPresent(x -> this.previousHungerValues.put(x.getUniqueId(), x.get(Keys.FOOD_LEVEL).orElse(20)));
        } else {
            Integer i = this.previousHungerValues.get(user.getUniqueId());
            if (i != null) {
                user.getPlayer().ifPresent(p -> p.offer(Keys.FOOD_LEVEL, (Object)i));
            }
        }
        user.getPlayer().ifPresent(x -> this.invulnerabilityCache.put(user.getUniqueId(), invulnerable));
    }

    public void removeFromCache(UUID uuid) {
        this.invulnerabilityCache.remove(uuid);
    }
}

