/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.ignore.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.ignore.services.IgnoreService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerDisplayNameService;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"ignorelist", "listignore", "ignored"}, basePermission={"nucleus.ignorelist.base"}, commandDescriptionKey="ignorelist", async=true, associatedPermissions={"nucleus.ignorelist.others"})
public class IgnoreListCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOnlyOtherUserPermissionElement(false, "nucleus.ignorelist.others")};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        IgnoreService ignoreService = context.getServiceCollection().getServiceUnchecked(IgnoreService.class);
        Player target = context.getPlayerFromArgs();
        boolean isSelf = context.is((User)target);
        IPlayerDisplayNameService playerDisplayNameService = context.getServiceCollection().playerDisplayNameService();
        List ignoredList = ignoreService.getAllIgnored(target.getUniqueId()).stream().map(playerDisplayNameService::getDisplayName).collect(Collectors.toList());
        if (ignoredList.isEmpty()) {
            if (isSelf) {
                context.sendMessage("command.ignorelist.noignores.self", new Object[0]);
            } else {
                context.sendMessage("command.ignorelist.noignores.other", target);
            }
        } else {
            Util.getPaginationBuilder(context.getCommandSource()).contents(ignoredList).title(context.getMessage("command.ignorelist.header", target)).sendTo((MessageReceiver)context.getCommandSource());
        }
        return context.successResult();
    }
}

