/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.home.parameters;

import io.github.nucleuspowered.nucleus.modules.home.parameters.HomeArgument;
import io.github.nucleuspowered.nucleus.modules.home.services.HomeService;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.DisplayNameArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class HomeOtherArgument
extends HomeArgument {
    private final DisplayNameArgument nickArg;
    private final IPermissionService permissionService;

    public HomeOtherArgument(@Nullable Text key, HomeService homeService, INucleusServiceCollection serviceCollection) {
        super(key, homeService, serviceCollection.messageProvider());
        this.nickArg = new DisplayNameArgument((Text)Text.of((String)"user"), DisplayNameArgument.Target.USER, serviceCollection);
        this.permissionService = serviceCollection.permissionService();
    }

    @Override
    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String player = args.next();
        Optional ohome = args.nextIfPresent();
        if (!ohome.isPresent()) {
            throw args.createError(this.messageProviderService.getMessageFor(source, "args.homeother.notenough"));
        }
        Set<?> users = this.nickArg.parseValue(source, player.toLowerCase(), (key, entry) -> args.createError(this.messageProviderService.getMessageFor(source.getLocale(), (String)key, (String)entry)));
        if (users.size() != 1) {
            throw args.createError(this.messageProviderService.getMessageFor(source.getLocale(), "args.homeother.ambiguous"));
        }
        User user = (User)users.iterator().next();
        if (this.permissionService.hasPermission((Subject)user, "nucleus.home.other.exempt.target")) {
            throw args.createError(this.messageProviderService.getMessageFor(source.getLocale(), "args.homeother.exempt"));
        }
        return this.getHome(user, source, (String)ohome.get(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        CommandArgs.Snapshot saveState = null;
        try {
            saveState = args.getSnapshot();
            String arg1 = args.next();
            Optional arg2 = args.nextIfPresent();
            if (arg2.isPresent()) {
                Set<?> u = this.nickArg.parseValue(src, arg1.toLowerCase(), (key, entry) -> args.createError(this.messageProviderService.getMessageFor(src.getLocale(), (String)key, (String)entry)));
                if (u.size() != 1) {
                    throw args.createError(this.messageProviderService.getMessageFor(src.getLocale(), "args.homeother.ambiguous"));
                }
                User user = (User)u.iterator().next();
                List<String> list = this.complete(user, (String)arg2.get());
                return list;
            }
            args.applySnapshot(saveState);
            List<String> list = this.nickArg.complete(src, args, context);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (saveState != null) {
                args.applySnapshot(saveState);
            }
        }
        return Collections.emptyList();
    }

    public Text getUsage(CommandSource src) {
        return Text.of((String)"<user> <home>");
    }
}

