/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.util.TypeTokens;
import java.util.Collection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"kill"}, basePermission={"nucleus.kill.base"}, commandDescriptionKey="kill", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.kill.exempt.warmup"), @CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.kill.exempt.cooldown"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.kill.exempt.cost")})
@EssentialsEquivalent(value={"kill", "remove", "butcher", "killall", "mobkill"}, isExact=false, notes="Nucleus supports killing entities using the Minecraft selectors.")
@NonnullByDefault
public class KillCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.MANY_ENTITY.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Collection<Entity> entities = context.getAll("subject", TypeTokens.ENTITY);
        int entityKillCount = 0;
        int playerKillCount = 0;
        for (Entity x : entities) {
            DataTransactionResult dtr = x.offer(Keys.HEALTH, (Object)0.0);
            if (!dtr.isSuccessful() && !(x instanceof Living)) {
                x.remove();
            }
            ++entityKillCount;
            if (!(x instanceof Player)) continue;
            Player pl = (Player)x;
            ++playerKillCount;
            context.sendMessage("command.kill.killed", pl.getName());
            context.sendMessageTo((MessageReceiver)pl, "command.kill.killedby", context.getCommandSource().getName());
        }
        if (entityKillCount > playerKillCount) {
            context.sendMessage("command.kill.overall", entityKillCount, playerKillCount);
        }
        return context.successResult();
    }
}

